/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.exception;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.hutool.core.exceptions.ExceptionUtil;
import io.github.nier6088.SimpleProjectApplicationAutoConfiguration;
import io.github.nier6088.enums.ServiceStateCodeEnum;
import io.github.nier6088.exception.ClientException;
import io.github.nier6088.exception.HeaderValidateException;
import io.github.nier6088.exception.ParamValidateException;
import io.github.nier6088.exception.ServiceException;
import io.github.nier6088.mapper.ServiceReqErrorLogInfoMapper;
import io.github.nier6088.model.entity.ServiceErrorLogInfoEntity;
import io.github.nier6088.util.ServletUtils;
import io.github.nier6088.wrapper.ResultData;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionsHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionsHandler.class);
    @Autowired
    private ServiceReqErrorLogInfoMapper serviceReqErrorLogInfoMapper;

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResultData handleNoHandlerFoundException() {
        return ResultData.fail(ServiceStateCodeEnum.SERVICE_STATE_SERVER_NOT_FOUND);
    }

    @ExceptionHandler(value={HeaderValidateException.class})
    public ResultData handleHeaderValidateException(HeaderValidateException headerValidateException) {
        return ResultData.fail(ServiceStateCodeEnum.SERVICE_STATE_HEADER_VALIDATE_ERROR);
    }

    @ExceptionHandler(value={ParamValidateException.class})
    public ResultData handleParamValidateException(ParamValidateException paramValidateException) {
        Integer errorCode = paramValidateException.getErrorCode();
        String message = paramValidateException.getMessage();
        return ResultData.fail(errorCode, message);
    }

    @ExceptionHandler(value={NotLoginException.class})
    public ResultData handleNotLoginException(NotLoginException notLoginException) {
        return ResultData.failClient(ServiceStateCodeEnum.SERVICE_STATE_ACCOUNT_NOT_LOGIN_ERROR);
    }

    @ExceptionHandler(value={NotPermissionException.class})
    public ResultData handleNotPermissionException(NotPermissionException notPermissionException) {
        return ResultData.failClient(ServiceStateCodeEnum.SERVICE_STATE_ACCOUNT_NO_PERMISSION_ERROR);
    }

    @ExceptionHandler(value={BindException.class})
    public ResultData handBindException(BindException e) {
        FieldError fieldError;
        log.error(e.getMessage(), (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        String errMsg = "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38";
        if (bindingResult.hasErrors() && (fieldError = bindingResult.getFieldError()) != null) {
            errMsg = fieldError.getDefaultMessage();
        }
        return ResultData.failClient(ServiceStateCodeEnum.SERVICE_STATE_PARAM_VALIDATE_ERROR.getCode(), errMsg);
    }

    @ExceptionHandler(value={ClientException.class})
    public ResultData handleClientException(ClientException clientException) {
        Integer errorCode = clientException.getErrorCode();
        String message = clientException.getMessage();
        return ResultData.failClient(errorCode, message);
    }

    @ExceptionHandler(value={ServiceException.class})
    public ResultData handleServiceException(ServiceException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.insertError(e);
        return ResultData.fail(e.getErrorCode(), e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultData handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        FieldError fieldError;
        log.error(e.getMessage(), (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        String errMsg = "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38";
        if (bindingResult.hasErrors() && (fieldError = bindingResult.getFieldError()) != null) {
            errMsg = fieldError.getDefaultMessage();
        }
        return ResultData.fail(ServiceStateCodeEnum.SERVICE_STATE_PARAM_VALIDATE_ERROR, errMsg);
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public ResultData handleDuplicateKeyException(DuplicateKeyException e) {
        log.error(e.getMessage(), (Throwable)e);
        return ResultData.failClient(ServiceStateCodeEnum.SERVICE_STATE_DATA_DUPLICATE_KEY.getCode(), ServiceStateCodeEnum.SERVICE_STATE_DATA_DUPLICATE_KEY.getDescribe());
    }

    @ExceptionHandler(value={Exception.class})
    public ResultData handleException(HttpServletRequest request, Exception e) {
        String reqURI = request.getRequestURI();
        log.error(reqURI, (Object)e.getMessage(), (Object)e);
        this.insertError(e);
        return ResultData.fail(ServiceStateCodeEnum.SERVICE_STATE_ERROR);
    }

    public void insertError(Exception e) {
        try {
            Date date = new Date();
            HttpServletRequest request = ServletUtils.getRequest();
            String requestURI = request.getRequestURL().toString();
            String requestId = MDC.get((String)"reqId");
            ServiceErrorLogInfoEntity serviceErrorLogInfo = new ServiceErrorLogInfoEntity();
            serviceErrorLogInfo.setErrorTime(date);
            serviceErrorLogInfo.setReqId(requestId);
            serviceErrorLogInfo.setErrorName(e.getMessage());
            serviceErrorLogInfo.setErrorReqUri(requestURI);
            String errorStack = this.getStackTrace(e);
            serviceErrorLogInfo.setErrorInfo(errorStack);
            String errorSource = this.getErrorSource(e);
            serviceErrorLogInfo.setErrorSource(errorSource);
            String remoteAddr = request.getRemoteAddr();
            serviceErrorLogInfo.setReqIp(remoteAddr);
            this.serviceReqErrorLogInfoMapper.insert(serviceErrorLogInfo);
        }
        catch (Exception exception) {
            log.error("\u63d2\u5165\u9519\u8bef\u65e5\u5fd7\u8868\u5931\u8d25,\u6e90\u5f02\u5e38\uff1a{}", (Object)e, (Object)exception);
        }
    }

    private String getErrorSource(Exception e) {
        String methodName;
        String className;
        Package aPackage = SimpleProjectApplicationAutoConfiguration.class.getPackage();
        String name = aPackage.getName();
        StackTraceElement[] stackTrace = e.getStackTrace();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stackTrace.length; ++i) {
            className = stackTrace[i].getClassName();
            methodName = stackTrace[i].getMethodName();
            int lineNumber = stackTrace[i].getLineNumber();
            if (!className.startsWith(name) || lineNumber == -1) continue;
            String fileName = stackTrace[i].getFileName();
            stringBuilder.append(className).append("#").append(methodName).append(", ").append(fileName).append(":").append(lineNumber).append("; \r\n ");
        }
        String errorSource = stringBuilder.toString();
        log.info("errorSource =[ \r\n {} ] ", (Object)errorSource);
        if (StringUtils.isNotBlank((CharSequence)errorSource)) {
            return errorSource;
        }
        className = stackTrace[0].getClassName();
        methodName = stackTrace[0].getMethodName();
        String fileName = stackTrace[0].getFileName();
        int lineNumber = stackTrace[0].getLineNumber();
        return className + "#" + methodName + ", " + fileName + ":" + lineNumber;
    }

    private String getStackTrace(Exception e) {
        return ExceptionUtil.stacktraceToOneLineString((Throwable)e, (int)500);
    }
}

