/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.exception;

import io.github.nier6088.enums.ServiceStateCodeEnum;

public class ServiceException
extends RuntimeException {
    private int code;
    private String message;
    private Integer errorCode;

    public ServiceException(int errorCode, String message) {
        this.code = 400;
        this.message = message;
        this.errorCode = errorCode;
    }

    public ServiceException(ServiceStateCodeEnum serviceStateCodeEnum) {
        this.code = 400;
        this.message = serviceStateCodeEnum.getDescribe();
        this.errorCode = serviceStateCodeEnum.getCode();
    }

    public ServiceException(ServiceStateCodeEnum serviceStateCodeEnum, Exception ex) {
        super(ex);
        this.code = 400;
        this.message = serviceStateCodeEnum.getDescribe();
        this.errorCode = serviceStateCodeEnum.getCode();
    }

    public ServiceException(int code, ServiceStateCodeEnum serviceStateCodeEnum) {
        this.code = code;
        this.message = serviceStateCodeEnum.getDescribe();
        this.errorCode = serviceStateCodeEnum.getCode();
    }

    public ServiceException(int errorCode, String message, int code) {
        this.code = code;
        this.message = message;
        this.errorCode = errorCode;
    }

    public ServiceException(String message, int code) {
        this.code = code;
        this.message = message;
    }

    public ServiceException(Object o) {
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceException)) {
            return false;
        }
        ServiceException other = (ServiceException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Integer this$errorCode = this.getErrorCode();
        Integer other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)this$errorCode).equals(other$errorCode)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        Integer $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)$errorCode).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ServiceException(code=" + this.getCode() + ", message=" + this.getMessage() + ", errorCode=" + this.getErrorCode() + ")";
    }
}

