/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.filter;

import io.github.nier6088.constants.BusConstant;
import io.github.nier6088.util.RequestBodyDataSignUtil;
import io.github.nier6088.util.SpringContextUtil;
import io.github.nier6088.wrapper.GlobalHttpServletRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=-1)
@Component
public class GlobalHttpServletRequestReplacedFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalHttpServletRequestReplacedFilter.class);
    @Autowired
    private RequestBodyDataSignUtil requestBodyDataSignUtil;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        GlobalHttpServletRequestWrapper requestWrapper = null;
        if (request instanceof HttpServletRequest) {
            System.out.printf("\r\n\u8bf7\u6c42URL:%s\r\n", ((HttpServletRequest)request).getRequestURL());
            String requestURL = ((HttpServletRequest)request).getRequestURL().toString();
            boolean filterResult = BusConstant.NO_FILTER_REQ_URLS.stream().noneMatch(info -> requestURL.contains((CharSequence)info));
            if (filterResult) {
                requestWrapper = SpringContextUtil.isDeveloperMode() ? new GlobalHttpServletRequestWrapper((HttpServletRequest)request) : this.requestBodyDataSignUtil.getNewHttpServletRequestFromDataSign((HttpServletRequest)request);
            }
        }
        if (requestWrapper == null) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter(requestWrapper, response);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) {
    }
}

