/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.nier6088.annotation.ClickLimit;
import io.github.nier6088.enums.ServiceStateCodeEnum;
import io.github.nier6088.util.GlobalRequestInfoThreadLocalUtil;
import io.github.nier6088.util.ResponseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.MDC;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Order(value=-1)
@Component
public class RequestHandlerInterceptor
implements HandlerInterceptor {
    RequestHandler signDataHandler = (req, res, m) -> {
        try {
            byte[] requestBody = StreamUtils.copyToByteArray((InputStream)req.getInputStream());
            ObjectMapper objectMapper = new ObjectMapper();
            RequestSignData requestSignData = (RequestSignData)objectMapper.readValue((InputStream)req.getInputStream(), RequestSignData.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    };
    RequestHandler requestClickLimitHandler = (req, res, handlerMethod) -> {
        Method method = handlerMethod.getMethod();
        ClickLimit annotation = method.getAnnotation(ClickLimit.class);
        if (Objects.isNull(annotation)) {
            return true;
        }
        long expire = TimeUnit.SECONDS.toMillis(annotation.expire());
        HttpSession session = req.getSession();
        Long lastRequestTime = (Long)session.getAttribute("SUBMIT_LIMIT");
        long currentTimeMillis = System.currentTimeMillis();
        if (Objects.isNull(lastRequestTime) || currentTimeMillis - lastRequestTime >= expire) {
            session.setAttribute("SUBMIT_LIMIT", (Object)currentTimeMillis);
            return true;
        }
        String message = annotation.message();
        ServiceStateCodeEnum serviceStateRequestLimitError = ServiceStateCodeEnum.SERVICE_STATE_REQUEST_LIMIT_ERROR;
        if (StringUtils.isNotBlank((CharSequence)message)) {
            // empty if block
        }
        ResponseUtil.write(res, serviceStateRequestLimitError);
        return false;
    };
    RequestHandler requestIdHandler = (req, res, m) -> {
        String requestId = Optional.ofNullable(req.getHeader("reqId")).orElse(cn.hutool.core.lang.UUID.fastUUID().toString());
        MDC.put((String)"reqId", (Object)requestId);
        return true;
    };
    RequestHandler requestTenantHandler = (req, res, m) -> {
        GlobalRequestInfoThreadLocalUtil.setInfo(UUID.randomUUID().toString());
        return true;
    };
    List<RequestHandler> stream = Stream.of(this.requestIdHandler, this.requestTenantHandler, this.requestClickLimitHandler).collect(Collectors.toList());

    public boolean handler(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        for (RequestHandler requestHandler : this.stream) {
            if (requestHandler.handler(request, response, handlerMethod)) continue;
            return false;
        }
        return true;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return this.handler(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        MDC.clear();
        GlobalRequestInfoThreadLocalUtil.clear();
        super.afterCompletion(request, response, handler, ex);
    }

    class RequestSignData {
        private String data;
        private String sign;

        public String getData() {
            return this.data;
        }

        public String getSign() {
            return this.sign;
        }

        public void setData(String data) {
            this.data = data;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestSignData)) {
                return false;
            }
            RequestSignData other = (RequestSignData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$sign = this.getSign();
            String other$sign = other.getSign();
            return !(this$sign == null ? other$sign != null : !this$sign.equals(other$sign));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestSignData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $sign = this.getSign();
            result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
            return result;
        }

        public String toString() {
            return "RequestHandlerInterceptor.RequestSignData(data=" + this.getData() + ", sign=" + this.getSign() + ")";
        }
    }

    @FunctionalInterface
    public static interface RequestHandler {
        public boolean handler(HttpServletRequest var1, HttpServletResponse var2, HandlerMethod var3);
    }
}

