/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.pool;

import java.util.Map;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class DefaultMdcDecorator
implements TaskDecorator {
    public Runnable decorate(Runnable runnable) {
        RequestAttributes context = RequestContextHolder.currentRequestAttributes();
        Map previous = MDC.getCopyOfContextMap();
        return () -> {
            try {
                RequestContextHolder.setRequestAttributes((RequestAttributes)context);
                if (null != previous) {
                    MDC.setContextMap((Map)previous);
                }
                runnable.run();
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
                MDC.clear();
            }
        };
    }
}

