/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDataUtil {
    private static final Logger log = LoggerFactory.getLogger(QueryDataUtil.class);

    public static <T, K, U> Map<K, U> listToMap(List<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return list.stream().filter(item -> Objects.nonNull(keyMapper.apply(item))).filter(item -> Objects.nonNull(valueMapper.apply(item))).collect(Collectors.toMap(keyMapper, valueMapper, (k1, k2) -> k2));
    }

    public static <T, K, U> Map<K, U> listToMap(List<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return list.stream().filter(item -> Objects.nonNull(keyMapper.apply(item))).filter(item -> Objects.nonNull(valueMapper.apply(item))).collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction));
    }

    public static <T, K> Map<K, T> listToKeyIdentity(List<T> list, Function<? super T, ? extends K> keyMapper) {
        return list.stream().filter(item -> Objects.nonNull(keyMapper.apply(item))).collect(Collectors.toMap(keyMapper, Function.identity(), (k1, k2) -> k1));
    }

    public static <T, K> Map<K, T> listToKeyIdentity(List<T> list, Function<? super T, ? extends K> keyMapper, BinaryOperator<T> mergeFunction) {
        return list.stream().filter(item -> Objects.nonNull(keyMapper.apply(item))).collect(Collectors.toMap(keyMapper, Function.identity(), mergeFunction));
    }

    public static <T, K> K objToMap(T obj, Function<? super T, ? extends K> mapping) {
        return Optional.ofNullable(obj).filter(item -> Objects.nonNull(mapping.apply(item))).map(mapping).orElse(null);
    }

    public static <T, K> Map<K, List<T>> listToGroupByMap(List<T> list, Function<? super T, ? extends K> groupByKey) {
        return list.stream().filter(item -> Objects.nonNull(groupByKey.apply(item))).collect(Collectors.groupingBy(groupByKey));
    }

    public static <T, K> Map<K, Long> listToGroupByCountMap(List<T> list, Function<? super T, ? extends K> groupByKey) {
        return list.stream().filter(item -> Objects.nonNull(groupByKey.apply(item))).collect(Collectors.groupingBy(groupByKey, Collectors.counting()));
    }

    public static <T> List<T> listProcessNewList(List<T> list, Consumer<T> consumer) {
        return list.stream().peek(item -> consumer.accept(item)).collect(Collectors.toList());
    }

    public static <T> void listProcess(List<T> list, Consumer<T> consumer) {
        list.stream().forEach(consumer);
    }

    public static <T> void listProcess(List<T> list, BiConsumer<List<T>, T> consumer) {
        list.stream().forEach(item -> consumer.accept(list, item));
    }

    public static <T, K> List<K> listProcessNewList(List<T> list, Function<T, K> function, Consumer<K> consumer) {
        return list.stream().map(function).peek(item -> consumer.accept(item)).collect(Collectors.toList());
    }

    public static <T, K> List<K> listConvert(List<T> list, Function<T, K> function) {
        return list.stream().map(function).collect(Collectors.toList());
    }
}

