/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.util;

import cn.hutool.core.util.RandomUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class RedisCacheUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheUtil.class);
    @Autowired
    @Qualifier(value="redisTemplate")
    public RedisTemplate redisTemplate;

    public <T> ValueOperations<String, T> setCacheObject(String key, T value, long time) {
        log.info("[setObject-key] = " + key + " [value] = " + value);
        ValueOperations operation = this.redisTemplate.opsForValue();
        operation.set((Object)key, value, time += RandomUtil.randomLong((long)1L, (long)30L), TimeUnit.SECONDS);
        return operation;
    }

    public <T> T getCacheObject(String key) {
        log.info("[getObject-key] = " + key);
        ValueOperations operation = this.redisTemplate.opsForValue();
        Object value = operation.get((Object)key);
        log.info("[getObject-key] = " + key + " [getObject-value] = " + value);
        return (T)value;
    }

    public <T> ListOperations<String, T> setCacheList(String key, List<T> dataList) {
        ListOperations listOperation = this.redisTemplate.opsForList();
        if (null != dataList) {
            int size = dataList.size();
            for (int i = 0; i < size; ++i) {
                listOperation.rightPush((Object)key, dataList.get(i));
            }
        }
        return listOperation;
    }

    public <T> List<T> getCacheList(String key) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        ListOperations listOperation = this.redisTemplate.opsForList();
        Long size = listOperation.size((Object)key);
        int i = 0;
        while ((long)i < size) {
            dataList.add(listOperation.leftPop((Object)key));
            ++i;
        }
        return dataList;
    }

    public <T> BoundSetOperations<String, T> setCacheSet(String key, Set<T> dataSet) {
        BoundSetOperations setOperation = this.redisTemplate.boundSetOps((Object)key);
        Iterator<T> it = dataSet.iterator();
        while (it.hasNext()) {
            setOperation.add(new Object[]{it.next()});
        }
        return setOperation;
    }

    public Set<T> getCacheSet(String key) {
        HashSet<Object> dataSet = new HashSet<Object>();
        BoundSetOperations operation = this.redisTemplate.boundSetOps((Object)key);
        Long size = operation.size();
        int i = 0;
        while ((long)i < size) {
            dataSet.add(operation.pop());
            ++i;
        }
        return dataSet;
    }

    public <T> HashOperations<String, String, T> setCacheMap(String key, Map<String, T> dataMap) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        if (null != dataMap) {
            for (Map.Entry<String, T> entry : dataMap.entrySet()) {
                hashOperations.put((Object)key, (Object)entry.getKey(), entry.getValue());
            }
        }
        return hashOperations;
    }

    public <T> Map<String, T> getCacheMap(String key) {
        Map map = this.redisTemplate.opsForHash().entries((Object)key);
        return map;
    }

    public <T> HashOperations<String, Integer, T> setCacheIntegerMap(String key, Map<Integer, T> dataMap) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        if (null != dataMap) {
            for (Map.Entry<Integer, T> entry : dataMap.entrySet()) {
                hashOperations.put((Object)key, (Object)entry.getKey(), entry.getValue());
            }
        }
        return hashOperations;
    }

    public <T> Map<Integer, T> getCacheIntegerMap(String key) {
        Map map = this.redisTemplate.opsForHash().entries((Object)key);
        return map;
    }

    public boolean removeSingleCache(String key) {
        try {
            log.info("[removeSingleCache] = " + key);
            this.redisTemplate.delete((Object)key);
            return true;
        }
        catch (Throwable t) {
            log.error("\u83b7\u53d6\u7f13\u5b58\u5931\u8d25key[" + key + ", error[" + t + "]");
            return false;
        }
    }

    public Set<T> getCacheSetForRandomEle(String key, long count) {
        log.info("[getCacheSetForRandomEle] = " + key);
        Set dataSet = this.redisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
        return dataSet;
    }

    public Long addEleToSet(String key, T value) {
        return this.redisTemplate.opsForSet().add((Object)key, new Object[]{value});
    }

    public boolean removeEleInSet(String key, Object o) {
        Long result = this.redisTemplate.opsForSet().remove((Object)key, new Object[]{o});
        this.checkResult(result);
        return result == 1L;
    }

    protected void checkResult(@Nullable Object obj) {
        if (obj == null) {
            throw new IllegalStateException("Cannot read collection with Redis connection in pipeline/multi-exec mode");
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public boolean hashHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public void hashdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public Cursor hashCursor(String key, long count) {
        Cursor cursor = this.redisTemplate.opsForHash().scan((Object)key, ScanOptions.scanOptions().count(1000L).build());
        return cursor;
    }

    public Object hashget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public long hashIncr(String key, String field, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)field, delta);
    }

    public <T> ListOperations<String, T> setSingleCacheToList(String key, T data, long time) {
        ListOperations listOperation = this.redisTemplate.opsForList();
        if (null != data) {
            if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
                listOperation.rightPush((Object)key, data);
            } else {
                listOperation.rightPush((Object)key, data);
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
        }
        return listOperation;
    }

    public <T> List<T> getCacheListNoDel(String key) {
        ListOperations listOperation = this.redisTemplate.opsForList();
        List dataList = listOperation.range((Object)key, 0L, -1L);
        return dataList;
    }

    public <T> SetOperations<String, T> setSingleCacheToSet(String key, T data, long time) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        if (null != data) {
            if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
                setOperations.add((Object)key, new Object[]{data});
            } else {
                setOperations.add((Object)key, new Object[]{data});
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
        }
        return setOperations;
    }

    public <T> Set<T> getCacheSetNoDel(String key) {
        SetOperations setOperation = this.redisTemplate.opsForSet();
        Set dataSet = setOperation.members((Object)key);
        return dataSet;
    }
}

