/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.util;

import cn.hutool.extra.servlet.ServletUtil;
import io.github.nier6088.enums.ServiceStateCodeEnum;
import io.github.nier6088.exception.ClientException;
import io.github.nier6088.model.RequestBodyDataSignDTO;
import io.github.nier6088.util.ObjectMapperUtil;
import io.github.nier6088.util.ResponseUtil;
import io.github.nier6088.wrapper.GlobalHttpServletRequestWrapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class RequestBodyDataSignUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestBodyDataSignUtil.class);
    @Value(value="${request.sign.key}")
    private String key;
    @Autowired
    private HttpServletResponse httpServletResponse;

    private RequestBodyDataSignDTO getHeaderSignParam(HttpServletRequest httpServletRequest) {
        String body = ServletUtil.getBody((ServletRequest)httpServletRequest);
        return ObjectMapperUtil.toObject(body, RequestBodyDataSignDTO.class);
    }

    public HttpServletRequest getNewHttpServletRequestFromDataSign(HttpServletRequest httpServletRequest) {
        RequestBodyDataSignDTO requestBodyDataSignParam = this.getHeaderSignParam(httpServletRequest);
        log.info("getNewHttpServletRequestFromDataSign\uff1a{}", (Object)httpServletRequest.getRequestURI());
        this.verify(requestBodyDataSignParam);
        String data = requestBodyDataSignParam.getData();
        byte[] body = Base64Utils.decodeFromString((String)data);
        try {
            return new GlobalHttpServletRequestWrapper(httpServletRequest, body);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void verify(RequestBodyDataSignDTO requestBodyDataSignDTO) {
        String data = requestBodyDataSignDTO.getData();
        String sign = requestBodyDataSignDTO.getSign();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{data, sign})) {
            throw new ClientException(ServiceStateCodeEnum.SERVICE_STATE_CLIENT_SIGN_ERROR);
        }
        String computeSign = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, this.key.getBytes(StandardCharsets.UTF_8)).hmacHex(data.getBytes(StandardCharsets.UTF_8));
        boolean verify = StringUtils.equals((CharSequence)sign, (CharSequence)computeSign);
        if (!verify) {
            ResponseUtil.write(this.httpServletResponse, ServiceStateCodeEnum.SERVICE_STATE_CLIENT_SIGN_ERROR);
            throw new RuntimeException("\u8bf7\u6c42\u6765\u6e90\u4e0d\u6b63\u786e,\u8bf7\u6c42\u7ec8\u6b62");
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }
}

