/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.util;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SpringContextUtil
implements ApplicationContextAware {
    private static ApplicationContext context;

    public static boolean isProdMode() {
        return !SpringContextUtil.isDeveloperMode();
    }

    public static String[] getActiveProfile() {
        return context.getEnvironment().getActiveProfiles();
    }

    public static boolean isDeveloperMode() {
        String[] activeProfile;
        for (String active : activeProfile = SpringContextUtil.getActiveProfile()) {
            if (!"dev".equalsIgnoreCase(active)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringContextUtil.getApplicationContext().getBean(clazz);
    }

    public static ApplicationContext getApplicationContext() {
        return context;
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static String getDomain() {
        HttpServletRequest request = SpringContextUtil.getHttpServletRequest();
        StringBuffer url = request.getRequestURL();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).toString();
    }

    public static String getOrigin() {
        HttpServletRequest request = SpringContextUtil.getHttpServletRequest();
        return request.getHeader("Origin");
    }

    public static <T> T getBean(String beanName) {
        return (T)context.getBean(beanName);
    }

    public static String getEnv(String env) {
        return context.getEnvironment().getProperty(env);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringContextUtil.getApplicationContext().getBean(name, clazz);
    }

    public static String getEnv(String env, String defaultValue) {
        return context.getEnvironment().getProperty(env, defaultValue);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }
}

