/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.wrapper;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.nier6088.enums.ResultDataStatusEnum;
import io.github.nier6088.enums.ServiceStateCodeEnum;
import io.github.nier6088.util.ObjectMapperUtil;
import io.github.nier6088.wrapper.ResultCode;
import java.util.HashMap;

public class ResultData<T> {
    @JsonProperty(index=1)
    private int code;
    @JsonProperty(index=2)
    private String msg;
    @JsonProperty(index=3)
    private T data;
    @JsonProperty(index=4)
    private Integer errorCode;
    @JsonProperty(index=5)
    private String errorMsg;

    public static <T> ResultData<T> ok(T data) {
        ResultData<T> tResultData = new ResultData<T>();
        tResultData.setCode(ResultDataStatusEnum.SUCCESS.getCode());
        tResultData.setData(data);
        tResultData.setMsg("success");
        return tResultData;
    }

    public static ResultData okArray(Object data) {
        ResultData tResultData = new ResultData();
        tResultData.setCode(ResultDataStatusEnum.SUCCESS.getCode());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("items", data);
        tResultData.setData(map);
        tResultData.setMsg("success");
        return tResultData;
    }

    public static <T> ResultData<T> ok() {
        ResultData<T> tResultData = new ResultData<T>();
        tResultData.setCode(ResultDataStatusEnum.SUCCESS.getCode());
        tResultData.setMsg("success");
        tResultData.setData(null);
        return tResultData;
    }

    public static <T> ResultData<T> fail(int errorCode, String errorMsg) {
        ResultData<T> tResultData = new ResultData<T>();
        tResultData.setCode(ResultDataStatusEnum.FAIL.getCode());
        tResultData.setErrorCode(errorCode);
        tResultData.setErrorMsg(errorMsg);
        return tResultData;
    }

    public static <T> ResultData<T> failClient(int errorCode, String errorMsg) {
        ResultData<T> tResultData = new ResultData<T>();
        tResultData.setCode(ResultDataStatusEnum.FAIL.getCode());
        tResultData.setErrorCode(errorCode);
        tResultData.setErrorMsg(errorMsg);
        return tResultData;
    }

    public static <T> ResultData<T> failClient(ServiceStateCodeEnum serviceStateCodeEnum) {
        ResultData<T> tResultData = new ResultData<T>();
        tResultData.setCode(ResultDataStatusEnum.FAIL.getCode());
        tResultData.setErrorCode(serviceStateCodeEnum.getCode());
        tResultData.setErrorMsg(serviceStateCodeEnum.getDescribe());
        return tResultData;
    }

    public static <T> ResultData<T> fail(ServiceStateCodeEnum serviceStateCodeEnum) {
        ResultData<T> tResultData = new ResultData<T>();
        tResultData.setCode(400);
        tResultData.setCode(ServiceStateCodeEnum.SERVICE_STATE_ERROR.getCode());
        tResultData.setMsg(ServiceStateCodeEnum.SERVICE_STATE_ERROR.getDescribe());
        tResultData.setErrorCode(serviceStateCodeEnum.getCode());
        tResultData.setErrorMsg(serviceStateCodeEnum.getDescribe());
        return tResultData;
    }

    public static <T> ResultData<T> fail(ServiceStateCodeEnum serviceStateCodeEnum, String errorMsg) {
        ResultData<T> tResultData = new ResultData<T>();
        tResultData.setCode(400);
        tResultData.setCode(ServiceStateCodeEnum.SERVICE_STATE_ERROR.getCode());
        tResultData.setMsg(ServiceStateCodeEnum.SERVICE_STATE_ERROR.getDescribe());
        tResultData.setErrorCode(serviceStateCodeEnum.getCode());
        tResultData.setErrorMsg(errorMsg);
        return tResultData;
    }

    public static <T> ResultData<T> makeClientReLoginRsp(int errorCode, String errorMsg) {
        ResultData<T> tResultData = new ResultData<T>();
        tResultData.setCode(ResultCode.NOT_LOGIN.getCode());
        tResultData.setMsg(errorMsg);
        tResultData.setErrorCode(errorCode);
        tResultData.setErrorMsg(errorMsg);
        return tResultData;
    }

    public String toString() {
        return ObjectMapperUtil.toStr(this);
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    @JsonProperty(index=1)
    public void setCode(int code) {
        this.code = code;
    }

    @JsonProperty(index=2)
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @JsonProperty(index=3)
    public void setData(T data) {
        this.data = data;
    }

    @JsonProperty(index=4)
    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    @JsonProperty(index=5)
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultData)) {
            return false;
        }
        ResultData other = (ResultData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Integer this$errorCode = this.getErrorCode();
        Integer other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)this$errorCode).equals(other$errorCode)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        Integer $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)$errorCode).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        return result;
    }
}

