/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.DriverData;
import io.github.pod4dev.libpodj.model.InspectContainerConfig;
import io.github.pod4dev.libpodj.model.InspectContainerHostConfig;
import io.github.pod4dev.libpodj.model.InspectContainerState;
import io.github.pod4dev.libpodj.model.InspectMount;
import io.github.pod4dev.libpodj.model.InspectNetworkSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.io.Serializable;
import javax.validation.constraints.*;
import javax.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * InspectContainerData provides a detailed record of a container&#39;s configuration and state as viewed by Libpod. Large portions of this structure are defined such that the output is compatible with &#x60;docker inspect&#x60; JSON, but additional fields have been added as required to share information not in the original output.
 */
@ApiModel(description = "InspectContainerData provides a detailed record of a container's configuration and state as viewed by Libpod. Large portions of this structure are defined such that the output is compatible with `docker inspect` JSON, but additional fields have been added as required to share information not in the original output.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class InspectContainerData implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_APP_ARMOR_PROFILE = "AppArmorProfile";
  @SerializedName(SERIALIZED_NAME_APP_ARMOR_PROFILE)
  private String appArmorProfile;

  public static final String SERIALIZED_NAME_ARGS = "Args";
  @SerializedName(SERIALIZED_NAME_ARGS)
  private List<String> args = null;

  public static final String SERIALIZED_NAME_BOUNDING_CAPS = "BoundingCaps";
  @SerializedName(SERIALIZED_NAME_BOUNDING_CAPS)
  private List<String> boundingCaps = null;

  public static final String SERIALIZED_NAME_CONFIG = "Config";
  @SerializedName(SERIALIZED_NAME_CONFIG)
  private InspectContainerConfig config;

  public static final String SERIALIZED_NAME_CONMON_PID_FILE = "ConmonPidFile";
  @SerializedName(SERIALIZED_NAME_CONMON_PID_FILE)
  private String conmonPidFile;

  public static final String SERIALIZED_NAME_CREATED = "Created";
  @SerializedName(SERIALIZED_NAME_CREATED)
  private OffsetDateTime created;

  public static final String SERIALIZED_NAME_DEPENDENCIES = "Dependencies";
  @SerializedName(SERIALIZED_NAME_DEPENDENCIES)
  private List<String> dependencies = null;

  public static final String SERIALIZED_NAME_DRIVER = "Driver";
  @SerializedName(SERIALIZED_NAME_DRIVER)
  private String driver;

  public static final String SERIALIZED_NAME_EFFECTIVE_CAPS = "EffectiveCaps";
  @SerializedName(SERIALIZED_NAME_EFFECTIVE_CAPS)
  private List<String> effectiveCaps = null;

  public static final String SERIALIZED_NAME_EXEC_I_DS = "ExecIDs";
  @SerializedName(SERIALIZED_NAME_EXEC_I_DS)
  private List<String> execIDs = null;

  public static final String SERIALIZED_NAME_GRAPH_DRIVER = "GraphDriver";
  @SerializedName(SERIALIZED_NAME_GRAPH_DRIVER)
  private DriverData graphDriver;

  public static final String SERIALIZED_NAME_HOST_CONFIG = "HostConfig";
  @SerializedName(SERIALIZED_NAME_HOST_CONFIG)
  private InspectContainerHostConfig hostConfig;

  public static final String SERIALIZED_NAME_HOSTNAME_PATH = "HostnamePath";
  @SerializedName(SERIALIZED_NAME_HOSTNAME_PATH)
  private String hostnamePath;

  public static final String SERIALIZED_NAME_HOSTS_PATH = "HostsPath";
  @SerializedName(SERIALIZED_NAME_HOSTS_PATH)
  private String hostsPath;

  public static final String SERIALIZED_NAME_ID = "Id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_IMAGE = "Image";
  @SerializedName(SERIALIZED_NAME_IMAGE)
  private String image;

  public static final String SERIALIZED_NAME_IMAGE_DIGEST = "ImageDigest";
  @SerializedName(SERIALIZED_NAME_IMAGE_DIGEST)
  private String imageDigest;

  public static final String SERIALIZED_NAME_IMAGE_NAME = "ImageName";
  @SerializedName(SERIALIZED_NAME_IMAGE_NAME)
  private String imageName;

  public static final String SERIALIZED_NAME_IS_INFRA = "IsInfra";
  @SerializedName(SERIALIZED_NAME_IS_INFRA)
  private Boolean isInfra;

  public static final String SERIALIZED_NAME_IS_SERVICE = "IsService";
  @SerializedName(SERIALIZED_NAME_IS_SERVICE)
  private Boolean isService;

  public static final String SERIALIZED_NAME_KUBE_EXIT_CODE_PROPAGATION = "KubeExitCodePropagation";
  @SerializedName(SERIALIZED_NAME_KUBE_EXIT_CODE_PROPAGATION)
  private String kubeExitCodePropagation;

  public static final String SERIALIZED_NAME_MOUNT_LABEL = "MountLabel";
  @SerializedName(SERIALIZED_NAME_MOUNT_LABEL)
  private String mountLabel;

  public static final String SERIALIZED_NAME_MOUNTS = "Mounts";
  @SerializedName(SERIALIZED_NAME_MOUNTS)
  private List<InspectMount> mounts = null;

  public static final String SERIALIZED_NAME_NAME = "Name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NAMESPACE = "Namespace";
  @SerializedName(SERIALIZED_NAME_NAMESPACE)
  private String namespace;

  public static final String SERIALIZED_NAME_NETWORK_SETTINGS = "NetworkSettings";
  @SerializedName(SERIALIZED_NAME_NETWORK_SETTINGS)
  private InspectNetworkSettings networkSettings;

  public static final String SERIALIZED_NAME_OC_I_CONFIG_PATH = "OCIConfigPath";
  @SerializedName(SERIALIZED_NAME_OC_I_CONFIG_PATH)
  private String ocIConfigPath;

  public static final String SERIALIZED_NAME_OC_I_RUNTIME = "OCIRuntime";
  @SerializedName(SERIALIZED_NAME_OC_I_RUNTIME)
  private String ocIRuntime;

  public static final String SERIALIZED_NAME_PATH = "Path";
  @SerializedName(SERIALIZED_NAME_PATH)
  private String path;

  public static final String SERIALIZED_NAME_PID_FILE = "PidFile";
  @SerializedName(SERIALIZED_NAME_PID_FILE)
  private String pidFile;

  public static final String SERIALIZED_NAME_POD = "Pod";
  @SerializedName(SERIALIZED_NAME_POD)
  private String pod;

  public static final String SERIALIZED_NAME_PROCESS_LABEL = "ProcessLabel";
  @SerializedName(SERIALIZED_NAME_PROCESS_LABEL)
  private String processLabel;

  public static final String SERIALIZED_NAME_RESOLV_CONF_PATH = "ResolvConfPath";
  @SerializedName(SERIALIZED_NAME_RESOLV_CONF_PATH)
  private String resolvConfPath;

  public static final String SERIALIZED_NAME_RESTART_COUNT = "RestartCount";
  @SerializedName(SERIALIZED_NAME_RESTART_COUNT)
  private Integer restartCount;

  public static final String SERIALIZED_NAME_ROOTFS = "Rootfs";
  @SerializedName(SERIALIZED_NAME_ROOTFS)
  private String rootfs;

  public static final String SERIALIZED_NAME_SIZE_ROOT_FS = "SizeRootFs";
  @SerializedName(SERIALIZED_NAME_SIZE_ROOT_FS)
  private Long sizeRootFs;

  public static final String SERIALIZED_NAME_SIZE_RW = "SizeRw";
  @SerializedName(SERIALIZED_NAME_SIZE_RW)
  private Long sizeRw;

  public static final String SERIALIZED_NAME_STATE = "State";
  @SerializedName(SERIALIZED_NAME_STATE)
  private InspectContainerState state;

  public static final String SERIALIZED_NAME_STATIC_DIR = "StaticDir";
  @SerializedName(SERIALIZED_NAME_STATIC_DIR)
  private String staticDir;

  public static final String SERIALIZED_NAME_LOCK_NUMBER = "lockNumber";
  @SerializedName(SERIALIZED_NAME_LOCK_NUMBER)
  private Integer lockNumber;

  public InspectContainerData() {
  }

  public InspectContainerData appArmorProfile(String appArmorProfile) {
    
    this.appArmorProfile = appArmorProfile;
    return this;
  }

   /**
   * Get appArmorProfile
   * @return appArmorProfile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getAppArmorProfile() {
    return appArmorProfile;
  }


  public void setAppArmorProfile(String appArmorProfile) {
    this.appArmorProfile = appArmorProfile;
  }


  public InspectContainerData args(List<String> args) {
    
    this.args = args;
    return this;
  }

  public InspectContainerData addArgsItem(String argsItem) {
    if (this.args == null) {
      this.args = new ArrayList<>();
    }
    this.args.add(argsItem);
    return this;
  }

   /**
   * Get args
   * @return args
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getArgs() {
    return args;
  }


  public void setArgs(List<String> args) {
    this.args = args;
  }


  public InspectContainerData boundingCaps(List<String> boundingCaps) {
    
    this.boundingCaps = boundingCaps;
    return this;
  }

  public InspectContainerData addBoundingCapsItem(String boundingCapsItem) {
    if (this.boundingCaps == null) {
      this.boundingCaps = new ArrayList<>();
    }
    this.boundingCaps.add(boundingCapsItem);
    return this;
  }

   /**
   * Get boundingCaps
   * @return boundingCaps
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getBoundingCaps() {
    return boundingCaps;
  }


  public void setBoundingCaps(List<String> boundingCaps) {
    this.boundingCaps = boundingCaps;
  }


  public InspectContainerData config(InspectContainerConfig config) {
    
    this.config = config;
    return this;
  }

   /**
   * Get config
   * @return config
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public InspectContainerConfig getConfig() {
    return config;
  }


  public void setConfig(InspectContainerConfig config) {
    this.config = config;
  }


  public InspectContainerData conmonPidFile(String conmonPidFile) {
    
    this.conmonPidFile = conmonPidFile;
    return this;
  }

   /**
   * Get conmonPidFile
   * @return conmonPidFile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getConmonPidFile() {
    return conmonPidFile;
  }


  public void setConmonPidFile(String conmonPidFile) {
    this.conmonPidFile = conmonPidFile;
  }


  public InspectContainerData created(OffsetDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public OffsetDateTime getCreated() {
    return created;
  }


  public void setCreated(OffsetDateTime created) {
    this.created = created;
  }


  public InspectContainerData dependencies(List<String> dependencies) {
    
    this.dependencies = dependencies;
    return this;
  }

  public InspectContainerData addDependenciesItem(String dependenciesItem) {
    if (this.dependencies == null) {
      this.dependencies = new ArrayList<>();
    }
    this.dependencies.add(dependenciesItem);
    return this;
  }

   /**
   * Get dependencies
   * @return dependencies
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getDependencies() {
    return dependencies;
  }


  public void setDependencies(List<String> dependencies) {
    this.dependencies = dependencies;
  }


  public InspectContainerData driver(String driver) {
    
    this.driver = driver;
    return this;
  }

   /**
   * Get driver
   * @return driver
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getDriver() {
    return driver;
  }


  public void setDriver(String driver) {
    this.driver = driver;
  }


  public InspectContainerData effectiveCaps(List<String> effectiveCaps) {
    
    this.effectiveCaps = effectiveCaps;
    return this;
  }

  public InspectContainerData addEffectiveCapsItem(String effectiveCapsItem) {
    if (this.effectiveCaps == null) {
      this.effectiveCaps = new ArrayList<>();
    }
    this.effectiveCaps.add(effectiveCapsItem);
    return this;
  }

   /**
   * Get effectiveCaps
   * @return effectiveCaps
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getEffectiveCaps() {
    return effectiveCaps;
  }


  public void setEffectiveCaps(List<String> effectiveCaps) {
    this.effectiveCaps = effectiveCaps;
  }


  public InspectContainerData execIDs(List<String> execIDs) {
    
    this.execIDs = execIDs;
    return this;
  }

  public InspectContainerData addExecIDsItem(String execIDsItem) {
    if (this.execIDs == null) {
      this.execIDs = new ArrayList<>();
    }
    this.execIDs.add(execIDsItem);
    return this;
  }

   /**
   * Get execIDs
   * @return execIDs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getExecIDs() {
    return execIDs;
  }


  public void setExecIDs(List<String> execIDs) {
    this.execIDs = execIDs;
  }


  public InspectContainerData graphDriver(DriverData graphDriver) {
    
    this.graphDriver = graphDriver;
    return this;
  }

   /**
   * Get graphDriver
   * @return graphDriver
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public DriverData getGraphDriver() {
    return graphDriver;
  }


  public void setGraphDriver(DriverData graphDriver) {
    this.graphDriver = graphDriver;
  }


  public InspectContainerData hostConfig(InspectContainerHostConfig hostConfig) {
    
    this.hostConfig = hostConfig;
    return this;
  }

   /**
   * Get hostConfig
   * @return hostConfig
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public InspectContainerHostConfig getHostConfig() {
    return hostConfig;
  }


  public void setHostConfig(InspectContainerHostConfig hostConfig) {
    this.hostConfig = hostConfig;
  }


  public InspectContainerData hostnamePath(String hostnamePath) {
    
    this.hostnamePath = hostnamePath;
    return this;
  }

   /**
   * Get hostnamePath
   * @return hostnamePath
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getHostnamePath() {
    return hostnamePath;
  }


  public void setHostnamePath(String hostnamePath) {
    this.hostnamePath = hostnamePath;
  }


  public InspectContainerData hostsPath(String hostsPath) {
    
    this.hostsPath = hostsPath;
    return this;
  }

   /**
   * Get hostsPath
   * @return hostsPath
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getHostsPath() {
    return hostsPath;
  }


  public void setHostsPath(String hostsPath) {
    this.hostsPath = hostsPath;
  }


  public InspectContainerData id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public InspectContainerData image(String image) {
    
    this.image = image;
    return this;
  }

   /**
   * Get image
   * @return image
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getImage() {
    return image;
  }


  public void setImage(String image) {
    this.image = image;
  }


  public InspectContainerData imageDigest(String imageDigest) {
    
    this.imageDigest = imageDigest;
    return this;
  }

   /**
   * Get imageDigest
   * @return imageDigest
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getImageDigest() {
    return imageDigest;
  }


  public void setImageDigest(String imageDigest) {
    this.imageDigest = imageDigest;
  }


  public InspectContainerData imageName(String imageName) {
    
    this.imageName = imageName;
    return this;
  }

   /**
   * Get imageName
   * @return imageName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getImageName() {
    return imageName;
  }


  public void setImageName(String imageName) {
    this.imageName = imageName;
  }


  public InspectContainerData isInfra(Boolean isInfra) {
    
    this.isInfra = isInfra;
    return this;
  }

   /**
   * Get isInfra
   * @return isInfra
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getIsInfra() {
    return isInfra;
  }


  public void setIsInfra(Boolean isInfra) {
    this.isInfra = isInfra;
  }


  public InspectContainerData isService(Boolean isService) {
    
    this.isService = isService;
    return this;
  }

   /**
   * Get isService
   * @return isService
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getIsService() {
    return isService;
  }


  public void setIsService(Boolean isService) {
    this.isService = isService;
  }


  public InspectContainerData kubeExitCodePropagation(String kubeExitCodePropagation) {
    
    this.kubeExitCodePropagation = kubeExitCodePropagation;
    return this;
  }

   /**
   * Get kubeExitCodePropagation
   * @return kubeExitCodePropagation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getKubeExitCodePropagation() {
    return kubeExitCodePropagation;
  }


  public void setKubeExitCodePropagation(String kubeExitCodePropagation) {
    this.kubeExitCodePropagation = kubeExitCodePropagation;
  }


  public InspectContainerData mountLabel(String mountLabel) {
    
    this.mountLabel = mountLabel;
    return this;
  }

   /**
   * Get mountLabel
   * @return mountLabel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getMountLabel() {
    return mountLabel;
  }


  public void setMountLabel(String mountLabel) {
    this.mountLabel = mountLabel;
  }


  public InspectContainerData mounts(List<InspectMount> mounts) {
    
    this.mounts = mounts;
    return this;
  }

  public InspectContainerData addMountsItem(InspectMount mountsItem) {
    if (this.mounts == null) {
      this.mounts = new ArrayList<>();
    }
    this.mounts.add(mountsItem);
    return this;
  }

   /**
   * Get mounts
   * @return mounts
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<InspectMount> getMounts() {
    return mounts;
  }


  public void setMounts(List<InspectMount> mounts) {
    this.mounts = mounts;
  }


  public InspectContainerData name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public InspectContainerData namespace(String namespace) {
    
    this.namespace = namespace;
    return this;
  }

   /**
   * Get namespace
   * @return namespace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getNamespace() {
    return namespace;
  }


  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }


  public InspectContainerData networkSettings(InspectNetworkSettings networkSettings) {
    
    this.networkSettings = networkSettings;
    return this;
  }

   /**
   * Get networkSettings
   * @return networkSettings
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public InspectNetworkSettings getNetworkSettings() {
    return networkSettings;
  }


  public void setNetworkSettings(InspectNetworkSettings networkSettings) {
    this.networkSettings = networkSettings;
  }


  public InspectContainerData ocIConfigPath(String ocIConfigPath) {
    
    this.ocIConfigPath = ocIConfigPath;
    return this;
  }

   /**
   * Get ocIConfigPath
   * @return ocIConfigPath
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getOcIConfigPath() {
    return ocIConfigPath;
  }


  public void setOcIConfigPath(String ocIConfigPath) {
    this.ocIConfigPath = ocIConfigPath;
  }


  public InspectContainerData ocIRuntime(String ocIRuntime) {
    
    this.ocIRuntime = ocIRuntime;
    return this;
  }

   /**
   * Get ocIRuntime
   * @return ocIRuntime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getOcIRuntime() {
    return ocIRuntime;
  }


  public void setOcIRuntime(String ocIRuntime) {
    this.ocIRuntime = ocIRuntime;
  }


  public InspectContainerData path(String path) {
    
    this.path = path;
    return this;
  }

   /**
   * Get path
   * @return path
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getPath() {
    return path;
  }


  public void setPath(String path) {
    this.path = path;
  }


  public InspectContainerData pidFile(String pidFile) {
    
    this.pidFile = pidFile;
    return this;
  }

   /**
   * Get pidFile
   * @return pidFile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getPidFile() {
    return pidFile;
  }


  public void setPidFile(String pidFile) {
    this.pidFile = pidFile;
  }


  public InspectContainerData pod(String pod) {
    
    this.pod = pod;
    return this;
  }

   /**
   * Get pod
   * @return pod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getPod() {
    return pod;
  }


  public void setPod(String pod) {
    this.pod = pod;
  }


  public InspectContainerData processLabel(String processLabel) {
    
    this.processLabel = processLabel;
    return this;
  }

   /**
   * Get processLabel
   * @return processLabel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getProcessLabel() {
    return processLabel;
  }


  public void setProcessLabel(String processLabel) {
    this.processLabel = processLabel;
  }


  public InspectContainerData resolvConfPath(String resolvConfPath) {
    
    this.resolvConfPath = resolvConfPath;
    return this;
  }

   /**
   * Get resolvConfPath
   * @return resolvConfPath
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getResolvConfPath() {
    return resolvConfPath;
  }


  public void setResolvConfPath(String resolvConfPath) {
    this.resolvConfPath = resolvConfPath;
  }


  public InspectContainerData restartCount(Integer restartCount) {
    
    this.restartCount = restartCount;
    return this;
  }

   /**
   * Get restartCount
   * @return restartCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getRestartCount() {
    return restartCount;
  }


  public void setRestartCount(Integer restartCount) {
    this.restartCount = restartCount;
  }


  public InspectContainerData rootfs(String rootfs) {
    
    this.rootfs = rootfs;
    return this;
  }

   /**
   * Get rootfs
   * @return rootfs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getRootfs() {
    return rootfs;
  }


  public void setRootfs(String rootfs) {
    this.rootfs = rootfs;
  }


  public InspectContainerData sizeRootFs(Long sizeRootFs) {
    
    this.sizeRootFs = sizeRootFs;
    return this;
  }

   /**
   * Get sizeRootFs
   * @return sizeRootFs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getSizeRootFs() {
    return sizeRootFs;
  }


  public void setSizeRootFs(Long sizeRootFs) {
    this.sizeRootFs = sizeRootFs;
  }


  public InspectContainerData sizeRw(Long sizeRw) {
    
    this.sizeRw = sizeRw;
    return this;
  }

   /**
   * Get sizeRw
   * @return sizeRw
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getSizeRw() {
    return sizeRw;
  }


  public void setSizeRw(Long sizeRw) {
    this.sizeRw = sizeRw;
  }


  public InspectContainerData state(InspectContainerState state) {
    
    this.state = state;
    return this;
  }

   /**
   * Get state
   * @return state
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public InspectContainerState getState() {
    return state;
  }


  public void setState(InspectContainerState state) {
    this.state = state;
  }


  public InspectContainerData staticDir(String staticDir) {
    
    this.staticDir = staticDir;
    return this;
  }

   /**
   * Get staticDir
   * @return staticDir
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getStaticDir() {
    return staticDir;
  }


  public void setStaticDir(String staticDir) {
    this.staticDir = staticDir;
  }


  public InspectContainerData lockNumber(Integer lockNumber) {
    
    this.lockNumber = lockNumber;
    return this;
  }

   /**
   * Get lockNumber
   * @return lockNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getLockNumber() {
    return lockNumber;
  }


  public void setLockNumber(Integer lockNumber) {
    this.lockNumber = lockNumber;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InspectContainerData inspectContainerData = (InspectContainerData) o;
    return Objects.equals(this.appArmorProfile, inspectContainerData.appArmorProfile) &&
        Objects.equals(this.args, inspectContainerData.args) &&
        Objects.equals(this.boundingCaps, inspectContainerData.boundingCaps) &&
        Objects.equals(this.config, inspectContainerData.config) &&
        Objects.equals(this.conmonPidFile, inspectContainerData.conmonPidFile) &&
        Objects.equals(this.created, inspectContainerData.created) &&
        Objects.equals(this.dependencies, inspectContainerData.dependencies) &&
        Objects.equals(this.driver, inspectContainerData.driver) &&
        Objects.equals(this.effectiveCaps, inspectContainerData.effectiveCaps) &&
        Objects.equals(this.execIDs, inspectContainerData.execIDs) &&
        Objects.equals(this.graphDriver, inspectContainerData.graphDriver) &&
        Objects.equals(this.hostConfig, inspectContainerData.hostConfig) &&
        Objects.equals(this.hostnamePath, inspectContainerData.hostnamePath) &&
        Objects.equals(this.hostsPath, inspectContainerData.hostsPath) &&
        Objects.equals(this.id, inspectContainerData.id) &&
        Objects.equals(this.image, inspectContainerData.image) &&
        Objects.equals(this.imageDigest, inspectContainerData.imageDigest) &&
        Objects.equals(this.imageName, inspectContainerData.imageName) &&
        Objects.equals(this.isInfra, inspectContainerData.isInfra) &&
        Objects.equals(this.isService, inspectContainerData.isService) &&
        Objects.equals(this.kubeExitCodePropagation, inspectContainerData.kubeExitCodePropagation) &&
        Objects.equals(this.mountLabel, inspectContainerData.mountLabel) &&
        Objects.equals(this.mounts, inspectContainerData.mounts) &&
        Objects.equals(this.name, inspectContainerData.name) &&
        Objects.equals(this.namespace, inspectContainerData.namespace) &&
        Objects.equals(this.networkSettings, inspectContainerData.networkSettings) &&
        Objects.equals(this.ocIConfigPath, inspectContainerData.ocIConfigPath) &&
        Objects.equals(this.ocIRuntime, inspectContainerData.ocIRuntime) &&
        Objects.equals(this.path, inspectContainerData.path) &&
        Objects.equals(this.pidFile, inspectContainerData.pidFile) &&
        Objects.equals(this.pod, inspectContainerData.pod) &&
        Objects.equals(this.processLabel, inspectContainerData.processLabel) &&
        Objects.equals(this.resolvConfPath, inspectContainerData.resolvConfPath) &&
        Objects.equals(this.restartCount, inspectContainerData.restartCount) &&
        Objects.equals(this.rootfs, inspectContainerData.rootfs) &&
        Objects.equals(this.sizeRootFs, inspectContainerData.sizeRootFs) &&
        Objects.equals(this.sizeRw, inspectContainerData.sizeRw) &&
        Objects.equals(this.state, inspectContainerData.state) &&
        Objects.equals(this.staticDir, inspectContainerData.staticDir) &&
        Objects.equals(this.lockNumber, inspectContainerData.lockNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appArmorProfile, args, boundingCaps, config, conmonPidFile, created, dependencies, driver, effectiveCaps, execIDs, graphDriver, hostConfig, hostnamePath, hostsPath, id, image, imageDigest, imageName, isInfra, isService, kubeExitCodePropagation, mountLabel, mounts, name, namespace, networkSettings, ocIConfigPath, ocIRuntime, path, pidFile, pod, processLabel, resolvConfPath, restartCount, rootfs, sizeRootFs, sizeRw, state, staticDir, lockNumber);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InspectContainerData {\n");
    sb.append("    appArmorProfile: ").append(toIndentedString(appArmorProfile)).append("\n");
    sb.append("    args: ").append(toIndentedString(args)).append("\n");
    sb.append("    boundingCaps: ").append(toIndentedString(boundingCaps)).append("\n");
    sb.append("    config: ").append(toIndentedString(config)).append("\n");
    sb.append("    conmonPidFile: ").append(toIndentedString(conmonPidFile)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    dependencies: ").append(toIndentedString(dependencies)).append("\n");
    sb.append("    driver: ").append(toIndentedString(driver)).append("\n");
    sb.append("    effectiveCaps: ").append(toIndentedString(effectiveCaps)).append("\n");
    sb.append("    execIDs: ").append(toIndentedString(execIDs)).append("\n");
    sb.append("    graphDriver: ").append(toIndentedString(graphDriver)).append("\n");
    sb.append("    hostConfig: ").append(toIndentedString(hostConfig)).append("\n");
    sb.append("    hostnamePath: ").append(toIndentedString(hostnamePath)).append("\n");
    sb.append("    hostsPath: ").append(toIndentedString(hostsPath)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    imageDigest: ").append(toIndentedString(imageDigest)).append("\n");
    sb.append("    imageName: ").append(toIndentedString(imageName)).append("\n");
    sb.append("    isInfra: ").append(toIndentedString(isInfra)).append("\n");
    sb.append("    isService: ").append(toIndentedString(isService)).append("\n");
    sb.append("    kubeExitCodePropagation: ").append(toIndentedString(kubeExitCodePropagation)).append("\n");
    sb.append("    mountLabel: ").append(toIndentedString(mountLabel)).append("\n");
    sb.append("    mounts: ").append(toIndentedString(mounts)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    networkSettings: ").append(toIndentedString(networkSettings)).append("\n");
    sb.append("    ocIConfigPath: ").append(toIndentedString(ocIConfigPath)).append("\n");
    sb.append("    ocIRuntime: ").append(toIndentedString(ocIRuntime)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    pidFile: ").append(toIndentedString(pidFile)).append("\n");
    sb.append("    pod: ").append(toIndentedString(pod)).append("\n");
    sb.append("    processLabel: ").append(toIndentedString(processLabel)).append("\n");
    sb.append("    resolvConfPath: ").append(toIndentedString(resolvConfPath)).append("\n");
    sb.append("    restartCount: ").append(toIndentedString(restartCount)).append("\n");
    sb.append("    rootfs: ").append(toIndentedString(rootfs)).append("\n");
    sb.append("    sizeRootFs: ").append(toIndentedString(sizeRootFs)).append("\n");
    sb.append("    sizeRw: ").append(toIndentedString(sizeRw)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    staticDir: ").append(toIndentedString(staticDir)).append("\n");
    sb.append("    lockNumber: ").append(toIndentedString(lockNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("AppArmorProfile");
    openapiFields.add("Args");
    openapiFields.add("BoundingCaps");
    openapiFields.add("Config");
    openapiFields.add("ConmonPidFile");
    openapiFields.add("Created");
    openapiFields.add("Dependencies");
    openapiFields.add("Driver");
    openapiFields.add("EffectiveCaps");
    openapiFields.add("ExecIDs");
    openapiFields.add("GraphDriver");
    openapiFields.add("HostConfig");
    openapiFields.add("HostnamePath");
    openapiFields.add("HostsPath");
    openapiFields.add("Id");
    openapiFields.add("Image");
    openapiFields.add("ImageDigest");
    openapiFields.add("ImageName");
    openapiFields.add("IsInfra");
    openapiFields.add("IsService");
    openapiFields.add("KubeExitCodePropagation");
    openapiFields.add("MountLabel");
    openapiFields.add("Mounts");
    openapiFields.add("Name");
    openapiFields.add("Namespace");
    openapiFields.add("NetworkSettings");
    openapiFields.add("OCIConfigPath");
    openapiFields.add("OCIRuntime");
    openapiFields.add("Path");
    openapiFields.add("PidFile");
    openapiFields.add("Pod");
    openapiFields.add("ProcessLabel");
    openapiFields.add("ResolvConfPath");
    openapiFields.add("RestartCount");
    openapiFields.add("Rootfs");
    openapiFields.add("SizeRootFs");
    openapiFields.add("SizeRw");
    openapiFields.add("State");
    openapiFields.add("StaticDir");
    openapiFields.add("lockNumber");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to InspectContainerData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (InspectContainerData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in InspectContainerData is not found in the empty JSON string", InspectContainerData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!InspectContainerData.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectContainerData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("AppArmorProfile") != null && !jsonObj.get("AppArmorProfile").isJsonNull()) && !jsonObj.get("AppArmorProfile").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `AppArmorProfile` to be a primitive type in the JSON string but got `%s`", jsonObj.get("AppArmorProfile").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("Args") != null && !jsonObj.get("Args").isJsonNull()) && !jsonObj.get("Args").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `Args` to be an array in the JSON string but got `%s`", jsonObj.get("Args").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("BoundingCaps") != null && !jsonObj.get("BoundingCaps").isJsonNull()) && !jsonObj.get("BoundingCaps").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `BoundingCaps` to be an array in the JSON string but got `%s`", jsonObj.get("BoundingCaps").toString()));
      }
      // validate the optional field `Config`
      if (jsonObj.get("Config") != null && !jsonObj.get("Config").isJsonNull()) {
        InspectContainerConfig.validateJsonObject(jsonObj.getAsJsonObject("Config"));
      }
      if ((jsonObj.get("ConmonPidFile") != null && !jsonObj.get("ConmonPidFile").isJsonNull()) && !jsonObj.get("ConmonPidFile").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ConmonPidFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ConmonPidFile").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("Dependencies") != null && !jsonObj.get("Dependencies").isJsonNull()) && !jsonObj.get("Dependencies").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `Dependencies` to be an array in the JSON string but got `%s`", jsonObj.get("Dependencies").toString()));
      }
      if ((jsonObj.get("Driver") != null && !jsonObj.get("Driver").isJsonNull()) && !jsonObj.get("Driver").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Driver").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("EffectiveCaps") != null && !jsonObj.get("EffectiveCaps").isJsonNull()) && !jsonObj.get("EffectiveCaps").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `EffectiveCaps` to be an array in the JSON string but got `%s`", jsonObj.get("EffectiveCaps").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("ExecIDs") != null && !jsonObj.get("ExecIDs").isJsonNull()) && !jsonObj.get("ExecIDs").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `ExecIDs` to be an array in the JSON string but got `%s`", jsonObj.get("ExecIDs").toString()));
      }
      // validate the optional field `GraphDriver`
      if (jsonObj.get("GraphDriver") != null && !jsonObj.get("GraphDriver").isJsonNull()) {
        DriverData.validateJsonObject(jsonObj.getAsJsonObject("GraphDriver"));
      }
      // validate the optional field `HostConfig`
      if (jsonObj.get("HostConfig") != null && !jsonObj.get("HostConfig").isJsonNull()) {
        InspectContainerHostConfig.validateJsonObject(jsonObj.getAsJsonObject("HostConfig"));
      }
      if ((jsonObj.get("HostnamePath") != null && !jsonObj.get("HostnamePath").isJsonNull()) && !jsonObj.get("HostnamePath").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `HostnamePath` to be a primitive type in the JSON string but got `%s`", jsonObj.get("HostnamePath").toString()));
      }
      if ((jsonObj.get("HostsPath") != null && !jsonObj.get("HostsPath").isJsonNull()) && !jsonObj.get("HostsPath").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `HostsPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get("HostsPath").toString()));
      }
      if ((jsonObj.get("Id") != null && !jsonObj.get("Id").isJsonNull()) && !jsonObj.get("Id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Id").toString()));
      }
      if ((jsonObj.get("Image") != null && !jsonObj.get("Image").isJsonNull()) && !jsonObj.get("Image").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Image` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Image").toString()));
      }
      if ((jsonObj.get("ImageDigest") != null && !jsonObj.get("ImageDigest").isJsonNull()) && !jsonObj.get("ImageDigest").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ImageDigest` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ImageDigest").toString()));
      }
      if ((jsonObj.get("ImageName") != null && !jsonObj.get("ImageName").isJsonNull()) && !jsonObj.get("ImageName").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ImageName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ImageName").toString()));
      }
      if ((jsonObj.get("KubeExitCodePropagation") != null && !jsonObj.get("KubeExitCodePropagation").isJsonNull()) && !jsonObj.get("KubeExitCodePropagation").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `KubeExitCodePropagation` to be a primitive type in the JSON string but got `%s`", jsonObj.get("KubeExitCodePropagation").toString()));
      }
      if ((jsonObj.get("MountLabel") != null && !jsonObj.get("MountLabel").isJsonNull()) && !jsonObj.get("MountLabel").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `MountLabel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("MountLabel").toString()));
      }
      if (jsonObj.get("Mounts") != null && !jsonObj.get("Mounts").isJsonNull()) {
        JsonArray jsonArraymounts = jsonObj.getAsJsonArray("Mounts");
        if (jsonArraymounts != null) {
          // ensure the json data is an array
          if (!jsonObj.get("Mounts").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Mounts` to be an array in the JSON string but got `%s`", jsonObj.get("Mounts").toString()));
          }

          // validate the optional field `Mounts` (array)
          for (int i = 0; i < jsonArraymounts.size(); i++) {
            InspectMount.validateJsonObject(jsonArraymounts.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("Name") != null && !jsonObj.get("Name").isJsonNull()) && !jsonObj.get("Name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Name").toString()));
      }
      if ((jsonObj.get("Namespace") != null && !jsonObj.get("Namespace").isJsonNull()) && !jsonObj.get("Namespace").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Namespace").toString()));
      }
      // validate the optional field `NetworkSettings`
      if (jsonObj.get("NetworkSettings") != null && !jsonObj.get("NetworkSettings").isJsonNull()) {
        InspectNetworkSettings.validateJsonObject(jsonObj.getAsJsonObject("NetworkSettings"));
      }
      if ((jsonObj.get("OCIConfigPath") != null && !jsonObj.get("OCIConfigPath").isJsonNull()) && !jsonObj.get("OCIConfigPath").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `OCIConfigPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get("OCIConfigPath").toString()));
      }
      if ((jsonObj.get("OCIRuntime") != null && !jsonObj.get("OCIRuntime").isJsonNull()) && !jsonObj.get("OCIRuntime").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `OCIRuntime` to be a primitive type in the JSON string but got `%s`", jsonObj.get("OCIRuntime").toString()));
      }
      if ((jsonObj.get("Path") != null && !jsonObj.get("Path").isJsonNull()) && !jsonObj.get("Path").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Path` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Path").toString()));
      }
      if ((jsonObj.get("PidFile") != null && !jsonObj.get("PidFile").isJsonNull()) && !jsonObj.get("PidFile").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `PidFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get("PidFile").toString()));
      }
      if ((jsonObj.get("Pod") != null && !jsonObj.get("Pod").isJsonNull()) && !jsonObj.get("Pod").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Pod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Pod").toString()));
      }
      if ((jsonObj.get("ProcessLabel") != null && !jsonObj.get("ProcessLabel").isJsonNull()) && !jsonObj.get("ProcessLabel").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ProcessLabel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ProcessLabel").toString()));
      }
      if ((jsonObj.get("ResolvConfPath") != null && !jsonObj.get("ResolvConfPath").isJsonNull()) && !jsonObj.get("ResolvConfPath").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ResolvConfPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ResolvConfPath").toString()));
      }
      if ((jsonObj.get("Rootfs") != null && !jsonObj.get("Rootfs").isJsonNull()) && !jsonObj.get("Rootfs").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Rootfs` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Rootfs").toString()));
      }
      // validate the optional field `State`
      if (jsonObj.get("State") != null && !jsonObj.get("State").isJsonNull()) {
        InspectContainerState.validateJsonObject(jsonObj.getAsJsonObject("State"));
      }
      if ((jsonObj.get("StaticDir") != null && !jsonObj.get("StaticDir").isJsonNull()) && !jsonObj.get("StaticDir").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `StaticDir` to be a primitive type in the JSON string but got `%s`", jsonObj.get("StaticDir").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!InspectContainerData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'InspectContainerData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<InspectContainerData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(InspectContainerData.class));

       return (TypeAdapter<T>) new TypeAdapter<InspectContainerData>() {
           @Override
           public void write(JsonWriter out, InspectContainerData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public InspectContainerData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of InspectContainerData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of InspectContainerData
  * @throws IOException if the JSON string is invalid with respect to InspectContainerData
  */
  public static InspectContainerData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, InspectContainerData.class);
  }

 /**
  * Convert an instance of InspectContainerData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

