/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.EndpointIPAMConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="EndpointSettings stores the network endpoint details")
public class EndpointSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALIASES = "Aliases";
    @SerializedName(value="Aliases")
    private List<String> aliases = null;
    public static final String SERIALIZED_NAME_DN_S_NAMES = "DNSNames";
    @SerializedName(value="DNSNames")
    private List<String> dnSNames = null;
    public static final String SERIALIZED_NAME_DRIVER_OPTS = "DriverOpts";
    @SerializedName(value="DriverOpts")
    private Map<String, String> driverOpts = null;
    public static final String SERIALIZED_NAME_ENDPOINT_I_D = "EndpointID";
    @SerializedName(value="EndpointID")
    private String endpointID;
    public static final String SERIALIZED_NAME_GATEWAY = "Gateway";
    @SerializedName(value="Gateway")
    private String gateway;
    public static final String SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS = "GlobalIPv6Address";
    @SerializedName(value="GlobalIPv6Address")
    private String globalIPv6Address;
    public static final String SERIALIZED_NAME_GLOBAL_I_PV6_PREFIX_LEN = "GlobalIPv6PrefixLen";
    @SerializedName(value="GlobalIPv6PrefixLen")
    private Long globalIPv6PrefixLen;
    public static final String SERIALIZED_NAME_IP_A_M_CONFIG = "IPAMConfig";
    @SerializedName(value="IPAMConfig")
    private EndpointIPAMConfig ipAMConfig;
    public static final String SERIALIZED_NAME_IP_ADDRESS = "IPAddress";
    @SerializedName(value="IPAddress")
    private String ipAddress;
    public static final String SERIALIZED_NAME_IP_PREFIX_LEN = "IPPrefixLen";
    @SerializedName(value="IPPrefixLen")
    private Long ipPrefixLen;
    public static final String SERIALIZED_NAME_IPV6_GATEWAY = "IPv6Gateway";
    @SerializedName(value="IPv6Gateway")
    private String ipv6Gateway;
    public static final String SERIALIZED_NAME_LINKS = "Links";
    @SerializedName(value="Links")
    private List<String> links = null;
    public static final String SERIALIZED_NAME_MAC_ADDRESS = "MacAddress";
    @SerializedName(value="MacAddress")
    private String macAddress;
    public static final String SERIALIZED_NAME_NETWORK_I_D = "NetworkID";
    @SerializedName(value="NetworkID")
    private String networkID;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EndpointSettings aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public EndpointSettings addAliasesItem(String aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public EndpointSettings dnSNames(List<String> dnSNames) {
        this.dnSNames = dnSNames;
        return this;
    }

    public EndpointSettings addDnSNamesItem(String dnSNamesItem) {
        if (this.dnSNames == null) {
            this.dnSNames = new ArrayList<String>();
        }
        this.dnSNames.add(dnSNamesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNSNames holds all the (non fully qualified) DNS names associated to this endpoint. First entry is used to generate PTR records.")
    public List<String> getDnSNames() {
        return this.dnSNames;
    }

    public void setDnSNames(List<String> dnSNames) {
        this.dnSNames = dnSNames;
    }

    public EndpointSettings driverOpts(Map<String, String> driverOpts) {
        this.driverOpts = driverOpts;
        return this;
    }

    public EndpointSettings putDriverOptsItem(String key, String driverOptsItem) {
        if (this.driverOpts == null) {
            this.driverOpts = new HashMap<String, String>();
        }
        this.driverOpts.put(key, driverOptsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getDriverOpts() {
        return this.driverOpts;
    }

    public void setDriverOpts(Map<String, String> driverOpts) {
        this.driverOpts = driverOpts;
    }

    public EndpointSettings endpointID(String endpointID) {
        this.endpointID = endpointID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getEndpointID() {
        return this.endpointID;
    }

    public void setEndpointID(String endpointID) {
        this.endpointID = endpointID;
    }

    public EndpointSettings gateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public EndpointSettings globalIPv6Address(String globalIPv6Address) {
        this.globalIPv6Address = globalIPv6Address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getGlobalIPv6Address() {
        return this.globalIPv6Address;
    }

    public void setGlobalIPv6Address(String globalIPv6Address) {
        this.globalIPv6Address = globalIPv6Address;
    }

    public EndpointSettings globalIPv6PrefixLen(Long globalIPv6PrefixLen) {
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getGlobalIPv6PrefixLen() {
        return this.globalIPv6PrefixLen;
    }

    public void setGlobalIPv6PrefixLen(Long globalIPv6PrefixLen) {
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
    }

    public EndpointSettings ipAMConfig(EndpointIPAMConfig ipAMConfig) {
        this.ipAMConfig = ipAMConfig;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public EndpointIPAMConfig getIpAMConfig() {
        return this.ipAMConfig;
    }

    public void setIpAMConfig(EndpointIPAMConfig ipAMConfig) {
        this.ipAMConfig = ipAMConfig;
    }

    public EndpointSettings ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public EndpointSettings ipPrefixLen(Long ipPrefixLen) {
        this.ipPrefixLen = ipPrefixLen;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getIpPrefixLen() {
        return this.ipPrefixLen;
    }

    public void setIpPrefixLen(Long ipPrefixLen) {
        this.ipPrefixLen = ipPrefixLen;
    }

    public EndpointSettings ipv6Gateway(String ipv6Gateway) {
        this.ipv6Gateway = ipv6Gateway;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getIpv6Gateway() {
        return this.ipv6Gateway;
    }

    public void setIpv6Gateway(String ipv6Gateway) {
        this.ipv6Gateway = ipv6Gateway;
    }

    public EndpointSettings links(List<String> links) {
        this.links = links;
        return this;
    }

    public EndpointSettings addLinksItem(String linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<String>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getLinks() {
        return this.links;
    }

    public void setLinks(List<String> links) {
        this.links = links;
    }

    public EndpointSettings macAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MacAddress may be used to specify a MAC address when the container is created. Once the container is running, it becomes operational data (it may contain a generated address).")
    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public EndpointSettings networkID(String networkID) {
        this.networkID = networkID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operational data")
    public String getNetworkID() {
        return this.networkID;
    }

    public void setNetworkID(String networkID) {
        this.networkID = networkID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointSettings endpointSettings = (EndpointSettings)o;
        return Objects.equals(this.aliases, endpointSettings.aliases) && Objects.equals(this.dnSNames, endpointSettings.dnSNames) && Objects.equals(this.driverOpts, endpointSettings.driverOpts) && Objects.equals(this.endpointID, endpointSettings.endpointID) && Objects.equals(this.gateway, endpointSettings.gateway) && Objects.equals(this.globalIPv6Address, endpointSettings.globalIPv6Address) && Objects.equals(this.globalIPv6PrefixLen, endpointSettings.globalIPv6PrefixLen) && Objects.equals(this.ipAMConfig, endpointSettings.ipAMConfig) && Objects.equals(this.ipAddress, endpointSettings.ipAddress) && Objects.equals(this.ipPrefixLen, endpointSettings.ipPrefixLen) && Objects.equals(this.ipv6Gateway, endpointSettings.ipv6Gateway) && Objects.equals(this.links, endpointSettings.links) && Objects.equals(this.macAddress, endpointSettings.macAddress) && Objects.equals(this.networkID, endpointSettings.networkID);
    }

    public int hashCode() {
        return Objects.hash(this.aliases, this.dnSNames, this.driverOpts, this.endpointID, this.gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipAMConfig, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.links, this.macAddress, this.networkID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EndpointSettings {\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    dnSNames: ").append(this.toIndentedString(this.dnSNames)).append("\n");
        sb.append("    driverOpts: ").append(this.toIndentedString(this.driverOpts)).append("\n");
        sb.append("    endpointID: ").append(this.toIndentedString(this.endpointID)).append("\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    globalIPv6Address: ").append(this.toIndentedString(this.globalIPv6Address)).append("\n");
        sb.append("    globalIPv6PrefixLen: ").append(this.toIndentedString(this.globalIPv6PrefixLen)).append("\n");
        sb.append("    ipAMConfig: ").append(this.toIndentedString(this.ipAMConfig)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    ipPrefixLen: ").append(this.toIndentedString(this.ipPrefixLen)).append("\n");
        sb.append("    ipv6Gateway: ").append(this.toIndentedString(this.ipv6Gateway)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    macAddress: ").append(this.toIndentedString(this.macAddress)).append("\n");
        sb.append("    networkID: ").append(this.toIndentedString(this.networkID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in EndpointSettings is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `EndpointSettings` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALIASES) != null && !jsonObj.get(SERIALIZED_NAME_ALIASES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALIASES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Aliases` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALIASES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DN_S_NAMES) != null && !jsonObj.get(SERIALIZED_NAME_DN_S_NAMES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DN_S_NAMES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `DNSNames` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DN_S_NAMES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D) != null && !jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `EndpointID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GATEWAY) != null && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `GlobalIPv6Address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IP_A_M_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_IP_A_M_CONFIG).isJsonNull()) {
            EndpointIPAMConfig.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IP_A_M_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_IP_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `IPAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY) != null && !jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `IPv6Gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINKS) != null && !jsonObj.get(SERIALIZED_NAME_LINKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LINKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Links` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `MacAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_I_D) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NETWORK_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `NetworkID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_I_D).toString()));
        }
    }

    public static EndpointSettings fromJson(String jsonString) throws IOException {
        return (EndpointSettings)JSON.getGson().fromJson(jsonString, EndpointSettings.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALIASES);
        openapiFields.add(SERIALIZED_NAME_DN_S_NAMES);
        openapiFields.add(SERIALIZED_NAME_DRIVER_OPTS);
        openapiFields.add(SERIALIZED_NAME_ENDPOINT_I_D);
        openapiFields.add(SERIALIZED_NAME_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_GLOBAL_I_PV6_PREFIX_LEN);
        openapiFields.add(SERIALIZED_NAME_IP_A_M_CONFIG);
        openapiFields.add(SERIALIZED_NAME_IP_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_IP_PREFIX_LEN);
        openapiFields.add(SERIALIZED_NAME_IPV6_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_MAC_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_NETWORK_I_D);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!EndpointSettings.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EndpointSettings.class));
            return new TypeAdapter<EndpointSettings>(){

                public void write(JsonWriter out, EndpointSettings value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public EndpointSettings read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    EndpointSettings.validateJsonObject(jsonObj);
                    return (EndpointSettings)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

