/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="HealthCheckLog describes the results of a single healthcheck")
public class HealthCheckLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_END = "End";
    @SerializedName(value="End")
    private String end;
    public static final String SERIALIZED_NAME_EXIT_CODE = "ExitCode";
    @SerializedName(value="ExitCode")
    private Long exitCode;
    public static final String SERIALIZED_NAME_OUTPUT = "Output";
    @SerializedName(value="Output")
    private String output;
    public static final String SERIALIZED_NAME_START = "Start";
    @SerializedName(value="Start")
    private String start;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public HealthCheckLog end(String end) {
        this.end = end;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="End time as a string")
    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public HealthCheckLog exitCode(Long exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Exitcode is 0 or 1")
    public Long getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Long exitCode) {
        this.exitCode = exitCode;
    }

    public HealthCheckLog output(String output) {
        this.output = output;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Output is the stdout/stderr from the healthcheck command")
    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public HealthCheckLog start(String start) {
        this.start = start;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Start time as string")
    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthCheckLog healthCheckLog = (HealthCheckLog)o;
        return Objects.equals(this.end, healthCheckLog.end) && Objects.equals(this.exitCode, healthCheckLog.exitCode) && Objects.equals(this.output, healthCheckLog.output) && Objects.equals(this.start, healthCheckLog.start);
    }

    public int hashCode() {
        return Objects.hash(this.end, this.exitCode, this.output, this.start);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HealthCheckLog {\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString(this.exitCode)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in HealthCheckLog is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `HealthCheckLog` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_END) != null && !jsonObj.get(SERIALIZED_NAME_END).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_END).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `End` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_END).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OUTPUT) != null && !jsonObj.get(SERIALIZED_NAME_OUTPUT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OUTPUT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Output` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUTPUT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_START) != null && !jsonObj.get(SERIALIZED_NAME_START).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_START).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Start` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_START).toString()));
        }
    }

    public static HealthCheckLog fromJson(String jsonString) throws IOException {
        return (HealthCheckLog)JSON.getGson().fromJson(jsonString, HealthCheckLog.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_END);
        openapiFields.add(SERIALIZED_NAME_EXIT_CODE);
        openapiFields.add(SERIALIZED_NAME_OUTPUT);
        openapiFields.add(SERIALIZED_NAME_START);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!HealthCheckLog.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(HealthCheckLog.class));
            return new TypeAdapter<HealthCheckLog>(){

                public void write(JsonWriter out, HealthCheckLog value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public HealthCheckLog read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    HealthCheckLog.validateJsonObject(jsonObj);
                    return (HealthCheckLog)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

