/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="IDMap contains a single entry for user namespace range remapping. An array of IDMap entries represents the structure that will be provided to the Linux kernel for creating a user namespace.")
public class IDMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTAINER_ID = "container_id";
    @SerializedName(value="container_id")
    private Long containerId;
    public static final String SERIALIZED_NAME_HOST_ID = "host_id";
    @SerializedName(value="host_id")
    private Long hostId;
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private Long size;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IDMap containerId(Long containerId) {
        this.containerId = containerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getContainerId() {
        return this.containerId;
    }

    public void setContainerId(Long containerId) {
        this.containerId = containerId;
    }

    public IDMap hostId(Long hostId) {
        this.hostId = hostId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getHostId() {
        return this.hostId;
    }

    public void setHostId(Long hostId) {
        this.hostId = hostId;
    }

    public IDMap size(Long size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IDMap idMap = (IDMap)o;
        return Objects.equals(this.containerId, idMap.containerId) && Objects.equals(this.hostId, idMap.hostId) && Objects.equals(this.size, idMap.size);
    }

    public int hashCode() {
        return Objects.hash(this.containerId, this.hostId, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IDMap {\n");
        sb.append("    containerId: ").append(this.toIndentedString(this.containerId)).append("\n");
        sb.append("    hostId: ").append(this.toIndentedString(this.hostId)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in IDMap is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IDMap` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
    }

    public static IDMap fromJson(String jsonString) throws IOException {
        return (IDMap)JSON.getGson().fromJson(jsonString, IDMap.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINER_ID);
        openapiFields.add(SERIALIZED_NAME_HOST_ID);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!IDMap.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IDMap.class));
            return new TypeAdapter<IDMap>(){

                public void write(JsonWriter out, IDMap value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public IDMap read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    IDMap.validateJsonObject(jsonObj);
                    return (IDMap)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

