/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="InspectHostPort provides information on a port on the host that a container's port is bound to.")
public class InspectHostPort
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_HOST_IP = "HostIp";
    @SerializedName(value="HostIp")
    private String hostIp;
    public static final String SERIALIZED_NAME_HOST_PORT = "HostPort";
    @SerializedName(value="HostPort")
    private String hostPort;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectHostPort hostIp(String hostIp) {
        this.hostIp = hostIp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP on the host we are bound to. \"\" if not specified (binding to all IPs).")
    public String getHostIp() {
        return this.hostIp;
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public InspectHostPort hostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Port on the host we are bound to. No special formatting - just an integer stuffed into a string.")
    public String getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectHostPort inspectHostPort = (InspectHostPort)o;
        return Objects.equals(this.hostIp, inspectHostPort.hostIp) && Objects.equals(this.hostPort, inspectHostPort.hostPort);
    }

    public int hashCode() {
        return Objects.hash(this.hostIp, this.hostPort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectHostPort {\n");
        sb.append("    hostIp: ").append(this.toIndentedString(this.hostIp)).append("\n");
        sb.append("    hostPort: ").append(this.toIndentedString(this.hostPort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectHostPort is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectHostPort` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST_IP) != null && !jsonObj.get(SERIALIZED_NAME_HOST_IP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOST_IP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `HostIp` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST_IP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST_PORT) != null && !jsonObj.get(SERIALIZED_NAME_HOST_PORT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOST_PORT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `HostPort` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST_PORT).toString()));
        }
    }

    public static InspectHostPort fromJson(String jsonString) throws IOException {
        return (InspectHostPort)JSON.getGson().fromJson(jsonString, InspectHostPort.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HOST_IP);
        openapiFields.add(SERIALIZED_NAME_HOST_PORT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectHostPort.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectHostPort.class));
            return new TypeAdapter<InspectHostPort>(){

                public void write(JsonWriter out, InspectHostPort value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectHostPort read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InspectHostPort.validateJsonObject(jsonObj);
                    return (InspectHostPort)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

