/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="SystemCheckReport provides a report of what a storage consistency check found, and if we removed anything that was damaged, what we removed.")
public class SystemCheckReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTAINERS = "Containers";
    @SerializedName(value="Containers")
    private Map<String, List<String>> containers = null;
    public static final String SERIALIZED_NAME_ERRORS = "Errors";
    @SerializedName(value="Errors")
    private Boolean errors;
    public static final String SERIALIZED_NAME_IMAGES = "Images";
    @SerializedName(value="Images")
    private Map<String, List<String>> images = null;
    public static final String SERIALIZED_NAME_LAYERS = "Layers";
    @SerializedName(value="Layers")
    private Map<String, List<String>> layers = null;
    public static final String SERIALIZED_NAME_RO_IMAGES = "ROImages";
    @SerializedName(value="ROImages")
    private Map<String, List<String>> roImages = null;
    public static final String SERIALIZED_NAME_RO_LAYERS = "ROLayers";
    @SerializedName(value="ROLayers")
    private Map<String, List<String>> roLayers = null;
    public static final String SERIALIZED_NAME_REMOVED_CONTAINERS = "RemovedContainers";
    @SerializedName(value="RemovedContainers")
    private Map<String, String> removedContainers = null;
    public static final String SERIALIZED_NAME_REMOVED_IMAGES = "RemovedImages";
    @SerializedName(value="RemovedImages")
    private Map<String, List<String>> removedImages = null;
    public static final String SERIALIZED_NAME_REMOVED_LAYERS = "RemovedLayers";
    @SerializedName(value="RemovedLayers")
    private List<String> removedLayers = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SystemCheckReport containers(Map<String, List<String>> containers) {
        this.containers = containers;
        return this;
    }

    public SystemCheckReport putContainersItem(String key, List<String> containersItem) {
        if (this.containers == null) {
            this.containers = new HashMap<String, List<String>>();
        }
        this.containers.put(key, containersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Map<String, List<String>> getContainers() {
        return this.containers;
    }

    public void setContainers(Map<String, List<String>> containers) {
        this.containers = containers;
    }

    public SystemCheckReport errors(Boolean errors) {
        this.errors = errors;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getErrors() {
        return this.errors;
    }

    public void setErrors(Boolean errors) {
        this.errors = errors;
    }

    public SystemCheckReport images(Map<String, List<String>> images) {
        this.images = images;
        return this;
    }

    public SystemCheckReport putImagesItem(String key, List<String> imagesItem) {
        if (this.images == null) {
            this.images = new HashMap<String, List<String>>();
        }
        this.images.put(key, imagesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Map<String, List<String>> getImages() {
        return this.images;
    }

    public void setImages(Map<String, List<String>> images) {
        this.images = images;
    }

    public SystemCheckReport layers(Map<String, List<String>> layers) {
        this.layers = layers;
        return this;
    }

    public SystemCheckReport putLayersItem(String key, List<String> layersItem) {
        if (this.layers == null) {
            this.layers = new HashMap<String, List<String>>();
        }
        this.layers.put(key, layersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Map<String, List<String>> getLayers() {
        return this.layers;
    }

    public void setLayers(Map<String, List<String>> layers) {
        this.layers = layers;
    }

    public SystemCheckReport roImages(Map<String, List<String>> roImages) {
        this.roImages = roImages;
        return this;
    }

    public SystemCheckReport putRoImagesItem(String key, List<String> roImagesItem) {
        if (this.roImages == null) {
            this.roImages = new HashMap<String, List<String>>();
        }
        this.roImages.put(key, roImagesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Map<String, List<String>> getRoImages() {
        return this.roImages;
    }

    public void setRoImages(Map<String, List<String>> roImages) {
        this.roImages = roImages;
    }

    public SystemCheckReport roLayers(Map<String, List<String>> roLayers) {
        this.roLayers = roLayers;
        return this;
    }

    public SystemCheckReport putRoLayersItem(String key, List<String> roLayersItem) {
        if (this.roLayers == null) {
            this.roLayers = new HashMap<String, List<String>>();
        }
        this.roLayers.put(key, roLayersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Map<String, List<String>> getRoLayers() {
        return this.roLayers;
    }

    public void setRoLayers(Map<String, List<String>> roLayers) {
        this.roLayers = roLayers;
    }

    public SystemCheckReport removedContainers(Map<String, String> removedContainers) {
        this.removedContainers = removedContainers;
        return this;
    }

    public SystemCheckReport putRemovedContainersItem(String key, String removedContainersItem) {
        if (this.removedContainers == null) {
            this.removedContainers = new HashMap<String, String>();
        }
        this.removedContainers.put(key, removedContainersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getRemovedContainers() {
        return this.removedContainers;
    }

    public void setRemovedContainers(Map<String, String> removedContainers) {
        this.removedContainers = removedContainers;
    }

    public SystemCheckReport removedImages(Map<String, List<String>> removedImages) {
        this.removedImages = removedImages;
        return this;
    }

    public SystemCheckReport putRemovedImagesItem(String key, List<String> removedImagesItem) {
        if (this.removedImages == null) {
            this.removedImages = new HashMap<String, List<String>>();
        }
        this.removedImages.put(key, removedImagesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Map<String, List<String>> getRemovedImages() {
        return this.removedImages;
    }

    public void setRemovedImages(Map<String, List<String>> removedImages) {
        this.removedImages = removedImages;
    }

    public SystemCheckReport removedLayers(List<String> removedLayers) {
        this.removedLayers = removedLayers;
        return this;
    }

    public SystemCheckReport addRemovedLayersItem(String removedLayersItem) {
        if (this.removedLayers == null) {
            this.removedLayers = new ArrayList<String>();
        }
        this.removedLayers.add(removedLayersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getRemovedLayers() {
        return this.removedLayers;
    }

    public void setRemovedLayers(List<String> removedLayers) {
        this.removedLayers = removedLayers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemCheckReport systemCheckReport = (SystemCheckReport)o;
        return Objects.equals(this.containers, systemCheckReport.containers) && Objects.equals(this.errors, systemCheckReport.errors) && Objects.equals(this.images, systemCheckReport.images) && Objects.equals(this.layers, systemCheckReport.layers) && Objects.equals(this.roImages, systemCheckReport.roImages) && Objects.equals(this.roLayers, systemCheckReport.roLayers) && Objects.equals(this.removedContainers, systemCheckReport.removedContainers) && Objects.equals(this.removedImages, systemCheckReport.removedImages) && Objects.equals(this.removedLayers, systemCheckReport.removedLayers);
    }

    public int hashCode() {
        return Objects.hash(this.containers, this.errors, this.images, this.layers, this.roImages, this.roLayers, this.removedContainers, this.removedImages, this.removedLayers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemCheckReport {\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("    roImages: ").append(this.toIndentedString(this.roImages)).append("\n");
        sb.append("    roLayers: ").append(this.toIndentedString(this.roLayers)).append("\n");
        sb.append("    removedContainers: ").append(this.toIndentedString(this.removedContainers)).append("\n");
        sb.append("    removedImages: ").append(this.toIndentedString(this.removedImages)).append("\n");
        sb.append("    removedLayers: ").append(this.toIndentedString(this.removedLayers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SystemCheckReport is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SystemCheckReport` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REMOVED_LAYERS) != null && !jsonObj.get(SERIALIZED_NAME_REMOVED_LAYERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REMOVED_LAYERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `RemovedLayers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REMOVED_LAYERS).toString()));
        }
    }

    public static SystemCheckReport fromJson(String jsonString) throws IOException {
        return (SystemCheckReport)JSON.getGson().fromJson(jsonString, SystemCheckReport.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_ERRORS);
        openapiFields.add(SERIALIZED_NAME_IMAGES);
        openapiFields.add(SERIALIZED_NAME_LAYERS);
        openapiFields.add(SERIALIZED_NAME_RO_IMAGES);
        openapiFields.add(SERIALIZED_NAME_RO_LAYERS);
        openapiFields.add(SERIALIZED_NAME_REMOVED_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_REMOVED_IMAGES);
        openapiFields.add(SERIALIZED_NAME_REMOVED_LAYERS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SystemCheckReport.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SystemCheckReport.class));
            return new TypeAdapter<SystemCheckReport>(){

                public void write(JsonWriter out, SystemCheckReport value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SystemCheckReport read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SystemCheckReport.validateJsonObject(jsonObj);
                    return (SystemCheckReport)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

