/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.IPAMConfig;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IPAM
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONFIG = "Config";
    @SerializedName(value="Config")
    private List<@Valid IPAMConfig> config = new ArrayList<IPAMConfig>();
    public static final String SERIALIZED_NAME_DRIVER = "Driver";
    @SerializedName(value="Driver")
    private String driver;
    public static final String SERIALIZED_NAME_OPTIONS = "Options";
    @SerializedName(value="Options")
    private Map<String, String> options = new HashMap<String, String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IPAM config(List<@Valid IPAMConfig> config) {
        this.config = config;
        return this;
    }

    public IPAM addConfigItem(IPAMConfig configItem) {
        if (this.config == null) {
            this.config = new ArrayList<IPAMConfig>();
        }
        this.config.add(configItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid IPAMConfig> getConfig() {
        return this.config;
    }

    public void setConfig(List<@Valid IPAMConfig> config) {
        this.config = config;
    }

    public IPAM driver(String driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public IPAM options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public IPAM putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPAM IPAM2 = (IPAM)o;
        return Objects.equals(this.config, IPAM2.config) && Objects.equals(this.driver, IPAM2.driver) && Objects.equals(this.options, IPAM2.options);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.driver, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IPAM {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconfig;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in IPAM is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IPAM` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull() && (jsonArrayconfig = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONFIG)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Config` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIG).toString()));
            }
            for (int i = 0; i < jsonArrayconfig.size(); ++i) {
                IPAMConfig.validateJsonElement(jsonArrayconfig.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
    }

    public static IPAM fromJson(String jsonString) throws IOException {
        return (IPAM)JSON.getGson().fromJson(jsonString, IPAM.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!IPAM.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IPAM.class));
            return new TypeAdapter<IPAM>(){

                public void write(JsonWriter out, IPAM value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public IPAM read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    IPAM.validateJsonElement(jsonElement);
                    return (IPAM)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

