/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.IPNet;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NetAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_GATEWAY = "gateway";
    @SerializedName(value="gateway")
    private String gateway;
    public static final String SERIALIZED_NAME_IPNET = "ipnet";
    @SerializedName(value="ipnet")
    private IPNet ipnet;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NetAddress gateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public NetAddress ipnet(IPNet ipnet) {
        this.ipnet = ipnet;
        return this;
    }

    @Nullable
    @Valid
    public IPNet getIpnet() {
        return this.ipnet;
    }

    public void setIpnet(IPNet ipnet) {
        this.ipnet = ipnet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetAddress netAddress = (NetAddress)o;
        return Objects.equals(this.gateway, netAddress.gateway) && Objects.equals(this.ipnet, netAddress.ipnet);
    }

    public int hashCode() {
        return Objects.hash(this.gateway, this.ipnet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetAddress {\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    ipnet: ").append(this.toIndentedString(this.ipnet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in NetAddress is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NetAddress` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_GATEWAY) != null && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPNET) != null && !jsonObj.get(SERIALIZED_NAME_IPNET).isJsonNull()) {
            IPNet.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IPNET));
        }
    }

    public static NetAddress fromJson(String jsonString) throws IOException {
        return (NetAddress)JSON.getGson().fromJson(jsonString, NetAddress.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_IPNET);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NetAddress.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NetAddress.class));
            return new TypeAdapter<NetAddress>(this){

                public void write(JsonWriter out, NetAddress value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NetAddress read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    NetAddress.validateJsonElement(jsonElement);
                    return (NetAddress)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

