/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.LibpodInfo;
import io.github.pod4dev.libpodj.model.SystemCheckReport;
import io.github.pod4dev.libpodj.model.SystemComponentVersion;
import io.github.pod4dev.libpodj.model.SystemDfReport;
import io.github.pod4dev.libpodj.model.SystemPruneReport;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SystemApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SystemApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SystemApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call systemCheckLibpodCall(Boolean quick, Boolean repair, Boolean repairLossy, String unreferencedLayerMaxAge, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/system/check";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (quick != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("quick", quick));
        }
        if (repair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("repair", repair));
        }
        if (repairLossy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("repair_lossy", repairLossy));
        }
        if (unreferencedLayerMaxAge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("unreferenced_layer_max_age", unreferencedLayerMaxAge));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemCheckLibpodValidateBeforeCall(Boolean quick, Boolean repair, Boolean repairLossy, String unreferencedLayerMaxAge, ApiCallback _callback) throws ApiException {
        return this.systemCheckLibpodCall(quick, repair, repairLossy, unreferencedLayerMaxAge, _callback);
    }

    private ApiResponse<SystemCheckReport> systemCheckLibpodWithHttpInfo(Boolean quick, Boolean repair, Boolean repairLossy, String unreferencedLayerMaxAge) throws ApiException {
        Call localVarCall = this.systemCheckLibpodValidateBeforeCall(quick, repair, repairLossy, unreferencedLayerMaxAge, null);
        Type localVarReturnType = new TypeToken<SystemCheckReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemCheckLibpodAsync(Boolean quick, Boolean repair, Boolean repairLossy, String unreferencedLayerMaxAge, ApiCallback<SystemCheckReport> _callback) throws ApiException {
        Call localVarCall = this.systemCheckLibpodValidateBeforeCall(quick, repair, repairLossy, unreferencedLayerMaxAge, _callback);
        Type localVarReturnType = new TypeToken<SystemCheckReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemCheckLibpodRequest systemCheckLibpod() {
        return new APIsystemCheckLibpodRequest();
    }

    private Call systemDataUsageLibpodCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/system/df";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemDataUsageLibpodValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.systemDataUsageLibpodCall(_callback);
    }

    private ApiResponse<SystemDfReport> systemDataUsageLibpodWithHttpInfo() throws ApiException {
        Call localVarCall = this.systemDataUsageLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SystemDfReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemDataUsageLibpodAsync(ApiCallback<SystemDfReport> _callback) throws ApiException {
        Call localVarCall = this.systemDataUsageLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SystemDfReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemDataUsageLibpodRequest systemDataUsageLibpod() {
        return new APIsystemDataUsageLibpodRequest();
    }

    private Call systemEventsLibpodCall(String since, String until, String filters, Boolean stream, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (since != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since", since));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (stream != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stream", stream));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemEventsLibpodValidateBeforeCall(String since, String until, String filters, Boolean stream, ApiCallback _callback) throws ApiException {
        return this.systemEventsLibpodCall(since, until, filters, stream, _callback);
    }

    private ApiResponse<Void> systemEventsLibpodWithHttpInfo(String since, String until, String filters, Boolean stream) throws ApiException {
        Call localVarCall = this.systemEventsLibpodValidateBeforeCall(since, until, filters, stream, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call systemEventsLibpodAsync(String since, String until, String filters, Boolean stream, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.systemEventsLibpodValidateBeforeCall(since, until, filters, stream, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsystemEventsLibpodRequest systemEventsLibpod() {
        return new APIsystemEventsLibpodRequest();
    }

    private Call systemInfoLibpodCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemInfoLibpodValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.systemInfoLibpodCall(_callback);
    }

    private ApiResponse<LibpodInfo> systemInfoLibpodWithHttpInfo() throws ApiException {
        Call localVarCall = this.systemInfoLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<LibpodInfo>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemInfoLibpodAsync(ApiCallback<LibpodInfo> _callback) throws ApiException {
        Call localVarCall = this.systemInfoLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<LibpodInfo>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemInfoLibpodRequest systemInfoLibpod() {
        return new APIsystemInfoLibpodRequest();
    }

    private Call systemPing_0Call(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/_ping";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemPing_0ValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.systemPing_0Call(_callback);
    }

    private ApiResponse<String> systemPing_0WithHttpInfo() throws ApiException {
        Call localVarCall = this.systemPing_0ValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemPing_0Async(ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.systemPing_0ValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemPing_0Request systemPing_0() {
        return new APIsystemPing_0Request();
    }

    private Call systemPruneLibpodCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/system/prune";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemPruneLibpodValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.systemPruneLibpodCall(_callback);
    }

    private ApiResponse<SystemPruneReport> systemPruneLibpodWithHttpInfo() throws ApiException {
        Call localVarCall = this.systemPruneLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SystemPruneReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemPruneLibpodAsync(ApiCallback<SystemPruneReport> _callback) throws ApiException {
        Call localVarCall = this.systemPruneLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SystemPruneReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemPruneLibpodRequest systemPruneLibpod() {
        return new APIsystemPruneLibpodRequest();
    }

    private Call systemVersionLibpodCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/version";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemVersionLibpodValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.systemVersionLibpodCall(_callback);
    }

    private ApiResponse<SystemComponentVersion> systemVersionLibpodWithHttpInfo() throws ApiException {
        Call localVarCall = this.systemVersionLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SystemComponentVersion>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemVersionLibpodAsync(ApiCallback<SystemComponentVersion> _callback) throws ApiException {
        Call localVarCall = this.systemVersionLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SystemComponentVersion>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemVersionLibpodRequest systemVersionLibpod() {
        return new APIsystemVersionLibpodRequest();
    }

    public class APIsystemCheckLibpodRequest {
        private Boolean quick;
        private Boolean repair;
        private Boolean repairLossy;
        private String unreferencedLayerMaxAge;

        private APIsystemCheckLibpodRequest() {
        }

        public APIsystemCheckLibpodRequest quick(Boolean quick) {
            this.quick = quick;
            return this;
        }

        public APIsystemCheckLibpodRequest repair(Boolean repair) {
            this.repair = repair;
            return this;
        }

        public APIsystemCheckLibpodRequest repairLossy(Boolean repairLossy) {
            this.repairLossy = repairLossy;
            return this;
        }

        public APIsystemCheckLibpodRequest unreferencedLayerMaxAge(String unreferencedLayerMaxAge) {
            this.unreferencedLayerMaxAge = unreferencedLayerMaxAge;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemApi.this.systemCheckLibpodCall(this.quick, this.repair, this.repairLossy, this.unreferencedLayerMaxAge, _callback);
        }

        public SystemCheckReport execute() throws ApiException {
            ApiResponse<SystemCheckReport> localVarResp = SystemApi.this.systemCheckLibpodWithHttpInfo(this.quick, this.repair, this.repairLossy, this.unreferencedLayerMaxAge);
            return localVarResp.getData();
        }

        public ApiResponse<SystemCheckReport> executeWithHttpInfo() throws ApiException {
            return SystemApi.this.systemCheckLibpodWithHttpInfo(this.quick, this.repair, this.repairLossy, this.unreferencedLayerMaxAge);
        }

        public Call executeAsync(ApiCallback<SystemCheckReport> _callback) throws ApiException {
            return SystemApi.this.systemCheckLibpodAsync(this.quick, this.repair, this.repairLossy, this.unreferencedLayerMaxAge, _callback);
        }
    }

    public class APIsystemDataUsageLibpodRequest {
        private APIsystemDataUsageLibpodRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemApi.this.systemDataUsageLibpodCall(_callback);
        }

        public SystemDfReport execute() throws ApiException {
            ApiResponse<SystemDfReport> localVarResp = SystemApi.this.systemDataUsageLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<SystemDfReport> executeWithHttpInfo() throws ApiException {
            return SystemApi.this.systemDataUsageLibpodWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<SystemDfReport> _callback) throws ApiException {
            return SystemApi.this.systemDataUsageLibpodAsync(_callback);
        }
    }

    public class APIsystemEventsLibpodRequest {
        private String since;
        private String until;
        private String filters;
        private Boolean stream;

        private APIsystemEventsLibpodRequest() {
        }

        public APIsystemEventsLibpodRequest since(String since) {
            this.since = since;
            return this;
        }

        public APIsystemEventsLibpodRequest until(String until) {
            this.until = until;
            return this;
        }

        public APIsystemEventsLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public APIsystemEventsLibpodRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemApi.this.systemEventsLibpodCall(this.since, this.until, this.filters, this.stream, _callback);
        }

        public void execute() throws ApiException {
            SystemApi.this.systemEventsLibpodWithHttpInfo(this.since, this.until, this.filters, this.stream);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return SystemApi.this.systemEventsLibpodWithHttpInfo(this.since, this.until, this.filters, this.stream);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return SystemApi.this.systemEventsLibpodAsync(this.since, this.until, this.filters, this.stream, _callback);
        }
    }

    public class APIsystemInfoLibpodRequest {
        private APIsystemInfoLibpodRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemApi.this.systemInfoLibpodCall(_callback);
        }

        public LibpodInfo execute() throws ApiException {
            ApiResponse<LibpodInfo> localVarResp = SystemApi.this.systemInfoLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<LibpodInfo> executeWithHttpInfo() throws ApiException {
            return SystemApi.this.systemInfoLibpodWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<LibpodInfo> _callback) throws ApiException {
            return SystemApi.this.systemInfoLibpodAsync(_callback);
        }
    }

    public class APIsystemPing_0Request {
        private APIsystemPing_0Request() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemApi.this.systemPing_0Call(_callback);
        }

        public String execute() throws ApiException {
            ApiResponse<String> localVarResp = SystemApi.this.systemPing_0WithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<String> executeWithHttpInfo() throws ApiException {
            return SystemApi.this.systemPing_0WithHttpInfo();
        }

        public Call executeAsync(ApiCallback<String> _callback) throws ApiException {
            return SystemApi.this.systemPing_0Async(_callback);
        }
    }

    public class APIsystemPruneLibpodRequest {
        private APIsystemPruneLibpodRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemApi.this.systemPruneLibpodCall(_callback);
        }

        public SystemPruneReport execute() throws ApiException {
            ApiResponse<SystemPruneReport> localVarResp = SystemApi.this.systemPruneLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<SystemPruneReport> executeWithHttpInfo() throws ApiException {
            return SystemApi.this.systemPruneLibpodWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<SystemPruneReport> _callback) throws ApiException {
            return SystemApi.this.systemPruneLibpodAsync(_callback);
        }
    }

    public class APIsystemVersionLibpodRequest {
        private APIsystemVersionLibpodRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemApi.this.systemVersionLibpodCall(_callback);
        }

        public SystemComponentVersion execute() throws ApiException {
            ApiResponse<SystemComponentVersion> localVarResp = SystemApi.this.systemVersionLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<SystemComponentVersion> executeWithHttpInfo() throws ApiException {
            return SystemApi.this.systemVersionLibpodWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<SystemComponentVersion> _callback) throws ApiException {
            return SystemApi.this.systemVersionLibpodAsync(_callback);
        }
    }
}

