/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ArtifactVolume;
import io.github.pod4dev.libpodj.model.ImageVolume;
import io.github.pod4dev.libpodj.model.LinuxDevice;
import io.github.pod4dev.libpodj.model.LinuxDeviceCgroup;
import io.github.pod4dev.libpodj.model.Mount;
import io.github.pod4dev.libpodj.model.NamedVolume;
import io.github.pod4dev.libpodj.model.Namespace;
import io.github.pod4dev.libpodj.model.OverlayVolume;
import io.github.pod4dev.libpodj.model.Secret;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ContainerStorageConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ARTIFACT_VOLUMES = "artifact_volumes";
    @SerializedName(value="artifact_volumes")
    private List<@Valid ArtifactVolume> artifactVolumes = new ArrayList<ArtifactVolume>();
    public static final String SERIALIZED_NAME_CHROOT_DIRECTORIES = "chroot_directories";
    @SerializedName(value="chroot_directories")
    private List<String> chrootDirectories = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CREATE_WORKING_DIR = "create_working_dir";
    @SerializedName(value="create_working_dir")
    private Boolean createWorkingDir;
    public static final String SERIALIZED_NAME_DEVICE_CGROUP_RULE = "device_cgroup_rule";
    @SerializedName(value="device_cgroup_rule")
    private List<@Valid LinuxDeviceCgroup> deviceCgroupRule = new ArrayList<LinuxDeviceCgroup>();
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private List<@Valid LinuxDevice> devices = new ArrayList<LinuxDevice>();
    public static final String SERIALIZED_NAME_DEVICES_FROM = "devices_from";
    @SerializedName(value="devices_from")
    private List<String> devicesFrom = new ArrayList<String>();
    public static final String SERIALIZED_NAME_HOST_DEVICE_LIST = "host_device_list";
    @SerializedName(value="host_device_list")
    private List<@Valid LinuxDevice> hostDeviceList = new ArrayList<LinuxDevice>();
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private String image;
    public static final String SERIALIZED_NAME_IMAGE_ARCH = "image_arch";
    @SerializedName(value="image_arch")
    private String imageArch;
    public static final String SERIALIZED_NAME_IMAGE_OS = "image_os";
    @SerializedName(value="image_os")
    private String imageOs;
    public static final String SERIALIZED_NAME_IMAGE_VARIANT = "image_variant";
    @SerializedName(value="image_variant")
    private String imageVariant;
    public static final String SERIALIZED_NAME_IMAGE_VOLUME_MODE = "image_volume_mode";
    @SerializedName(value="image_volume_mode")
    private String imageVolumeMode;
    public static final String SERIALIZED_NAME_IMAGE_VOLUMES = "image_volumes";
    @SerializedName(value="image_volumes")
    private List<@Valid ImageVolume> imageVolumes = new ArrayList<ImageVolume>();
    public static final String SERIALIZED_NAME_INIT = "init";
    @SerializedName(value="init")
    private Boolean init;
    public static final String SERIALIZED_NAME_INIT_PATH = "init_path";
    @SerializedName(value="init_path")
    private String initPath;
    public static final String SERIALIZED_NAME_IPCNS = "ipcns";
    @SerializedName(value="ipcns")
    private Namespace ipcns;
    public static final String SERIALIZED_NAME_MOUNTS = "mounts";
    @SerializedName(value="mounts")
    private List<@Valid Mount> mounts = new ArrayList<Mount>();
    public static final String SERIALIZED_NAME_OVERLAY_VOLUMES = "overlay_volumes";
    @SerializedName(value="overlay_volumes")
    private List<@Valid OverlayVolume> overlayVolumes = new ArrayList<OverlayVolume>();
    public static final String SERIALIZED_NAME_RAW_IMAGE_NAME = "raw_image_name";
    @SerializedName(value="raw_image_name")
    private String rawImageName;
    public static final String SERIALIZED_NAME_ROOTFS = "rootfs";
    @SerializedName(value="rootfs")
    private String rootfs;
    public static final String SERIALIZED_NAME_ROOTFS_MAPPING = "rootfs_mapping";
    @SerializedName(value="rootfs_mapping")
    private String rootfsMapping;
    public static final String SERIALIZED_NAME_ROOTFS_OVERLAY = "rootfs_overlay";
    @SerializedName(value="rootfs_overlay")
    private Boolean rootfsOverlay;
    public static final String SERIALIZED_NAME_ROOTFS_PROPAGATION = "rootfs_propagation";
    @SerializedName(value="rootfs_propagation")
    private String rootfsPropagation;
    public static final String SERIALIZED_NAME_SECRETS = "secrets";
    @SerializedName(value="secrets")
    private List<@Valid Secret> secrets = new ArrayList<Secret>();
    public static final String SERIALIZED_NAME_SHM_SIZE = "shm_size";
    @SerializedName(value="shm_size")
    private Long shmSize;
    public static final String SERIALIZED_NAME_SHM_SIZE_SYSTEMD = "shm_size_systemd";
    @SerializedName(value="shm_size_systemd")
    private Long shmSizeSystemd;
    public static final String SERIALIZED_NAME_STORAGE_OPTS = "storage_opts";
    @SerializedName(value="storage_opts")
    private Map<String, String> storageOpts = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_VOLATILE = "volatile";
    @SerializedName(value="volatile")
    private Boolean _volatile;
    public static final String SERIALIZED_NAME_VOLUMES = "volumes";
    @SerializedName(value="volumes")
    private List<@Valid NamedVolume> volumes = new ArrayList<NamedVolume>();
    public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
    @SerializedName(value="volumes_from")
    private List<String> volumesFrom = new ArrayList<String>();
    public static final String SERIALIZED_NAME_WORK_DIR = "work_dir";
    @SerializedName(value="work_dir")
    private String workDir;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContainerStorageConfig artifactVolumes(List<@Valid ArtifactVolume> artifactVolumes) {
        this.artifactVolumes = artifactVolumes;
        return this;
    }

    public ContainerStorageConfig addArtifactVolumesItem(ArtifactVolume artifactVolumesItem) {
        if (this.artifactVolumes == null) {
            this.artifactVolumes = new ArrayList<ArtifactVolume>();
        }
        this.artifactVolumes.add(artifactVolumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid ArtifactVolume> getArtifactVolumes() {
        return this.artifactVolumes;
    }

    public void setArtifactVolumes(List<@Valid ArtifactVolume> artifactVolumes) {
        this.artifactVolumes = artifactVolumes;
    }

    public ContainerStorageConfig chrootDirectories(List<String> chrootDirectories) {
        this.chrootDirectories = chrootDirectories;
        return this;
    }

    public ContainerStorageConfig addChrootDirectoriesItem(String chrootDirectoriesItem) {
        if (this.chrootDirectories == null) {
            this.chrootDirectories = new ArrayList<String>();
        }
        this.chrootDirectories.add(chrootDirectoriesItem);
        return this;
    }

    @Nullable
    public List<String> getChrootDirectories() {
        return this.chrootDirectories;
    }

    public void setChrootDirectories(List<String> chrootDirectories) {
        this.chrootDirectories = chrootDirectories;
    }

    public ContainerStorageConfig createWorkingDir(Boolean createWorkingDir) {
        this.createWorkingDir = createWorkingDir;
        return this;
    }

    @Nullable
    public Boolean getCreateWorkingDir() {
        return this.createWorkingDir;
    }

    public void setCreateWorkingDir(Boolean createWorkingDir) {
        this.createWorkingDir = createWorkingDir;
    }

    public ContainerStorageConfig deviceCgroupRule(List<@Valid LinuxDeviceCgroup> deviceCgroupRule) {
        this.deviceCgroupRule = deviceCgroupRule;
        return this;
    }

    public ContainerStorageConfig addDeviceCgroupRuleItem(LinuxDeviceCgroup deviceCgroupRuleItem) {
        if (this.deviceCgroupRule == null) {
            this.deviceCgroupRule = new ArrayList<LinuxDeviceCgroup>();
        }
        this.deviceCgroupRule.add(deviceCgroupRuleItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid LinuxDeviceCgroup> getDeviceCgroupRule() {
        return this.deviceCgroupRule;
    }

    public void setDeviceCgroupRule(List<@Valid LinuxDeviceCgroup> deviceCgroupRule) {
        this.deviceCgroupRule = deviceCgroupRule;
    }

    public ContainerStorageConfig devices(List<@Valid LinuxDevice> devices) {
        this.devices = devices;
        return this;
    }

    public ContainerStorageConfig addDevicesItem(LinuxDevice devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<LinuxDevice>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid LinuxDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(List<@Valid LinuxDevice> devices) {
        this.devices = devices;
    }

    public ContainerStorageConfig devicesFrom(List<String> devicesFrom) {
        this.devicesFrom = devicesFrom;
        return this;
    }

    public ContainerStorageConfig addDevicesFromItem(String devicesFromItem) {
        if (this.devicesFrom == null) {
            this.devicesFrom = new ArrayList<String>();
        }
        this.devicesFrom.add(devicesFromItem);
        return this;
    }

    @Nullable
    public List<String> getDevicesFrom() {
        return this.devicesFrom;
    }

    public void setDevicesFrom(List<String> devicesFrom) {
        this.devicesFrom = devicesFrom;
    }

    public ContainerStorageConfig hostDeviceList(List<@Valid LinuxDevice> hostDeviceList) {
        this.hostDeviceList = hostDeviceList;
        return this;
    }

    public ContainerStorageConfig addHostDeviceListItem(LinuxDevice hostDeviceListItem) {
        if (this.hostDeviceList == null) {
            this.hostDeviceList = new ArrayList<LinuxDevice>();
        }
        this.hostDeviceList.add(hostDeviceListItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid LinuxDevice> getHostDeviceList() {
        return this.hostDeviceList;
    }

    public void setHostDeviceList(List<@Valid LinuxDevice> hostDeviceList) {
        this.hostDeviceList = hostDeviceList;
    }

    public ContainerStorageConfig image(String image) {
        this.image = image;
        return this;
    }

    @Nullable
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ContainerStorageConfig imageArch(String imageArch) {
        this.imageArch = imageArch;
        return this;
    }

    @Nullable
    public String getImageArch() {
        return this.imageArch;
    }

    public void setImageArch(String imageArch) {
        this.imageArch = imageArch;
    }

    public ContainerStorageConfig imageOs(String imageOs) {
        this.imageOs = imageOs;
        return this;
    }

    @Nullable
    public String getImageOs() {
        return this.imageOs;
    }

    public void setImageOs(String imageOs) {
        this.imageOs = imageOs;
    }

    public ContainerStorageConfig imageVariant(String imageVariant) {
        this.imageVariant = imageVariant;
        return this;
    }

    @Nullable
    public String getImageVariant() {
        return this.imageVariant;
    }

    public void setImageVariant(String imageVariant) {
        this.imageVariant = imageVariant;
    }

    public ContainerStorageConfig imageVolumeMode(String imageVolumeMode) {
        this.imageVolumeMode = imageVolumeMode;
        return this;
    }

    @Nullable
    public String getImageVolumeMode() {
        return this.imageVolumeMode;
    }

    public void setImageVolumeMode(String imageVolumeMode) {
        this.imageVolumeMode = imageVolumeMode;
    }

    public ContainerStorageConfig imageVolumes(List<@Valid ImageVolume> imageVolumes) {
        this.imageVolumes = imageVolumes;
        return this;
    }

    public ContainerStorageConfig addImageVolumesItem(ImageVolume imageVolumesItem) {
        if (this.imageVolumes == null) {
            this.imageVolumes = new ArrayList<ImageVolume>();
        }
        this.imageVolumes.add(imageVolumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid ImageVolume> getImageVolumes() {
        return this.imageVolumes;
    }

    public void setImageVolumes(List<@Valid ImageVolume> imageVolumes) {
        this.imageVolumes = imageVolumes;
    }

    public ContainerStorageConfig init(Boolean init) {
        this.init = init;
        return this;
    }

    @Nullable
    public Boolean getInit() {
        return this.init;
    }

    public void setInit(Boolean init) {
        this.init = init;
    }

    public ContainerStorageConfig initPath(String initPath) {
        this.initPath = initPath;
        return this;
    }

    @Nullable
    public String getInitPath() {
        return this.initPath;
    }

    public void setInitPath(String initPath) {
        this.initPath = initPath;
    }

    public ContainerStorageConfig ipcns(Namespace ipcns) {
        this.ipcns = ipcns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getIpcns() {
        return this.ipcns;
    }

    public void setIpcns(Namespace ipcns) {
        this.ipcns = ipcns;
    }

    public ContainerStorageConfig mounts(List<@Valid Mount> mounts) {
        this.mounts = mounts;
        return this;
    }

    public ContainerStorageConfig addMountsItem(Mount mountsItem) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<Mount>();
        }
        this.mounts.add(mountsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid Mount> getMounts() {
        return this.mounts;
    }

    public void setMounts(List<@Valid Mount> mounts) {
        this.mounts = mounts;
    }

    public ContainerStorageConfig overlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
        this.overlayVolumes = overlayVolumes;
        return this;
    }

    public ContainerStorageConfig addOverlayVolumesItem(OverlayVolume overlayVolumesItem) {
        if (this.overlayVolumes == null) {
            this.overlayVolumes = new ArrayList<OverlayVolume>();
        }
        this.overlayVolumes.add(overlayVolumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid OverlayVolume> getOverlayVolumes() {
        return this.overlayVolumes;
    }

    public void setOverlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
        this.overlayVolumes = overlayVolumes;
    }

    public ContainerStorageConfig rawImageName(String rawImageName) {
        this.rawImageName = rawImageName;
        return this;
    }

    @Nullable
    public String getRawImageName() {
        return this.rawImageName;
    }

    public void setRawImageName(String rawImageName) {
        this.rawImageName = rawImageName;
    }

    public ContainerStorageConfig rootfs(String rootfs) {
        this.rootfs = rootfs;
        return this;
    }

    @Nullable
    public String getRootfs() {
        return this.rootfs;
    }

    public void setRootfs(String rootfs) {
        this.rootfs = rootfs;
    }

    public ContainerStorageConfig rootfsMapping(String rootfsMapping) {
        this.rootfsMapping = rootfsMapping;
        return this;
    }

    @Nullable
    public String getRootfsMapping() {
        return this.rootfsMapping;
    }

    public void setRootfsMapping(String rootfsMapping) {
        this.rootfsMapping = rootfsMapping;
    }

    public ContainerStorageConfig rootfsOverlay(Boolean rootfsOverlay) {
        this.rootfsOverlay = rootfsOverlay;
        return this;
    }

    @Nullable
    public Boolean getRootfsOverlay() {
        return this.rootfsOverlay;
    }

    public void setRootfsOverlay(Boolean rootfsOverlay) {
        this.rootfsOverlay = rootfsOverlay;
    }

    public ContainerStorageConfig rootfsPropagation(String rootfsPropagation) {
        this.rootfsPropagation = rootfsPropagation;
        return this;
    }

    @Nullable
    public String getRootfsPropagation() {
        return this.rootfsPropagation;
    }

    public void setRootfsPropagation(String rootfsPropagation) {
        this.rootfsPropagation = rootfsPropagation;
    }

    public ContainerStorageConfig secrets(List<@Valid Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public ContainerStorageConfig addSecretsItem(Secret secretsItem) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<Secret>();
        }
        this.secrets.add(secretsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid Secret> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<@Valid Secret> secrets) {
        this.secrets = secrets;
    }

    public ContainerStorageConfig shmSize(Long shmSize) {
        this.shmSize = shmSize;
        return this;
    }

    @Nullable
    public Long getShmSize() {
        return this.shmSize;
    }

    public void setShmSize(Long shmSize) {
        this.shmSize = shmSize;
    }

    public ContainerStorageConfig shmSizeSystemd(Long shmSizeSystemd) {
        this.shmSizeSystemd = shmSizeSystemd;
        return this;
    }

    @Nullable
    public Long getShmSizeSystemd() {
        return this.shmSizeSystemd;
    }

    public void setShmSizeSystemd(Long shmSizeSystemd) {
        this.shmSizeSystemd = shmSizeSystemd;
    }

    public ContainerStorageConfig storageOpts(Map<String, String> storageOpts) {
        this.storageOpts = storageOpts;
        return this;
    }

    public ContainerStorageConfig putStorageOptsItem(String key, String storageOptsItem) {
        if (this.storageOpts == null) {
            this.storageOpts = new HashMap<String, String>();
        }
        this.storageOpts.put(key, storageOptsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getStorageOpts() {
        return this.storageOpts;
    }

    public void setStorageOpts(Map<String, String> storageOpts) {
        this.storageOpts = storageOpts;
    }

    public ContainerStorageConfig _volatile(Boolean _volatile) {
        this._volatile = _volatile;
        return this;
    }

    @Nullable
    public Boolean getVolatile() {
        return this._volatile;
    }

    public void setVolatile(Boolean _volatile) {
        this._volatile = _volatile;
    }

    public ContainerStorageConfig volumes(List<@Valid NamedVolume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public ContainerStorageConfig addVolumesItem(NamedVolume volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<NamedVolume>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid NamedVolume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<@Valid NamedVolume> volumes) {
        this.volumes = volumes;
    }

    public ContainerStorageConfig volumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public ContainerStorageConfig addVolumesFromItem(String volumesFromItem) {
        if (this.volumesFrom == null) {
            this.volumesFrom = new ArrayList<String>();
        }
        this.volumesFrom.add(volumesFromItem);
        return this;
    }

    @Nullable
    public List<String> getVolumesFrom() {
        return this.volumesFrom;
    }

    public void setVolumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
    }

    public ContainerStorageConfig workDir(String workDir) {
        this.workDir = workDir;
        return this;
    }

    @Nullable
    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerStorageConfig containerStorageConfig = (ContainerStorageConfig)o;
        return Objects.equals(this.artifactVolumes, containerStorageConfig.artifactVolumes) && Objects.equals(this.chrootDirectories, containerStorageConfig.chrootDirectories) && Objects.equals(this.createWorkingDir, containerStorageConfig.createWorkingDir) && Objects.equals(this.deviceCgroupRule, containerStorageConfig.deviceCgroupRule) && Objects.equals(this.devices, containerStorageConfig.devices) && Objects.equals(this.devicesFrom, containerStorageConfig.devicesFrom) && Objects.equals(this.hostDeviceList, containerStorageConfig.hostDeviceList) && Objects.equals(this.image, containerStorageConfig.image) && Objects.equals(this.imageArch, containerStorageConfig.imageArch) && Objects.equals(this.imageOs, containerStorageConfig.imageOs) && Objects.equals(this.imageVariant, containerStorageConfig.imageVariant) && Objects.equals(this.imageVolumeMode, containerStorageConfig.imageVolumeMode) && Objects.equals(this.imageVolumes, containerStorageConfig.imageVolumes) && Objects.equals(this.init, containerStorageConfig.init) && Objects.equals(this.initPath, containerStorageConfig.initPath) && Objects.equals(this.ipcns, containerStorageConfig.ipcns) && Objects.equals(this.mounts, containerStorageConfig.mounts) && Objects.equals(this.overlayVolumes, containerStorageConfig.overlayVolumes) && Objects.equals(this.rawImageName, containerStorageConfig.rawImageName) && Objects.equals(this.rootfs, containerStorageConfig.rootfs) && Objects.equals(this.rootfsMapping, containerStorageConfig.rootfsMapping) && Objects.equals(this.rootfsOverlay, containerStorageConfig.rootfsOverlay) && Objects.equals(this.rootfsPropagation, containerStorageConfig.rootfsPropagation) && Objects.equals(this.secrets, containerStorageConfig.secrets) && Objects.equals(this.shmSize, containerStorageConfig.shmSize) && Objects.equals(this.shmSizeSystemd, containerStorageConfig.shmSizeSystemd) && Objects.equals(this.storageOpts, containerStorageConfig.storageOpts) && Objects.equals(this._volatile, containerStorageConfig._volatile) && Objects.equals(this.volumes, containerStorageConfig.volumes) && Objects.equals(this.volumesFrom, containerStorageConfig.volumesFrom) && Objects.equals(this.workDir, containerStorageConfig.workDir);
    }

    public int hashCode() {
        return Objects.hash(this.artifactVolumes, this.chrootDirectories, this.createWorkingDir, this.deviceCgroupRule, this.devices, this.devicesFrom, this.hostDeviceList, this.image, this.imageArch, this.imageOs, this.imageVariant, this.imageVolumeMode, this.imageVolumes, this.init, this.initPath, this.ipcns, this.mounts, this.overlayVolumes, this.rawImageName, this.rootfs, this.rootfsMapping, this.rootfsOverlay, this.rootfsPropagation, this.secrets, this.shmSize, this.shmSizeSystemd, this.storageOpts, this._volatile, this.volumes, this.volumesFrom, this.workDir);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerStorageConfig {\n");
        sb.append("    artifactVolumes: ").append(this.toIndentedString(this.artifactVolumes)).append("\n");
        sb.append("    chrootDirectories: ").append(this.toIndentedString(this.chrootDirectories)).append("\n");
        sb.append("    createWorkingDir: ").append(this.toIndentedString(this.createWorkingDir)).append("\n");
        sb.append("    deviceCgroupRule: ").append(this.toIndentedString(this.deviceCgroupRule)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    devicesFrom: ").append(this.toIndentedString(this.devicesFrom)).append("\n");
        sb.append("    hostDeviceList: ").append(this.toIndentedString(this.hostDeviceList)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imageArch: ").append(this.toIndentedString(this.imageArch)).append("\n");
        sb.append("    imageOs: ").append(this.toIndentedString(this.imageOs)).append("\n");
        sb.append("    imageVariant: ").append(this.toIndentedString(this.imageVariant)).append("\n");
        sb.append("    imageVolumeMode: ").append(this.toIndentedString(this.imageVolumeMode)).append("\n");
        sb.append("    imageVolumes: ").append(this.toIndentedString(this.imageVolumes)).append("\n");
        sb.append("    init: ").append(this.toIndentedString(this.init)).append("\n");
        sb.append("    initPath: ").append(this.toIndentedString(this.initPath)).append("\n");
        sb.append("    ipcns: ").append(this.toIndentedString(this.ipcns)).append("\n");
        sb.append("    mounts: ").append(this.toIndentedString(this.mounts)).append("\n");
        sb.append("    overlayVolumes: ").append(this.toIndentedString(this.overlayVolumes)).append("\n");
        sb.append("    rawImageName: ").append(this.toIndentedString(this.rawImageName)).append("\n");
        sb.append("    rootfs: ").append(this.toIndentedString(this.rootfs)).append("\n");
        sb.append("    rootfsMapping: ").append(this.toIndentedString(this.rootfsMapping)).append("\n");
        sb.append("    rootfsOverlay: ").append(this.toIndentedString(this.rootfsOverlay)).append("\n");
        sb.append("    rootfsPropagation: ").append(this.toIndentedString(this.rootfsPropagation)).append("\n");
        sb.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        sb.append("    shmSize: ").append(this.toIndentedString(this.shmSize)).append("\n");
        sb.append("    shmSizeSystemd: ").append(this.toIndentedString(this.shmSizeSystemd)).append("\n");
        sb.append("    storageOpts: ").append(this.toIndentedString(this.storageOpts)).append("\n");
        sb.append("    _volatile: ").append(this.toIndentedString(this._volatile)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("    volumesFrom: ").append(this.toIndentedString(this.volumesFrom)).append("\n");
        sb.append("    workDir: ").append(this.toIndentedString(this.workDir)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvolumes;
        JsonArray jsonArraysecrets;
        JsonArray jsonArrayoverlayVolumes;
        JsonArray jsonArraymounts;
        JsonArray jsonArrayimageVolumes;
        JsonArray jsonArrayhostDeviceList;
        JsonArray jsonArraydevices;
        JsonArray jsonArraydeviceCgroupRule;
        int i;
        JsonArray jsonArrayartifactVolumes;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContainerStorageConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ContainerStorageConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ARTIFACT_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_ARTIFACT_VOLUMES).isJsonNull() && (jsonArrayartifactVolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_ARTIFACT_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ARTIFACT_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `artifact_volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARTIFACT_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayartifactVolumes.size(); ++i) {
                ArtifactVolume.validateJsonElement(jsonArrayartifactVolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CHROOT_DIRECTORIES) != null && !jsonObj.get(SERIALIZED_NAME_CHROOT_DIRECTORIES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CHROOT_DIRECTORIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `chroot_directories` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHROOT_DIRECTORIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_CGROUP_RULE) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_CGROUP_RULE).isJsonNull() && (jsonArraydeviceCgroupRule = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICE_CGROUP_RULE)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICE_CGROUP_RULE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `device_cgroup_rule` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_CGROUP_RULE).toString()));
            }
            for (i = 0; i < jsonArraydeviceCgroupRule.size(); ++i) {
                LinuxDeviceCgroup.validateJsonElement(jsonArraydeviceCgroupRule.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull() && (jsonArraydevices = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES).toString()));
            }
            for (i = 0; i < jsonArraydevices.size(); ++i) {
                LinuxDevice.validateJsonElement(jsonArraydevices.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES_FROM) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES_FROM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEVICES_FROM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `devices_from` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES_FROM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST_DEVICE_LIST) != null && !jsonObj.get(SERIALIZED_NAME_HOST_DEVICE_LIST).isJsonNull() && (jsonArrayhostDeviceList = jsonObj.getAsJsonArray(SERIALIZED_NAME_HOST_DEVICE_LIST)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_HOST_DEVICE_LIST).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `host_device_list` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST_DEVICE_LIST).toString()));
            }
            for (i = 0; i < jsonArrayhostDeviceList.size(); ++i) {
                LinuxDevice.validateJsonElement(jsonArrayhostDeviceList.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_ARCH) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_ARCH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_ARCH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_arch` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_ARCH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_OS) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_OS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_OS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_os` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_OS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_VARIANT) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_VARIANT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_VARIANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_variant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_VARIANT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUME_MODE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUME_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUME_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_volume_mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUME_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).isJsonNull() && (jsonArrayimageVolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGE_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `image_volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayimageVolumes.size(); ++i) {
                ImageVolume.validateJsonElement(jsonArrayimageVolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_INIT_PATH) != null && !jsonObj.get(SERIALIZED_NAME_INIT_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INIT_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `init_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INIT_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPCNS) != null && !jsonObj.get(SERIALIZED_NAME_IPCNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IPCNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonNull() && (jsonArraymounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_MOUNTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNTS).toString()));
            }
            for (i = 0; i < jsonArraymounts.size(); ++i) {
                Mount.validateJsonElement(jsonArraymounts.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).isJsonNull() && (jsonArrayoverlayVolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_OVERLAY_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `overlay_volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayoverlayVolumes.size(); ++i) {
                OverlayVolume.validateJsonElement(jsonArrayoverlayVolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RAW_IMAGE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_RAW_IMAGE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RAW_IMAGE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `raw_image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RAW_IMAGE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOTFS) != null && !jsonObj.get(SERIALIZED_NAME_ROOTFS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ROOTFS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rootfs` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROOTFS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOTFS_MAPPING) != null && !jsonObj.get(SERIALIZED_NAME_ROOTFS_MAPPING).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ROOTFS_MAPPING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rootfs_mapping` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROOTFS_MAPPING).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOTFS_PROPAGATION) != null && !jsonObj.get(SERIALIZED_NAME_ROOTFS_PROPAGATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ROOTFS_PROPAGATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rootfs_propagation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROOTFS_PROPAGATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRETS) != null && !jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonNull() && (jsonArraysecrets = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECRETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `secrets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRETS).toString()));
            }
            for (i = 0; i < jsonArraysecrets.size(); ++i) {
                Secret.validateJsonElement(jsonArraysecrets.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonNull() && (jsonArrayvolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayvolumes.size(); ++i) {
                NamedVolume.validateJsonElement(jsonArrayvolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WORK_DIR) != null && !jsonObj.get(SERIALIZED_NAME_WORK_DIR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WORK_DIR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `work_dir` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WORK_DIR).toString()));
        }
    }

    public static ContainerStorageConfig fromJson(String jsonString) throws IOException {
        return (ContainerStorageConfig)JSON.getGson().fromJson(jsonString, ContainerStorageConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARTIFACT_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_CHROOT_DIRECTORIES);
        openapiFields.add(SERIALIZED_NAME_CREATE_WORKING_DIR);
        openapiFields.add(SERIALIZED_NAME_DEVICE_CGROUP_RULE);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiFields.add(SERIALIZED_NAME_DEVICES_FROM);
        openapiFields.add(SERIALIZED_NAME_HOST_DEVICE_LIST);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_ARCH);
        openapiFields.add(SERIALIZED_NAME_IMAGE_OS);
        openapiFields.add(SERIALIZED_NAME_IMAGE_VARIANT);
        openapiFields.add(SERIALIZED_NAME_IMAGE_VOLUME_MODE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_INIT);
        openapiFields.add(SERIALIZED_NAME_INIT_PATH);
        openapiFields.add(SERIALIZED_NAME_IPCNS);
        openapiFields.add(SERIALIZED_NAME_MOUNTS);
        openapiFields.add(SERIALIZED_NAME_OVERLAY_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_RAW_IMAGE_NAME);
        openapiFields.add(SERIALIZED_NAME_ROOTFS);
        openapiFields.add(SERIALIZED_NAME_ROOTFS_MAPPING);
        openapiFields.add(SERIALIZED_NAME_ROOTFS_OVERLAY);
        openapiFields.add(SERIALIZED_NAME_ROOTFS_PROPAGATION);
        openapiFields.add(SERIALIZED_NAME_SECRETS);
        openapiFields.add(SERIALIZED_NAME_SHM_SIZE);
        openapiFields.add(SERIALIZED_NAME_SHM_SIZE_SYSTEMD);
        openapiFields.add(SERIALIZED_NAME_STORAGE_OPTS);
        openapiFields.add(SERIALIZED_NAME_VOLATILE);
        openapiFields.add(SERIALIZED_NAME_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_FROM);
        openapiFields.add(SERIALIZED_NAME_WORK_DIR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ContainerStorageConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContainerStorageConfig.class));
            return new TypeAdapter<ContainerStorageConfig>(this){

                public void write(JsonWriter out, ContainerStorageConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ContainerStorageConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ContainerStorageConfig.validateJsonElement(jsonElement);
                    return (ContainerStorageConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

