/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.java;

import lombok.Generated;

public class PodmanImage {
    private final String registry;
    private final String name;
    private final String tag;

    private PodmanImage(String registry, String name, String tag) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.registry = registry;
        this.name = name;
        this.tag = tag;
    }

    public static PodmanImage of(String registry, String name, String tag) {
        return new PodmanImage(registry, name, tag);
    }

    public static PodmanImage of(String name, String tag) {
        return PodmanImage.of("docker.io", name, tag);
    }

    public static PodmanImage of(String name) {
        return PodmanImage.of(name, null);
    }

    public String build() {
        StringBuilder image = new StringBuilder();
        if (this.registry != null) {
            image.append(this.registry);
            image.append("/");
        }
        image.append(this.name);
        if (this.tag != null) {
            image.append(":");
            image.append(this.tag);
        }
        return image.toString();
    }

    @Generated
    public String getRegistry() {
        return this.registry;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }
}

