/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;

public class SchemaGenerator {
    public static final String REFERENCE_KEY = "$ref";
    public static final String PROPERTIES_KEY = "properties";
    private final String outputDir;
    private final String schemaRegistry;

    public SchemaGenerator(String outputDir, String schemaRegistry) {
        this.outputDir = outputDir;
        this.schemaRegistry = schemaRegistry;
    }

    public void writeSchemata(Map<String, ModelsMap> objs, Map<String, String> fieldRenames) {
        HashMap models = new HashMap();
        ObjectMapper mapper = new ObjectMapper();
        objs.entrySet().stream().forEach(entry -> {
            try {
                models.put((String)entry.getKey(), mapper.readTree(((ModelMap)((ModelsMap)entry.getValue()).getModels().get(0)).getModel().getModelJson()));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        models.values().forEach(model -> fieldRenames.forEach((oldKey, newKey) -> this.replaceFieldName((String)oldKey, (String)newKey, (JsonNode)model)));
        models.entrySet().stream().forEach(entry -> {
            ModelsMap basedModelsMap = (ModelsMap)objs.get(entry.getKey());
            this.embedReferences((JsonNode)entry.getValue(), models, (String)basedModelsMap.get((Object)"packageName"));
        });
        models.entrySet().stream().filter(entry -> this.isEntity((JsonNode)entry.getValue())).forEach(entry -> {
            Map<String, JsonNode> descriptionOfModel = this.extractDescription((ModelsMap)objs.get(entry.getKey()));
            Optional.ofNullable((JsonNode)entry.getValue()).filter(e -> e instanceof ObjectNode).map(e -> (ObjectNode)e).ifPresent(e -> {
                e.setAll(descriptionOfModel);
                e.setAll(this.schemaGenerics());
            });
            try {
                Path path = Path.of(this.outputDir, "schema/", (String)entry.getKey() + ".json");
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.writeString(path, (CharSequence)((JsonNode)entry.getValue()).toPrettyString(), StandardOpenOption.CREATE);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        });
    }

    private void replaceFieldName(String oldName, String newName, JsonNode json) {
        List<JsonNode> parentsOfOldFieldName = this.searchForParentOfEntity(json, oldName);
        parentsOfOldFieldName.stream().forEach(parent -> {
            ObjectNode baseNode;
            JsonNode oldNode;
            if (parent instanceof ObjectNode && (oldNode = (baseNode = (ObjectNode)parent).get(oldName)) != null) {
                baseNode.set(newName, oldNode);
                baseNode.remove(oldName);
            }
        });
    }

    private String generateSchemaUrl(String packageName, String modelName) {
        return this.schemaRegistry + "/" + packageName + "/" + modelName;
    }

    private void embedReferences(JsonNode model, Map<String, JsonNode> models, String packageName) {
        List<JsonNode> nodesToReplace = this.searchForParentOfEntity(model, REFERENCE_KEY);
        nodesToReplace.forEach(nodeToReplace -> {
            if (nodeToReplace != null && nodeToReplace instanceof ObjectNode) {
                ObjectNode parentNode = (ObjectNode)nodeToReplace;
                String reference = parentNode.get(REFERENCE_KEY).asText();
                String modelNameToInsert = reference.replace("#/components/schemas/", "");
                JsonNode modelToInsert = (JsonNode)models.get(modelNameToInsert);
                if (this.isEntity(modelToInsert)) {
                    parentNode.replace(REFERENCE_KEY, (JsonNode)JsonNodeFactory.instance.textNode(this.generateSchemaUrl(packageName, modelNameToInsert)));
                } else if (this.isEnum(modelToInsert)) {
                    parentNode.remove(REFERENCE_KEY);
                    modelToInsert.fields().forEachRemaining(entry -> parentNode.put((String)entry.getKey(), (JsonNode)entry.getValue()));
                } else {
                    parentNode.put(PROPERTIES_KEY, modelToInsert);
                    parentNode.remove(REFERENCE_KEY);
                }
            }
        });
    }

    private Map<String, JsonNode> schemaGenerics() {
        return Map.of("$schema", JsonNodeFactory.instance.textNode("http://json-schema.org/schema#"), "modelTags", JsonNodeFactory.instance.textNode(""));
    }

    private Map<String, JsonNode> extractDescription(ModelsMap currentEntity) {
        HashMap<String, JsonNode> answer = new HashMap<String, JsonNode>();
        Optional.ofNullable(currentEntity.get((Object)"classname")).filter(a -> a instanceof String).map(a -> (String)a).map(arg_0 -> ((JsonNodeFactory)JsonNodeFactory.instance).textNode(arg_0)).ifPresent(a -> answer.put("title", (JsonNode)a));
        Optional.ofNullable(currentEntity.get((Object)"appVersion")).filter(a -> a instanceof String).map(a -> (String)a).map(arg_0 -> ((JsonNodeFactory)JsonNodeFactory.instance).textNode(arg_0)).ifPresent(a -> answer.put("$schemaVersion", (JsonNode)a));
        answer.put("$id", (JsonNode)JsonNodeFactory.instance.textNode(this.generateSchemaUrl((String)currentEntity.get((Object)"packageName"), (String)currentEntity.get((Object)"classname")) + "/schema.json"));
        return answer;
    }

    private List<JsonNode> searchForParentOfEntity(JsonNode node, String entityName) {
        if (node == null) {
            return List.of();
        }
        if (node.has(entityName)) {
            return List.of(node);
        }
        if (!node.isContainerNode()) {
            return List.of();
        }
        ArrayList<JsonNode> nodesFound = new ArrayList<JsonNode>();
        for (JsonNode child : node) {
            if (!child.isContainerNode()) continue;
            List<JsonNode> childResult = this.searchForParentOfEntity(child, entityName);
            childResult.stream().filter(foundChild -> !foundChild.isMissingNode()).forEach(nodesFound::add);
        }
        return nodesFound;
    }

    public boolean isEntity(JsonNode model) {
        return Optional.ofNullable(model).filter(m -> m.has(PROPERTIES_KEY)).map(m -> m.get(PROPERTIES_KEY)).filter(m -> m.has("id")).isPresent();
    }

    private boolean isEnum(JsonNode model) {
        return Optional.ofNullable(model).filter(m -> m.has("enum")).isPresent();
    }
}

