/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Move;
import engine.PseudoMoves;
import engine.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class Board {
    public static final String startingFen = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1";
    private String boardStartingFen;
    private final char[] squares = new char[64];
    private char sideToMove;
    private boolean whiteKingCastle;
    private boolean whiteQueenCastle;
    private boolean blackKingCastle;
    private boolean blackQueenCastle;
    private int enPassantTargetSquare;
    private int initialEnPassantSquare;
    private boolean[] initialCastlingRights;
    public Stack<Move> moveStack = new Stack();

    public String getBoardStartingFen() {
        return this.boardStartingFen;
    }

    public void setBoardStartingFen(String boardStartingFen) {
        this.boardStartingFen = boardStartingFen;
    }

    public char[] getSquares() {
        return this.squares;
    }

    public char getSideToMove() {
        return this.sideToMove;
    }

    public void setSideToMove(char sideToMove) {
        this.sideToMove = sideToMove;
    }

    public boolean isWhiteKingCastle() {
        return this.whiteKingCastle;
    }

    public void setWhiteKingCastle(boolean whiteKingCastle) {
        this.whiteKingCastle = whiteKingCastle;
    }

    public boolean isWhiteQueenCastle() {
        return this.whiteQueenCastle;
    }

    public void setWhiteQueenCastle(boolean whiteQueenCastle) {
        this.whiteQueenCastle = whiteQueenCastle;
    }

    public boolean isBlackKingCastle() {
        return this.blackKingCastle;
    }

    public void setBlackKingCastle(boolean blackKingCastle) {
        this.blackKingCastle = blackKingCastle;
    }

    public boolean isBlackQueenCastle() {
        return this.blackQueenCastle;
    }

    public void setBlackQueenCastle(boolean blackQueenCastle) {
        this.blackQueenCastle = blackQueenCastle;
    }

    public int getEnPassantTargetSquare() {
        return this.enPassantTargetSquare;
    }

    public void setEnPassantTargetSquare(int enPassantTargetSquare) {
        this.enPassantTargetSquare = enPassantTargetSquare;
    }

    public Board(String fen) {
        this.boardStartingFen = fen;
        this.createGameBoard(fen);
    }

    public Board() {
        this.boardStartingFen = startingFen;
        this.createGameBoard(startingFen);
    }

    private void createGameBoard(String fen) {
        String[] fenParts = fen.split(" ");
        this.populateBoard(fenParts[0]);
        this.sideToMove = fenParts[1].charAt(0);
        this.setCastlingRights(fenParts[2]);
        this.setEnpassantTargetSquare(fenParts[3]);
        this.initialEnPassantSquare = this.enPassantTargetSquare;
        this.initialCastlingRights = new boolean[]{this.whiteKingCastle, this.whiteQueenCastle, this.blackKingCastle, this.blackQueenCastle};
    }

    public String convertBoardToFEN() {
        StringBuilder boardFen = new StringBuilder();
        int emptySquareCount = 0;
        for (int i = 0; i < this.squares.length; ++i) {
            if (i % 8 == 0 && i != 0) {
                if (emptySquareCount != 0) {
                    boardFen.append(emptySquareCount);
                }
                boardFen.append("/");
                emptySquareCount = 0;
            }
            if (this.squares[i] != '\u0000') {
                if (emptySquareCount != 0) {
                    boardFen.append(emptySquareCount);
                }
                emptySquareCount = 0;
                boardFen.append(this.squares[i]);
                continue;
            }
            ++emptySquareCount;
        }
        boardFen.append(" ").append(this.sideToMove);
        Object castlingRights = "";
        if (this.whiteKingCastle) {
            castlingRights = (String)castlingRights + "K";
        }
        if (this.whiteQueenCastle) {
            castlingRights = (String)castlingRights + "Q";
        }
        if (this.blackKingCastle) {
            castlingRights = (String)castlingRights + "k";
        }
        if (this.blackQueenCastle) {
            castlingRights = (String)castlingRights + "q";
        }
        if (((String)castlingRights).equals("")) {
            castlingRights = "-";
        }
        boardFen.append(" ").append((String)castlingRights);
        if (this.enPassantTargetSquare == -1) {
            boardFen.append(" -");
        } else {
            String enPassantSquare = Util.convertBoardIndexToSquare(this.enPassantTargetSquare);
            boardFen.append(" ").append(enPassantSquare);
        }
        boardFen.append(" 0 1");
        return boardFen.toString();
    }

    public String toString() {
        return "engine.Board{boardStartingFen='" + this.boardStartingFen + "', squares=" + Arrays.toString(this.squares) + ", sideToMove=" + this.sideToMove + ", whiteKingCastle=" + this.whiteKingCastle + ", whiteQueenCastle=" + this.whiteQueenCastle + ", blackKingCastle=" + this.blackKingCastle + ", blackQueenCastle=" + this.blackQueenCastle + ", enPassantTargetSquare=" + this.enPassantTargetSquare + "}";
    }

    private void setEnpassantTargetSquare(String targetSquare) {
        this.enPassantTargetSquare = targetSquare.equals("-") ? -1 : Util.convertSquarePosToBoardIndex(targetSquare);
    }

    public void setCastlingRights(String castlingRights) {
        if (castlingRights.equals("-")) {
            this.whiteKingCastle = false;
            this.whiteQueenCastle = false;
            this.blackKingCastle = false;
            this.blackQueenCastle = false;
        } else {
            block6: for (int i = 0; i < castlingRights.length(); ++i) {
                char currentChar = castlingRights.charAt(i);
                switch (currentChar) {
                    case 'K': {
                        this.whiteKingCastle = true;
                        continue block6;
                    }
                    case 'Q': {
                        this.whiteQueenCastle = true;
                        continue block6;
                    }
                    case 'k': {
                        this.blackKingCastle = true;
                        continue block6;
                    }
                    case 'q': {
                        this.blackQueenCastle = true;
                        continue block6;
                    }
                }
            }
        }
    }

    private void populateBoard(String pieces) {
        int boardIndex = 0;
        for (int i = 0; i < pieces.length(); ++i) {
            char currentChar = pieces.charAt(i);
            if (Character.isDigit(currentChar)) {
                boardIndex += currentChar - 48;
                continue;
            }
            if (currentChar == '/') continue;
            this.squares[boardIndex] = currentChar;
            ++boardIndex;
        }
    }

    public void prettyPrintBoard() {
        StringBuilder board = new StringBuilder();
        for (int i = 0; i < this.squares.length; ++i) {
            if (i % 8 == 0) {
                board.append("\n");
                board.append(9 - (i / 8 + 1));
                board.append(" | ");
            }
            if (this.squares[i] == '\u0000') {
                board.append(" ");
            } else {
                board.append(this.squares[i]);
            }
            board.append(" | ");
        }
        board.append("\n    a   b   c   d   e   f   g   h  ");
        System.out.println(board);
    }

    public boolean isCurrentPlayerInCheck() {
        List<Move> opponentPseudoLegalMoves = PseudoMoves.opponentPseudoLegalMoves(this);
        char kingChar = this.sideToMove == 'w' ? (char)'K' : 'k';
        List<Integer> kingPos = PseudoMoves.findPieceSquares(this, kingChar);
        boolean inCheck = false;
        for (Move opMove : opponentPseudoLegalMoves) {
            if (opMove.getEndSquare() != kingPos.get(0).intValue()) continue;
            inCheck = true;
        }
        return inCheck;
    }

    public boolean doMove(Move move) {
        int dir;
        int startSquare = move.getStartSquare();
        int endSquare = move.getEndSquare();
        int n = dir = this.sideToMove == 'w' ? 1 : -1;
        if (move.isEnPassant()) {
            this.squares[endSquare] = this.squares[startSquare];
            this.squares[startSquare] = '\u0000';
            this.squares[endSquare + dir * 8] = '\u0000';
        } else if (move.isQueenCastle()) {
            this.squares[endSquare] = this.squares[startSquare];
            this.squares[startSquare] = '\u0000';
            this.squares[startSquare - 1] = this.squares[startSquare - 4];
            this.squares[startSquare - 4] = '\u0000';
        } else if (move.isKingCastle()) {
            this.squares[endSquare] = this.squares[startSquare];
            this.squares[startSquare] = '\u0000';
            this.squares[startSquare + 1] = this.squares[startSquare + 3];
            this.squares[startSquare + 3] = '\u0000';
        } else {
            this.squares[endSquare] = this.squares[startSquare];
            this.squares[startSquare] = '\u0000';
        }
        if (move.isDoublePawnMove()) {
            this.enPassantTargetSquare = startSquare - dir * 8;
            move.setEnPassantTargetSquare(this.enPassantTargetSquare);
        } else {
            this.enPassantTargetSquare = -1;
            move.setEnPassantTargetSquare(this.enPassantTargetSquare);
        }
        boolean[] castlingRights = new boolean[]{this.whiteKingCastle, this.whiteQueenCastle, this.blackKingCastle, this.blackQueenCastle};
        if (move.getPiece() == 'K') {
            castlingRights[0] = false;
            castlingRights[1] = false;
            move.setCastlingRights(castlingRights);
        } else if (move.getPiece() == 'k') {
            castlingRights[2] = false;
            castlingRights[3] = false;
        } else if (move.getPiece() == 'R') {
            if (startSquare == 63) {
                castlingRights[0] = false;
            } else if (startSquare == 56) {
                castlingRights[1] = false;
            }
        } else if (move.getPiece() == 'r') {
            if (startSquare == 7) {
                castlingRights[2] = false;
            } else if (startSquare == 0) {
                castlingRights[3] = false;
            }
        }
        if (move.getCapturedPiece() == 'r') {
            if (move.getEndSquare() == 7) {
                castlingRights[2] = false;
            } else if (move.getEndSquare() == 0) {
                castlingRights[3] = false;
            }
        } else if (move.getCapturedPiece() == 'R') {
            if (move.getEndSquare() == 63) {
                castlingRights[0] = false;
            } else if (move.getEndSquare() == 56) {
                castlingRights[1] = false;
            }
        }
        move.setCastlingRights(castlingRights);
        this.whiteKingCastle = castlingRights[0];
        this.whiteQueenCastle = castlingRights[1];
        this.blackKingCastle = castlingRights[2];
        this.blackQueenCastle = castlingRights[3];
        this.moveStack.push(move);
        this.sideToMove = (char)(this.sideToMove == 'w' ? 98 : 119);
        return false;
    }

    public boolean doLegalMove(int[] move) {
        List<Move> legalMoves = this.boardLegalMoves();
        for (Move legalMove : legalMoves) {
            if (!legalMove.equals(move)) continue;
            this.doMove(legalMove);
            if (legalMove.getPiece() == 'P' && legalMove.getEndSquare() < 8 && legalMove.getEndSquare() > -1) {
                this.squares[legalMove.getEndSquare()] = 81;
            } else if (legalMove.getPiece() == 'p' && legalMove.getEndSquare() < 64 && legalMove.getEndSquare() > 55) {
                this.squares[legalMove.getEndSquare()] = 113;
            }
            return true;
        }
        return false;
    }

    public boolean undoMove(Move move) {
        if (move.isEnPassant()) {
            int dir = this.sideToMove == 'w' ? 1 : -1;
            this.squares[move.getStartSquare()] = move.getPiece();
            this.squares[move.getEndSquare()] = '\u0000';
            this.squares[move.getEndSquare() - dir * 8] = move.getCapturedPiece();
        } else if (move.isKingCastle()) {
            this.squares[move.getStartSquare()] = move.getPiece();
            this.squares[move.getEndSquare()] = '\u0000';
            this.squares[move.getStartSquare() + 3] = this.squares[move.getStartSquare() + 1];
            this.squares[move.getStartSquare() + 1] = '\u0000';
        } else if (move.isQueenCastle()) {
            this.squares[move.getStartSquare()] = move.getPiece();
            this.squares[move.getEndSquare()] = '\u0000';
            this.squares[move.getStartSquare() - 4] = this.squares[move.getStartSquare() - 1];
            this.squares[move.getStartSquare() - 1] = '\u0000';
        } else {
            this.squares[move.getEndSquare()] = move.getCapturedPiece();
            this.squares[move.getStartSquare()] = move.getPiece();
        }
        this.moveStack.pop();
        if (this.moveStack.size() != 0) {
            this.enPassantTargetSquare = this.moveStack.peek().getEnPassantTargetSquare();
            this.whiteKingCastle = this.moveStack.peek().getCastlingRights()[0];
            this.whiteQueenCastle = this.moveStack.peek().getCastlingRights()[1];
            this.blackKingCastle = this.moveStack.peek().getCastlingRights()[2];
            this.blackQueenCastle = this.moveStack.peek().getCastlingRights()[3];
        } else {
            this.enPassantTargetSquare = this.initialEnPassantSquare;
            this.whiteKingCastle = this.initialCastlingRights[0];
            this.whiteQueenCastle = this.initialCastlingRights[1];
            this.blackQueenCastle = this.initialCastlingRights[2];
            this.blackKingCastle = this.initialCastlingRights[3];
        }
        this.sideToMove = (char)(this.sideToMove == 'w' ? 98 : 119);
        return false;
    }

    public void undoLastMove() {
        if (this.moveStack.size() != 0) {
            this.undoMove(this.moveStack.peek());
        }
    }

    public List<Move> boardLegalMoves() {
        List<Move> allPseudoLegalMoves = PseudoMoves.allPseudoLegalMoves(this);
        ArrayList<Move> legalMoves = new ArrayList<Move>(PseudoMoves.castlingPseudoLegalMoves(this));
        for (Move move : allPseudoLegalMoves) {
            this.doMove(move);
            this.sideToMove = (char)(this.sideToMove == 'w' ? 98 : 119);
            if (!this.isCurrentPlayerInCheck()) {
                legalMoves.add(move);
            }
            this.sideToMove = (char)(this.sideToMove == 'w' ? 98 : 119);
            this.undoMove(move);
        }
        return legalMoves;
    }

    public boolean checkMate() {
        return this.boardLegalMoves().size() == 0;
    }

    public List<String> convertGameToFenList() {
        ArrayList<String> allPositions = new ArrayList<String>();
        Board board = new Board(this.getBoardStartingFen());
        allPositions.add(this.getBoardStartingFen());
        for (int i = 0; i < this.moveStack.size(); ++i) {
            board.doMove((Move)this.moveStack.get(i));
            allPositions.add(board.convertBoardToFEN());
        }
        return allPositions;
    }
}

