/*
 * Decompiled with CFR 0.152.
 */
package engine;

public class Move {
    private int startSquare;
    private int endSquare;
    private char piece;
    private char capturedPiece;
    private boolean isEnPassant;
    private int enPassantTargetSquare;
    private boolean isDoublePawnMove;
    private boolean isKingCastle;
    private boolean isQueenCastle;
    private boolean[] castlingRights;

    public boolean isDoublePawnMove() {
        return this.isDoublePawnMove;
    }

    public boolean isKingCastle() {
        return this.isKingCastle;
    }

    public void setKingCastle(boolean kingCastle) {
        this.isKingCastle = kingCastle;
    }

    public boolean isQueenCastle() {
        return this.isQueenCastle;
    }

    public void setQueenCastle(boolean queenCastle) {
        this.isQueenCastle = queenCastle;
    }

    public void setDoublePawnMove(boolean doublePawnMove) {
        this.isDoublePawnMove = doublePawnMove;
    }

    public boolean[] getCastlingRights() {
        return this.castlingRights;
    }

    public void setCastlingRights(boolean[] castlingRights) {
        this.castlingRights = castlingRights;
    }

    public Move(int startSquare, int endSquare, char piece, char capturedPiece, boolean isEnPassant, int enPassantTargetSquare, boolean isDoublePawnMove, boolean isKingCastle, boolean isQueenCastle) {
        this.startSquare = startSquare;
        this.endSquare = endSquare;
        this.piece = piece;
        this.capturedPiece = capturedPiece;
        this.isEnPassant = isEnPassant;
        this.enPassantTargetSquare = enPassantTargetSquare;
        this.isDoublePawnMove = isDoublePawnMove;
        this.isKingCastle = isKingCastle;
        this.isQueenCastle = isQueenCastle;
        this.castlingRights = new boolean[4];
    }

    public int getEnPassantTargetSquare() {
        return this.enPassantTargetSquare;
    }

    public void setEnPassantTargetSquare(int enPassantTargetSquare) {
        this.enPassantTargetSquare = enPassantTargetSquare;
    }

    public boolean equals(Object obj) {
        if (obj instanceof int[]) {
            int[] move = (int[])obj;
            return move[0] == this.startSquare && move[1] == this.endSquare;
        }
        Move move = (Move)obj;
        return this.startSquare == move.getStartSquare() && this.endSquare == move.getEndSquare() && this.piece == move.getPiece() && this.capturedPiece == move.getCapturedPiece() && this.isEnPassant == move.isEnPassant() && this.enPassantTargetSquare == move.enPassantTargetSquare && this.isDoublePawnMove == move.isDoublePawnMove && this.isKingCastle == move.isKingCastle && this.isQueenCastle == move.isQueenCastle;
    }

    public String toString() {
        return "engine.Move{startSquare=" + this.startSquare + ", endSquare=" + this.endSquare + ", piece=" + this.piece + ", capturedPiece=" + this.capturedPiece + ", isEnPassant=" + this.isEnPassant + ", enPassantTargetSquare=" + this.enPassantTargetSquare + ", isDoublePawnMove=" + this.isDoublePawnMove + ", isKingCastle=" + this.isKingCastle + ", isQueenCastle=" + this.isQueenCastle;
    }

    public int getStartSquare() {
        return this.startSquare;
    }

    public void setStartSquare(int startSquare) {
        this.startSquare = startSquare;
    }

    public int getEndSquare() {
        return this.endSquare;
    }

    public void setEndSquare(int endSquare) {
        this.endSquare = endSquare;
    }

    public char getPiece() {
        return this.piece;
    }

    public void setPiece(char piece) {
        this.piece = piece;
    }

    public char getCapturedPiece() {
        return this.capturedPiece;
    }

    public void setCapturedPiece(char capturedPiece) {
        this.capturedPiece = capturedPiece;
    }

    public boolean isEnPassant() {
        return this.isEnPassant;
    }

    public void setEnPassant(boolean enPassant) {
        this.isEnPassant = enPassant;
    }
}

