/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Board;
import engine.Move;
import engine.Util;
import java.util.ArrayList;
import java.util.List;

public class PseudoMoves {
    static final int[] KNIGHT_MOVE_VALUES = new int[]{6, -6, 10, -10, 15, -15, 17, -17};
    static final int[] KNIGHT_MOVE_VALUES_A_FILE = new int[]{-6, 10, -15, 17};
    static final int[] KNIGHT_MOVE_VALUES_B_FILE = new int[]{-6, 10, 15, -15, 17, -17};
    static final int[] KNIGHT_MOVE_VALUES_H_FILE = new int[]{6, -10, 15, -17};
    static final int[] KNIGHT_MOVE_VALUES_G_FILE = new int[]{6, -10, 15, -15, 17, -17};
    static final int[] SLIDING_MOVE_VALUE = new int[]{1, -1, 8, -8, 7, 9, -7, -9};

    public static List<Move> knightPseudoLegalMoves(Board board) {
        ArrayList<Move> allKnightPseudoLegalMoves = new ArrayList<Move>();
        char colourToCalculate = board.getSideToMove();
        char knightChar = colourToCalculate == 'w' ? (char)'N' : 'n';
        List<Integer> knightSquares = PseudoMoves.findPieceSquares(board, knightChar);
        for (Integer knightSquare : knightSquares) {
            int[] knightMoveOptions = Util.isOnAFile(knightSquare) ? KNIGHT_MOVE_VALUES_A_FILE : (Util.isOnBFile(knightSquare) ? KNIGHT_MOVE_VALUES_B_FILE : (Util.isOnGFile(knightSquare) ? KNIGHT_MOVE_VALUES_G_FILE : (Util.isOnHFile(knightSquare) ? KNIGHT_MOVE_VALUES_H_FILE : KNIGHT_MOVE_VALUES)));
            for (int moveOption : knightMoveOptions) {
                int endSquare = knightSquare + moveOption;
                if (endSquare >= 64 || endSquare <= -1 || !PseudoMoves.checkEndSquareColour(board.getSquares(), colourToCalculate, endSquare)) continue;
                Move move = new Move(knightSquare, endSquare, knightChar, board.getSquares()[endSquare], false, board.getEnPassantTargetSquare(), false, false, false);
                allKnightPseudoLegalMoves.add(move);
            }
        }
        return allKnightPseudoLegalMoves;
    }

    public static List<Move> allSlidingPiecePseudoLegalMoves(Board board) {
        char[] cArray;
        char colour = board.getSideToMove();
        if (colour == 'w') {
            char[] cArray2 = new char[3];
            cArray2[0] = 82;
            cArray2[1] = 66;
            cArray = cArray2;
            cArray2[2] = 81;
        } else {
            char[] cArray3 = new char[3];
            cArray3[0] = 114;
            cArray3[1] = 98;
            cArray = cArray3;
            cArray3[2] = 113;
        }
        char[] pieceOptions = cArray;
        ArrayList<Move> allSlidingPiecePseudoLegalMoves = new ArrayList<Move>();
        for (int pieceIndex = 0; pieceIndex < board.getSquares().length; ++pieceIndex) {
            if (board.getSquares()[pieceIndex] != pieceOptions[0] && board.getSquares()[pieceIndex] != pieceOptions[1] && board.getSquares()[pieceIndex] != pieceOptions[2]) continue;
            char piece = board.getSquares()[pieceIndex];
            allSlidingPiecePseudoLegalMoves.addAll(PseudoMoves.slidingPiecePseudoLegalMoves(board, piece, colour));
        }
        return allSlidingPiecePseudoLegalMoves;
    }

    public static List<Move> slidingPiecePseudoLegalMoves(Board board, char piece, char colour) {
        int moveValuesEndIndex = switch (piece) {
            case 'R', 'r' -> {
                int moveValuesStartIndex = 0;
                yield 3;
            }
            case 'B', 'b' -> {
                int moveValuesStartIndex = 4;
                yield 7;
            }
            default -> {
                int moveValuesStartIndex = 0;
                yield 7;
            }
        };
        ArrayList<Move> slidingPiecePseudoLegalMoves = new ArrayList<Move>();
        List<Integer> pieceSquares = PseudoMoves.findPieceSquares(board, piece);
        for (int pieceSquare : pieceSquares) {
            block5: for (int i = moveValuesStartIndex; i <= moveValuesEndIndex; ++i) {
                int endSquare;
                int moveOption = SLIDING_MOVE_VALUE[i];
                int previousSquare = pieceSquare;
                for (int moveOptionMultiplier = 1; moveOptionMultiplier <= 8 && (endSquare = pieceSquare + moveOption * moveOptionMultiplier) < 64 && endSquare > -1 && PseudoMoves.moveBoardWrap(previousSquare, endSquare); ++moveOptionMultiplier) {
                    if (PseudoMoves.checkEndSquareColour(board.getSquares(), colour, endSquare)) {
                        Move move = new Move(pieceSquare, endSquare, board.getSquares()[pieceSquare], board.getSquares()[endSquare], false, board.getEnPassantTargetSquare(), false, false, false);
                        slidingPiecePseudoLegalMoves.add(move);
                    }
                    if (board.getSquares()[endSquare] != '\u0000') continue block5;
                    previousSquare = endSquare;
                }
            }
        }
        return slidingPiecePseudoLegalMoves;
    }

    public static List<Move> pawnPseudoLegalMoves(Board board) {
        char pawnChar = board.getSideToMove() == 'w' ? (char)'P' : 'p';
        int dir = board.getSideToMove() == 'w' ? -1 : 1;
        ArrayList<Move> pawnPseudoLegalMoves = new ArrayList<Move>();
        List<Integer> pawnSquares = PseudoMoves.findPieceSquares(board, pawnChar);
        for (Integer pieceSquare : pawnSquares) {
            ArrayList<Integer> pieceMoveOptions = new ArrayList<Integer>();
            if (board.getSideToMove() == 'w') {
                if (pieceSquare < 56 && pieceSquare > 47 && board.getSquares()[pieceSquare - 16] == '\u0000') {
                    pieceMoveOptions.add(-16);
                }
                PseudoMoves.generatePawnMoves(board, pieceSquare, pieceMoveOptions, dir);
            } else {
                if (pieceSquare < 16 && pieceSquare > 7 && board.getSquares()[pieceSquare + 16] == '\u0000') {
                    pieceMoveOptions.add(16);
                }
                PseudoMoves.generatePawnMoves(board, pieceSquare, pieceMoveOptions, dir);
            }
            for (Integer moveOption : pieceMoveOptions) {
                char capturedPiece;
                int endSquare = pieceSquare + moveOption;
                if (endSquare <= -1 || endSquare >= 64 || !PseudoMoves.moveBoardWrap(pieceSquare, endSquare)) continue;
                boolean isEnPassant = false;
                if (endSquare == board.getEnPassantTargetSquare()) {
                    isEnPassant = true;
                    capturedPiece = board.getSquares()[endSquare - dir * 8];
                } else {
                    capturedPiece = board.getSquares()[endSquare];
                }
                boolean isDoublePawnMove = false;
                if (moveOption == 16 || moveOption == -16) {
                    isDoublePawnMove = true;
                }
                Move move = new Move(pieceSquare, endSquare, pawnChar, capturedPiece, isEnPassant, board.getEnPassantTargetSquare(), isDoublePawnMove, false, false);
                pawnPseudoLegalMoves.add(move);
            }
        }
        return pawnPseudoLegalMoves;
    }

    private static void generatePawnMoves(Board board, int pieceSquare, List<Integer> pieceMoveOptions, int dir) {
        if (board.getSquares()[pieceSquare + dir * 8] == '\u0000') {
            pieceMoveOptions.add(dir * 8);
        }
        if (PseudoMoves.checkPawnDiagonal(board, pieceSquare, dir * 7)) {
            pieceMoveOptions.add(dir * 7);
        }
        if (PseudoMoves.checkPawnDiagonal(board, pieceSquare, dir * 9)) {
            pieceMoveOptions.add(dir * 9);
        }
    }

    public static boolean checkPawnDiagonal(Board board, int pieceSquare, int moveOption) {
        if (pieceSquare + moveOption == board.getEnPassantTargetSquare()) {
            return true;
        }
        return board.getSquares()[pieceSquare + moveOption] != '\u0000' && PseudoMoves.checkEndSquareColour(board.getSquares(), board.getSideToMove(), pieceSquare + moveOption);
    }

    public static List<Move> kingPseudoLegalMoves(Board board) {
        char kingChar = board.getSideToMove() == 'w' ? (char)'K' : 'k';
        List<Integer> kingSquare = PseudoMoves.findPieceSquares(board, kingChar);
        ArrayList<Move> kingPseudoLegalMoves = new ArrayList<Move>();
        for (Integer square : kingSquare) {
            for (int moveOption : SLIDING_MOVE_VALUE) {
                int endSquare = square + moveOption;
                if (endSquare >= 64 || endSquare <= -1 || !PseudoMoves.moveBoardWrap(square, endSquare) || !PseudoMoves.checkEndSquareColour(board.getSquares(), board.getSideToMove(), endSquare)) continue;
                Move move = new Move(square, endSquare, kingChar, board.getSquares()[endSquare], false, board.getEnPassantTargetSquare(), false, false, false);
                kingPseudoLegalMoves.add(move);
            }
        }
        return kingPseudoLegalMoves;
    }

    public static List<Move> castlingPseudoLegalMoves(Board board) {
        int blackKing = 4;
        int whiteKing = 60;
        ArrayList<Move> castleMoves = new ArrayList<Move>();
        List<Move> opponentPseudoLegalMoves = PseudoMoves.opponentPseudoLegalMoves(board);
        List<Integer> enemyAttackSquares = opponentPseudoLegalMoves.stream().map(Move::getEndSquare).toList();
        if (board.getSideToMove() == 'w') {
            Move move;
            if (enemyAttackSquares.contains(60)) {
                return castleMoves;
            }
            if (board.isWhiteKingCastle() && !enemyAttackSquares.contains(61) && !enemyAttackSquares.contains(62) && (move = PseudoMoves.createCastleMove(60, board, true)) != null) {
                castleMoves.add(move);
            }
            if (board.isWhiteQueenCastle() && !enemyAttackSquares.contains(59) && !enemyAttackSquares.contains(58) && (move = PseudoMoves.createCastleMove(60, board, false)) != null) {
                castleMoves.add(move);
            }
        } else {
            Move move;
            if (enemyAttackSquares.contains(4)) {
                return castleMoves;
            }
            if (board.isBlackKingCastle() && !enemyAttackSquares.contains(5) && !enemyAttackSquares.contains(6) && (move = PseudoMoves.createCastleMove(4, board, true)) != null) {
                castleMoves.add(move);
            }
            if (board.isBlackQueenCastle() && !enemyAttackSquares.contains(3) && !enemyAttackSquares.contains(2) && (move = PseudoMoves.createCastleMove(4, board, false)) != null) {
                castleMoves.add(move);
            }
        }
        return castleMoves;
    }

    public static Move createCastleMove(int kingPiece, Board board, boolean isKingSide) {
        char kingChar = board.getSquares()[kingPiece];
        if (isKingSide) {
            if (board.getSquares()[kingPiece + 1] == '\u0000' && board.getSquares()[kingPiece + 2] == '\u0000') {
                Move move = new Move(kingPiece, kingPiece + 2, kingChar, board.getSquares()[kingPiece + 2], false, board.getEnPassantTargetSquare(), false, true, false);
                return move;
            }
            return null;
        }
        if (board.getSquares()[kingPiece - 1] == '\u0000' && board.getSquares()[kingPiece - 2] == '\u0000' && board.getSquares()[kingPiece - 3] == '\u0000') {
            Move move = new Move(kingPiece, kingPiece - 2, kingChar, board.getSquares()[kingPiece - 2], false, board.getEnPassantTargetSquare(), false, false, true);
            return move;
        }
        return null;
    }

    public static List<Move> opponentPseudoLegalMoves(Board board) {
        char playerChar = board.getSideToMove();
        char opponentChar = board.getSideToMove() == 'w' ? (char)'b' : 'w';
        board.setSideToMove(opponentChar);
        List<Move> opponentPseudoLegalMoves = PseudoMoves.allPseudoLegalMoves(board);
        board.setSideToMove(playerChar);
        return opponentPseudoLegalMoves;
    }

    public static List<Move> allPseudoLegalMoves(Board board) {
        ArrayList<Move> pseudoLegalMoves = new ArrayList<Move>();
        pseudoLegalMoves.addAll(PseudoMoves.allSlidingPiecePseudoLegalMoves(board));
        pseudoLegalMoves.addAll(PseudoMoves.pawnPseudoLegalMoves(board));
        pseudoLegalMoves.addAll(PseudoMoves.knightPseudoLegalMoves(board));
        pseudoLegalMoves.addAll(PseudoMoves.kingPseudoLegalMoves(board));
        return pseudoLegalMoves;
    }

    public static List<Integer> findPieceSquares(Board board, char piece) {
        ArrayList<Integer> pieceSquares = new ArrayList<Integer>();
        for (int i = 0; i < board.getSquares().length; ++i) {
            if (board.getSquares()[i] != piece) continue;
            pieceSquares.add(i);
        }
        return pieceSquares;
    }

    public static boolean moveBoardWrap(int startSquare, int endSquare) {
        if (Util.isOnAFile(startSquare) && Util.isOnHFile(endSquare)) {
            return false;
        }
        return !Util.isOnHFile(startSquare) || !Util.isOnAFile(endSquare);
    }

    public static boolean checkEndSquareColour(char[] squares, char colour, int squareIndex) {
        if (colour == 'w') {
            return !Character.isUpperCase(squares[squareIndex]) || squares[squareIndex] == '\u0000';
        }
        return !Character.isLowerCase(squares[squareIndex]) || squares[squareIndex] == '\u0000';
    }
}

