/*
 * Decompiled with CFR 0.152.
 */
package engine;

public class Util {
    private static final int[] hFile = new int[]{7, 15, 23, 31, 39, 47, 55, 63};
    private static final int[] gFile = new int[]{6, 14, 22, 30, 38, 46, 54, 62};
    private static final int[] aFile = new int[]{0, 8, 16, 24, 32, 40, 48, 56};
    private static final int[] bFile = new int[]{1, 9, 17, 25, 33, 41, 49, 57};

    public static int convertSquarePosToBoardIndex(String square) {
        int file;
        if (square.length() != 2) {
            return -1;
        }
        char fileChar = square.charAt(0);
        char rankChar = square.charAt(1);
        int rank = 8 - (rankChar - 48);
        int result = rank * 8 + (file = fileChar - 97);
        if (result > 63 || result < 0) {
            return -1;
        }
        return result;
    }

    public static int[] convertMoveToBoardIndex(String move) {
        move.substring(0, 1);
        int start = Util.convertSquarePosToBoardIndex(move.substring(0, 2));
        int end = Util.convertSquarePosToBoardIndex(move.substring(2, 4));
        if (start == -1 || end == -1) {
            return new int[0];
        }
        return new int[]{start, end};
    }

    public static String convertBoardIndexToSquare(int index) {
        int rank = 8 - index / 8;
        int file = index % 8;
        char fileChar = (char)(97 + file);
        return String.valueOf(fileChar) + rank;
    }

    public static boolean isOnHFile(int boardIndex) {
        return Util.arrayContains(hFile, boardIndex);
    }

    public static boolean isOnGFile(int boardIndex) {
        return Util.arrayContains(gFile, boardIndex);
    }

    public static boolean isOnAFile(int boardIndex) {
        return Util.arrayContains(aFile, boardIndex);
    }

    public static boolean isOnBFile(int boardIndex) {
        return Util.arrayContains(bFile, boardIndex);
    }

    public static boolean arrayContains(int[] arr, int value) {
        for (int num : arr) {
            if (num != value) continue;
            return true;
        }
        return false;
    }
}

