/*
 * Decompiled with CFR 0.152.
 */
package gui;

import engine.Board;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ChessGUI {
    private final JPanel gui = new JPanel(new BorderLayout(3, 3));
    private JButton[][] chessBoardSquares = new JButton[8][8];
    private Image[][] chessPieceImages = new Image[2][6];
    private JPanel chessBoard;
    private final JLabel message = new JLabel("Chess Champ is ready to play!");
    private static final String COLS = "ABCDEFGH";
    public static final int KING = 0;
    public static final int QUEEN = 1;
    public static final int ROOK = 2;
    public static final int KNIGHT = 3;
    public static final int BISHOP = 4;
    public static final int PAWN = 5;
    public static final int[] STARTING_ROW = new int[]{2, 3, 4, 1, 0, 4, 3, 2};
    public static final int BLACK = 0;
    public static final int WHITE = 1;
    private int startSquare = -1;
    private int endSquare = -1;
    private Board board;

    ChessGUI() {
        this.initializeGui();
    }

    public final void initializeGui() {
        int jj;
        int ii;
        this.createImages();
        this.gui.setBorder(new EmptyBorder(5, 5, 5, 5));
        JToolBar tools = new JToolBar();
        tools.setFloatable(false);
        this.gui.add((Component)tools, "First");
        AbstractAction newGameAction = new AbstractAction("New"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChessGUI.this.setupNewGame();
            }
        };
        tools.add(newGameAction);
        tools.add(new JButton("Save"));
        tools.add(new JButton("Restore"));
        tools.addSeparator();
        tools.add(new JButton("Resign"));
        tools.addSeparator();
        tools.add(this.message);
        this.gui.add((Component)new JLabel("?"), "Before");
        this.chessBoard = new JPanel(new GridLayout(0, 9)){

            @Override
            public final Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                Dimension prefSize = null;
                Container c = this.getParent();
                prefSize = c == null ? new Dimension((int)d.getWidth(), (int)d.getHeight()) : (c != null && (double)c.getWidth() > d.getWidth() && (double)c.getHeight() > d.getHeight() ? c.getSize() : d);
                int w = (int)prefSize.getWidth();
                int h = (int)prefSize.getHeight();
                int s = w > h ? h : w;
                return new Dimension(s, s);
            }
        };
        this.chessBoard.setBorder(new CompoundBorder(new EmptyBorder(8, 8, 8, 8), new LineBorder(Color.BLACK)));
        Color ochre = new Color(204, 119, 34);
        this.chessBoard.setBackground(ochre);
        JPanel boardConstrain = new JPanel(new GridBagLayout());
        boardConstrain.setBackground(ochre);
        boardConstrain.add(this.chessBoard);
        this.gui.add(boardConstrain);
        Insets buttonMargin = new Insets(0, 0, 0, 0);
        for (ii = 0; ii < this.chessBoardSquares.length; ++ii) {
            for (jj = 0; jj < this.chessBoardSquares[ii].length; ++jj) {
                final JButton b = new JButton();
                b.setMargin(buttonMargin);
                ImageIcon icon = new ImageIcon(new BufferedImage(64, 64, 2));
                b.setIcon(icon);
                if (jj % 2 == 1 && ii % 2 == 1 || jj % 2 == 0 && ii % 2 == 0) {
                    b.setBackground(Color.WHITE);
                } else {
                    b.setBackground(Color.BLACK);
                }
                int index = ii * 8 + jj;
                b.setName(Integer.toString(index));
                this.chessBoardSquares[jj][ii] = b;
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JButton target = (JButton)e.getSource();
                        System.out.println(ChessGUI.this.startSquare + " square " + ChessGUI.this.endSquare);
                        if (ChessGUI.this.startSquare == -1) {
                            ChessGUI.this.startSquare = Integer.parseInt(b.getName());
                        } else if (Integer.parseInt(b.getName()) != ChessGUI.this.startSquare) {
                            ChessGUI.this.endSquare = Integer.parseInt(b.getName());
                        }
                        if (ChessGUI.this.startSquare != -1 && ChessGUI.this.endSquare != -1) {
                            int[] move = new int[]{ChessGUI.this.startSquare, ChessGUI.this.endSquare};
                            if (ChessGUI.this.board.doLegalMove(move)) {
                                ChessGUI.this.renderBoard();
                            }
                            ChessGUI.this.startSquare = -1;
                            ChessGUI.this.endSquare = -1;
                        }
                    }
                });
            }
        }
        this.chessBoard.add(new JLabel(""));
        for (ii = 0; ii < 8; ++ii) {
            this.chessBoard.add(new JLabel(COLS.substring(ii, ii + 1), 0));
        }
        for (ii = 0; ii < 8; ++ii) {
            for (jj = 0; jj < 8; ++jj) {
                switch (jj) {
                    case 0: {
                        this.chessBoard.add(new JLabel("" + (9 - (ii + 1)), 0));
                    }
                }
                this.chessBoard.add(this.chessBoardSquares[jj][ii]);
            }
        }
    }

    private void renderBoard() {
        block15: for (int i = 0; i < this.board.getSquares().length; ++i) {
            int currentCol = i % 8;
            int currentRow = i / 8;
            switch (this.board.getSquares()[i]) {
                case '\u0000': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(new BufferedImage(64, 64, 2)));
                    continue block15;
                }
                case 'P': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[1][5]));
                    continue block15;
                }
                case 'N': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[1][3]));
                    continue block15;
                }
                case 'B': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[1][4]));
                    continue block15;
                }
                case 'K': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[1][0]));
                    continue block15;
                }
                case 'Q': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[1][1]));
                    continue block15;
                }
                case 'R': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[1][2]));
                    continue block15;
                }
                case 'p': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[0][5]));
                    continue block15;
                }
                case 'n': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[0][3]));
                    continue block15;
                }
                case 'b': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[0][4]));
                    continue block15;
                }
                case 'k': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[0][0]));
                    continue block15;
                }
                case 'q': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[0][1]));
                    continue block15;
                }
                case 'r': {
                    this.chessBoardSquares[currentCol][currentRow].setIcon(new ImageIcon(this.chessPieceImages[0][2]));
                }
            }
        }
    }

    public final JComponent getGui() {
        return this.gui;
    }

    private final void createImages() {
        try {
            URL url = new URL("https://i.stack.imgur.com/memI0.png");
            BufferedImage bi = ImageIO.read(url);
            for (int ii = 0; ii < 2; ++ii) {
                for (int jj = 0; jj < 6; ++jj) {
                    this.chessPieceImages[ii][jj] = bi.getSubimage(jj * 64, ii * 64, 64, 64);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private final void setupNewGame() {
        this.message.setText("Make your move!");
        this.board = new Board();
        this.renderBoard();
    }

    public static void main(String[] args) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ChessGUI cg = new ChessGUI();
                JFrame f = new JFrame("ChessChamp");
                f.add(cg.getGui());
                f.setDefaultCloseOperation(2);
                f.setLocationByPlatform(true);
                f.pack();
                f.setMinimumSize(f.getSize());
                f.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }
}

