/*
 * Decompiled with CFR 0.152.
 */
package io.queryanalyzer.example.controller;

import io.queryanalyzer.example.dto.UserDTO;
import io.queryanalyzer.example.model.Order;
import io.queryanalyzer.example.model.User;
import io.queryanalyzer.example.repository.UserRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    private final UserRepository userRepository;

    public UserController(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @GetMapping
    public ResponseEntity<List<UserDTO>> getAllUsers() {
        List users = this.userRepository.findAll();
        List response = users.stream().map(this::convertToDTO).collect(Collectors.toList());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/fixed"})
    public ResponseEntity<List<UserDTO>> getAllUsersOptimized() {
        List<User> users = this.userRepository.findAllWithOrders();
        List response = users.stream().map(this::convertToDTO).collect(Collectors.toList());
        return ResponseEntity.ok(response);
    }

    private UserDTO convertToDTO(User user) {
        List<String> productNames = user.getOrders().stream().map(Order::getProductName).collect(Collectors.toList());
        return new UserDTO(user.getId(), user.getName(), user.getEmail(), user.getOrders().size(), productNames);
    }
}

