/*
 * Decompiled with CFR 0.152.
 */
package io.queryanalyzer.example.controller;

import io.queryanalyzer.example.model.Order;
import io.queryanalyzer.example.model.User;
import io.queryanalyzer.example.repository.OrderRepository;
import io.queryanalyzer.example.repository.UserRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/examples"})
public class ExamplesController {
    private final UserRepository userRepository;
    private final OrderRepository orderRepository;
    private final JdbcTemplate jdbcTemplate;

    public ExamplesController(UserRepository userRepository, OrderRepository orderRepository, JdbcTemplate jdbcTemplate) {
        this.userRepository = userRepository;
        this.orderRepository = orderRepository;
        this.jdbcTemplate = jdbcTemplate;
    }

    @GetMapping(value={"/bad/n-plus-one"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> nPlusOneBad() {
        List users = this.userRepository.findAll();
        ArrayList result = new ArrayList();
        for (User user : users) {
            HashMap<String, Object> userData = new HashMap<String, Object>();
            userData.put("id", user.getId());
            userData.put("name", user.getName());
            userData.put("email", user.getEmail());
            userData.put("orderCount", user.getOrders().size());
            result.add(userData);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/good/n-plus-one-fixed"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> nPlusOneGood() {
        List<User> users = this.userRepository.findAllWithOrders();
        ArrayList result = new ArrayList();
        for (User user : users) {
            HashMap<String, Object> userData = new HashMap<String, Object>();
            userData.put("id", user.getId());
            userData.put("name", user.getName());
            userData.put("email", user.getEmail());
            userData.put("orderCount", user.getOrders().size());
            result.add(userData);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/bad/multiple-n-plus-one"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> multipleNPlusOne() {
        List users = this.userRepository.findAll();
        ArrayList result = new ArrayList();
        for (User user : users) {
            HashMap<String, Object> userData = new HashMap<String, Object>();
            userData.put("id", user.getId());
            userData.put("name", user.getName());
            userData.put("orderCount", user.getOrders().size());
            ArrayList<String> products = new ArrayList<String>();
            for (Order order : user.getOrders()) {
                products.add(order.getProductName());
            }
            userData.put("products", products);
            result.add(userData);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/bad/slow-query"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> slowQuery() {
        this.jdbcTemplate.execute("CALL SLEEP(500)");
        List result = this.jdbcTemplate.query("SELECT id, name, email FROM users", (rs, rowNum) -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", rs.getLong("id"));
            data.put("name", rs.getString("name"));
            data.put("email", rs.getString("email"));
            return data;
        });
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/bad/query-in-loop"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> queryInLoop() {
        List users = this.userRepository.findAll();
        ArrayList result = new ArrayList();
        for (User user : users) {
            List<Order> orders = this.orderRepository.findByUserId(user.getId());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("userId", user.getId());
            data.put("userName", user.getName());
            data.put("orderCount", orders.size());
            result.add(data);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/good/query-in-loop-fixed"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> queryInLoopFixed() {
        List users = this.userRepository.findAll();
        ArrayList result = new ArrayList();
        List<Long> userIds = users.stream().map(User::getId).toList();
        List<Order> allOrders = this.orderRepository.findByUserIdIn(userIds);
        HashMap ordersByUser = new HashMap();
        for (Order order : allOrders) {
            ordersByUser.computeIfAbsent(order.getUser().getId(), k -> new ArrayList()).add(order);
        }
        for (User user : users) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("userId", user.getId());
            data.put("userName", user.getName());
            List userOrders = ordersByUser.getOrDefault(user.getId(), List.of());
            data.put("orderCount", userOrders.size());
            result.add(data);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/parameterized/{id}"})
    @Transactional(readOnly=true)
    public ResponseEntity<Map<String, Object>> parameterizedQuery(@PathVariable(value="id") Long id) {
        User user = this.userRepository.findById(id).orElse(null);
        if (user == null) {
            return ResponseEntity.notFound().build();
        }
        List<Order> orders = user.getOrders();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("user", user.getName());
        result.put("orders", orders.size());
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/bad/everything-wrong"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> everythingWrong() {
        ArrayList result = new ArrayList();
        this.jdbcTemplate.execute("CALL SLEEP(200)");
        List users = this.userRepository.findAll();
        for (User user : users) {
            HashMap<Object, Object> userData = new HashMap<Object, Object>();
            List<Order> orders = user.getOrders();
            for (Order order : orders) {
                userData.put("order_" + order.getId(), order.getProductName());
            }
            userData.put("userId", user.getId());
            userData.put("orderCount", orders.size());
            result.add(userData);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/good/best-practices"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> bestPractices() {
        List<User> users = this.userRepository.findAllWithOrders();
        ArrayList result = new ArrayList();
        for (User user : users) {
            HashMap<String, Object> userData = new HashMap<String, Object>();
            userData.put("id", user.getId());
            userData.put("name", user.getName());
            userData.put("email", user.getEmail());
            List<Order> orders = user.getOrders();
            userData.put("orderCount", orders.size());
            List<String> products = orders.stream().map(Order::getProductName).toList();
            userData.put("products", products);
            result.add(userData);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/test/rate-limit"})
    @Transactional(readOnly=true)
    public ResponseEntity<String> testRateLimit() {
        List users = this.userRepository.findAll();
        for (User user : users) {
            user.getOrders().size();
        }
        return ResponseEntity.ok((Object)"Check console for rate limiting");
    }
}

