/*
 * Decompiled with CFR 0.152.
 */
package io.github.redstoneboy0509.javaez.extensions;

import io.github.redstoneboy0509.javaez.backend.BackendVariableContext;
import io.github.redstoneboy0509.javaez.backend.ErrorSystem;
import java.time.Duration;
import java.util.Scanner;

public class Core {
    public static void say(String text) {
        try {
            System.out.println(text);
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error while saying something in the console, text is " + text);
        }
    }

    public static void doIf(boolean condition, Runnable ifTrue) {
        try {
            if (condition) {
                ifTrue.run();
            }
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error in an IF statement without else");
        }
    }

    public static void doIf(boolean condition, Runnable ifTrue, Runnable elseDo) {
        try {
            if (condition) {
                ifTrue.run();
            } else {
                elseDo.run();
            }
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error in an IF statement with else");
        }
    }

    public static void set(String name, String val) {
        try {
            BackendVariableContext.addOrModifyVariable(name, val);
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error while setting a variable");
        }
    }

    public static String get(String name) {
        try {
            return BackendVariableContext.getVariable(name);
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error while getting a variable");
            return "";
        }
    }

    public static void remove(String name) {
        try {
            BackendVariableContext.removeVariable(name);
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error while removing a variable");
        }
    }

    public static void forever(Runnable toRun) {
        try {
            while (true) {
                toRun.run();
            }
        }
        catch (Exception ex) {
            ErrorSystem.handleError("Error in a forever loop");
            return;
        }
    }

    public static void waitFor(int seconds) {
        long startTime = System.currentTimeMillis();
        boolean keepGoing = true;
        while (keepGoing) {
            long elapsed = System.currentTimeMillis() - startTime;
            Duration dur = Duration.ofMillis(elapsed);
            if (dur.getSeconds() < (long)seconds) continue;
            keepGoing = false;
        }
    }

    public static String ask(String prompt) {
        Scanner scanner = new Scanner(System.in);
        System.out.println(prompt);
        return scanner.nextLine();
    }
}

