/*
 * Decompiled with CFR 0.152.
 */
package redis.lock.redlock;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.SetParams;
import redis.lock.redlock.LockResult;

public class RedLock {
    private static final Logger log = LoggerFactory.getLogger(RedLock.class);
    private final String[] servers;
    private List<Jedis> instances = new ArrayList<Jedis>();
    private final String redLockReleaseLuaScript = "if redis.call(\"get\",KEYS[1]) == ARGV[1] then return redis.call(\"del\",KEYS[1]) else return 0 end";
    private final int quorum;
    private final double clockDriftFactor = 0.01;
    private final int retryDelay = 200;
    private int retryCount = 3;

    public RedLock() {
        this("127.0.0.1");
    }

    public RedLock(String host) {
        this(host, 6379);
    }

    public RedLock(String host, int port) {
        this(host, port, "");
    }

    public RedLock(String host, int port, String password) {
        this(host, port, password, 0);
    }

    public RedLock(String host, int port, int database) {
        this(host, port, "", database);
    }

    public RedLock(String host, int port, String password, int database) {
        this.servers = password != null && password.trim().length() != 0 ? new String[]{"redis://:" + password + "@" + host + ":" + port + "/" + database} : new String[]{"redis://" + host + ":" + port + "/" + database};
        this.quorum = 1;
    }

    public RedLock(String[] servers) {
        this.servers = servers;
        this.quorum = Math.min(servers.length, servers.length / 2 + 1);
    }

    private synchronized void init() {
        if (this.instances.size() == 0) {
            try {
                for (String server : this.servers) {
                    this.instances.add(new Jedis(new URI(server)));
                }
            }
            catch (URISyntaxException e) {
                log.error("RedLock - Error initializing Jedis / JedisCluster client. Exception = {}", (Object)e.getMessage());
                this.instances.clear();
            }
        }
    }

    public LockResult lock(String resource) {
        return this.lock(resource, 60000);
    }

    public LockResult lock(String resource, int ttl) {
        String value = this.getRandomUUID().toString();
        return this.lock0(resource, value, ttl);
    }

    private synchronized UUID getRandomUUID() {
        return UUID.randomUUID();
    }

    private synchronized LockResult lock0(String resource, String value, int ttl) {
        this.init();
        if (this.instances.size() == 0) {
            log.error("RedLock - Error. Jedis / JedisCluster client not initialized");
            return null;
        }
        do {
            int n = 0;
            long start = System.currentTimeMillis();
            for (Jedis jedis : this.instances) {
                String reply = jedis.set(resource, value, new SetParams().nx().px((long)ttl));
                if (reply == null || !reply.equals("OK")) continue;
                ++n;
            }
            double drift = (double)ttl * 0.01 + 2.0;
            double validityTime = (double)((long)ttl - (System.currentTimeMillis() - start)) - drift;
            if (n >= this.quorum && validityTime > 0.0) {
                return new LockResult(resource, value, validityTime);
            }
            this.release0(resource, value);
            int randomDelay = (int)(Math.random() * 100.0 + 100.0);
            try {
                Thread.sleep(randomDelay);
            }
            catch (InterruptedException e) {
                log.warn("RedLock - Warning. Sleep of {} ms interrupted in between", (Object)randomDelay);
            }
            --this.retryCount;
        } while (this.retryCount > 0);
        return null;
    }

    public void release(String resource, String value) {
        this.release0(resource, value);
    }

    private synchronized void release0(String resource, String value) {
        this.init();
        if (this.instances.size() == 0) {
            log.error("RedLock - Error. Jedis / JedisCluster client not initialized");
            return;
        }
        for (Jedis jedis : this.instances) {
            jedis.eval("if redis.call(\"get\",KEYS[1]) == ARGV[1] then return redis.call(\"del\",KEYS[1]) else return 0 end", 1, new String[]{resource, value});
        }
    }
}

