/*
 * Decompiled with CFR 0.152.
 */
package io.github.schm1tz1.crypto.helpers;

import io.github.schm1tz1.crypto.helpers.CryptoProvider;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesProvider
extends CryptoProvider {
    public static final String AES_ECB = "AES/ECB/PKCS5PADDING";
    public static final String AES_CBC = "AES/CBC/PKCS5PADDING";
    public static final String AES_GCM = "AES/GCM/NoPadding";
    public static final String INITIALIZATION_VECTOR = "encryption.aes.iv";
    private static final Logger log = LoggerFactory.getLogger(AesProvider.class);
    private static final SecureRandom secureRandom = new SecureRandom();
    private Key symmetricKey;
    private byte[] initializationVector;

    public static String encryptToString(String algorithm, String input, Key key, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] inputBytes = input.getBytes(StandardCharsets.UTF_8);
        byte[] cipherText = AesProvider.encrypt(algorithm, inputBytes, (SecretKey)key, iv);
        return Base64.getEncoder().encodeToString(cipherText);
    }

    public static byte[] encrypt(String algorithm, byte[] inputBytes, Key key, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(algorithm);
        if (Objects.isNull(iv)) {
            cipher.init(1, key);
        } else if (AES_GCM.equalsIgnoreCase(algorithm)) {
            cipher.init(1, key, new GCMParameterSpec(128, iv));
        } else {
            cipher.init(1, key, new IvParameterSpec(iv));
        }
        return cipher.doFinal(inputBytes);
    }

    public static String decryptString(String algorithm, String cipherText, Key key, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] bytes = Base64.getDecoder().decode(cipherText);
        byte[] plainText = AesProvider.decrypt(algorithm, bytes, (SecretKey)key, iv);
        return new String(plainText, StandardCharsets.UTF_8);
    }

    public static byte[] decrypt(String algorithm, byte[] inputBytes, Key key) throws InvalidAlgorithmParameterException, IllegalBlockSizeException, NoSuchPaddingException, BadPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return AesProvider.decrypt(algorithm, inputBytes, key, null);
    }

    public static byte[] decrypt(String algorithm, byte[] inputBytes, Key key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = Cipher.getInstance(algorithm);
        if (Objects.isNull(iv)) {
            cipher.init(2, key);
        } else if (AES_GCM.equalsIgnoreCase(algorithm)) {
            cipher.init(2, key, new GCMParameterSpec(128, iv));
        } else {
            cipher.init(2, key, new IvParameterSpec(iv));
        }
        return cipher.doFinal(inputBytes);
    }

    public static SecretKey generateKey(int n) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(n);
        return keyGenerator.generateKey();
    }

    public static SecretKey getKeyFromPassword(String password, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(StandardCharsets.UTF_8), 65536, 256);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
    }

    public static byte[] randomIv(int length) {
        byte[] iv = new byte[length];
        secureRandom.nextBytes(iv);
        return iv;
    }

    @Override
    public byte[] encrypt(byte[] plaintextIn) {
        byte[] cipherData;
        try {
            cipherData = AesProvider.encrypt(this.algorithmParameters, plaintextIn, this.symmetricKey, this.initializationVector);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return cipherData;
    }

    @Override
    public byte[] decrypt(byte[] ciphertextIn) {
        byte[] plaintextData;
        try {
            plaintextData = AesProvider.decrypt(this.algorithmParameters, ciphertextIn, this.symmetricKey, this.initializationVector);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return plaintextData;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        String keyAsString = (String)configs.get("encryption.key");
        log.info("Processing base64 encoded AES key...");
        this.symmetricKey = this.parseKeyFromString(keyAsString);
        String initializationVector = (String)configs.get(INITIALIZATION_VECTOR);
        if (Objects.nonNull(initializationVector)) {
            log.info("Processing string-encoded IV to bytes...");
            this.initializationVector = initializationVector.getBytes(StandardCharsets.UTF_8);
        } else {
            log.info("No IV specified, setting to null...");
            this.initializationVector = null;
        }
    }

    private Key parseKeyFromString(String keyAsString) {
        byte[] decodedKey = Base64.getDecoder().decode(keyAsString);
        return new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
    }
}

