/*
 * Decompiled with CFR 0.152.
 */
package io.github.schm1tz1.crypto.helpers;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CryptoProvider {
    public static final String ENCRYPTION_KEY = "encryption.key";
    public static final String ALGORITHM_PARAMETERS = "encryption.cipher.mode";
    public static final String STRINGS_USE_BASE_64 = "encryption.strings.use.base64";
    private static final Logger log = LoggerFactory.getLogger(CryptoProvider.class);
    protected Boolean stringsAsBase64;
    protected String algorithmParameters;

    public abstract byte[] encrypt(byte[] var1);

    public String encrypt(String plaintextIn) {
        byte[] cipherData = this.encrypt(plaintextIn.getBytes(StandardCharsets.UTF_8));
        if (this.stringsAsBase64.booleanValue()) {
            return Base64.getEncoder().encodeToString(cipherData);
        }
        return new String(cipherData, StandardCharsets.UTF_8);
    }

    public abstract byte[] decrypt(byte[] var1);

    public void configure(Map<String, ?> configs) {
        String algorithmParameters;
        this.algorithmParameters = algorithmParameters = (String)configs.get(ALGORITHM_PARAMETERS);
        log.info("Setting algorithm parameters to " + this.algorithmParameters);
        Boolean stringsAsBase64 = (Boolean)configs.get(STRINGS_USE_BASE_64);
        this.stringsAsBase64 = Objects.requireNonNullElse(stringsAsBase64, true);
        log.info("Base64 encoded output: " + this.stringsAsBase64.toString());
    }

    public String decrypt(String ciphertextIn) {
        byte[] ciphertextBytes = this.stringToBytes(ciphertextIn);
        return new String(this.decrypt(ciphertextBytes), StandardCharsets.UTF_8);
    }

    byte[] stringToBytes(String inputString) {
        if (this.stringsAsBase64.booleanValue()) {
            return Base64.getDecoder().decode(inputString);
        }
        return inputString.getBytes(StandardCharsets.UTF_8);
    }

    String bytesToString(byte[] inputBytes) {
        if (this.stringsAsBase64.booleanValue()) {
            return Base64.getEncoder().encodeToString(inputBytes);
        }
        return new String(inputBytes, StandardCharsets.UTF_8);
    }
}

