/*
 * Decompiled with CFR 0.152.
 */
package io.github.schm1tz1.crypto.helpers;

import io.github.schm1tz1.crypto.helpers.CryptoProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RsaProvider
extends CryptoProvider {
    public static final String RSA_OAEP = "RSA/ECB/OAEPPadding";
    public static final String RSA_PKCS1 = "RSA/ECB/PKCS1Padding";
    public static final String RSA_OAEP_SHA256_MGF1 = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private static final Logger log = LoggerFactory.getLogger(RsaProvider.class);
    private PublicKey publicKey;

    static PublicKey createPublicKey(HashMap<String, BigInteger> keySpecs) {
        PublicKey pubKey = null;
        try {
            pubKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(keySpecs.get("Modulus"), keySpecs.get("Exponent")));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return pubKey;
    }

    static PrivateKey createPrivateKey(HashMap<String, BigInteger> keySpecs) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new RSAPrivateCrtKeySpec(keySpecs.get("Modulus"), keySpecs.get("Exponent"), keySpecs.get("D"), keySpecs.get("P"), keySpecs.get("Q"), keySpecs.get("DP"), keySpecs.get("DQ"), keySpecs.get("InverseQ")));
        return privateKey;
    }

    static PublicKey parsePemToRsaPubKey(String keyAsPem) {
        String keyContents = keyAsPem.replace("-----BEGIN PUBLIC KEY-----", "").replaceAll(System.lineSeparator(), "").replace("-----END PUBLIC KEY-----", "");
        byte[] encoded = Base64.getDecoder().decode(keyContents);
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
        try {
            return keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isPemKeyFormat(String keyAsString) {
        return keyAsString.startsWith("-----BEGIN PUBLIC KEY-----") || keyAsString.startsWith("MII");
    }

    @Override
    public byte[] encrypt(byte[] plaintextIn) {
        byte[] cipherData;
        try {
            Cipher cipher = Cipher.getInstance(this.algorithmParameters);
            cipher.init(1, this.publicKey);
            cipherData = cipher.doFinal(plaintextIn);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return cipherData;
    }

    @Override
    public byte[] decrypt(byte[] ciphertextIn) {
        return null;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        String keyAsString = (String)configs.get("encryption.key");
        if (RsaProvider.isPemKeyFormat(keyAsString)) {
            log.info("Processing PEM encoded public RSA key...");
            this.publicKey = RsaProvider.parsePemToRsaPubKey(keyAsString);
        } else {
            log.info("Processing XML encoded public RSA key...");
            HashMap<String, BigInteger> parsedXmlKeyAsMap = XmlKeyParser.parseKeyFromXmlString(keyAsString);
            this.publicKey = RsaProvider.createPublicKey(parsedXmlKeyAsMap);
        }
    }

    class XmlKeyParser {
        XmlKeyParser() {
        }

        static HashMap<String, BigInteger> parseKeyFromXmlString(String xmlInput) {
            DocumentBuilder db = null;
            try {
                db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Error setting up XML parser: ", e);
            }
            Element elementsByTagName = null;
            try {
                elementsByTagName = db.parse(new ByteArrayInputStream(xmlInput.getBytes())).getDocumentElement();
            }
            catch (SAXException e) {
                throw new RuntimeException("Cannot parse XML input: ", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read input: ", e);
            }
            String[] names = new String[]{"Modulus", "Exponent", "D", "P", "Q", "DP", "DQ", "InverseQ"};
            HashMap<String, BigInteger> values = new HashMap<String, BigInteger>();
            Element finalElementsByTagName = elementsByTagName;
            ((Stream)Arrays.stream(names).sequential()).forEach(key -> {
                Node firstItem = finalElementsByTagName.getElementsByTagName((String)key).item(0);
                if (Objects.isNull(firstItem)) {
                    return;
                }
                String value = firstItem.getTextContent();
                if (value != null) {
                    BigInteger parsedValue = new BigInteger(1, Base64.getDecoder().decode(value));
                    values.put((String)key, parsedValue);
                }
            });
            return values;
        }
    }
}

