/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.asyncsupport.spring;

import java.util.ArrayList;
import java.util.List;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.asyncsupport.spring.SpringAsyncExecutionCV;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class SpringAsyncExecutionASM
implements IASM,
Opcodes {
    private static List<String> asyncSubmitPatterns = new ArrayList<String>();
    private List<HookingSet> asyncExecutionTarget;
    private Configure conf = Configure.getInstance();
    public static final String METHOD_DETERMINE_EXECUTOR = "determineAsyncExecutor(Ljava/lang/reflect/Method;)Lorg/springframework/core/task/AsyncTaskExecutor;";

    public SpringAsyncExecutionASM() {
        this.asyncExecutionTarget = HookingSet.getHookingMethodSet(HookingSet.buildPatterns(this.conf.hook_spring_async_submit_patterns, asyncSubmitPatterns));
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf.hook_spring_async_enabled) {
            return cv;
        }
        for (int i = 0; i < this.asyncExecutionTarget.size(); ++i) {
            HookingSet mset = this.asyncExecutionTarget.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new SpringAsyncExecutionCV(cv, mset, className);
        }
        return cv;
    }

    static {
        asyncSubmitPatterns.add("org.springframework.aop.interceptor.AsyncExecutionAspectSupport.doSubmit(Ljava/util/concurrent/Callable;Lorg/springframework/core/task/AsyncTaskExecutor;Ljava/lang/Class;)Ljava/lang/Object;");
    }
}

