/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.task;

import scouter.agent.Configure;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.agent.counter.meter.MeterResource;
import scouter.agent.counter.meter.MeterService;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.summary.EndUserSummary;
import scouter.agent.summary.ServiceSummary;
import scouter.agent.trace.TraceContextManager;
import scouter.agent.util.DumpUtil;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.pack.SummaryPack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.FloatValue;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;

public class ServicePerf {
    private MeterResource activeCounter = new MeterResource();
    private Configure conf = Configure.getInstance();
    private long last_sent = DateUtil.getMinUnit(System.currentTimeMillis()) / 5L;

    @Counter
    public void getServicePerf(CounterBasket pw) {
        Configure conf = Configure.getInstance();
        MeterService service = MeterService.getInstance();
        int elapsed = service.getElapsedTime(30);
        float tps = service.getTPS(30);
        float errorRate = service.getErrorRate(30);
        int count = service.getServiceCount(60);
        int resp90pct = service.getElapsed90Pct(30);
        int sqlTimeByService = service.getSqlTime(30);
        int apiTimeByService = service.getApiTime(30);
        int queuingTime = service.getQueuingTime(30);
        int[] act = TraceContextManager.getActiveCount();
        int active = act[0] + act[1] + act[2];
        if (conf.autodump_trigger_active_service_cnt <= active) {
            DumpUtil.autoDump();
        }
        this.activeCounter.add(active);
        active = (int)Math.round(this.activeCounter.getAvg(30));
        PerfCounterPack p = pw.getPack((byte)1);
        p.put("ElapsedTime", new DecimalValue(elapsed));
        p.put("ServiceCount", new DecimalValue(count));
        p.put("TPS", new FloatValue(tps));
        p.put("ErrorRate", new FloatValue(errorRate));
        p.put("ActiveService", new DecimalValue(active));
        p.put("Elapsed90%", new DecimalValue(resp90pct));
        p.put("ApiTimeByService", new DecimalValue(apiTimeByService));
        p.put("SqlTimeByService", new DecimalValue(sqlTimeByService));
        p.put("QueuingTime", new DecimalValue(queuingTime));
        ListValue activeSpeed = new ListValue();
        activeSpeed.add(act[0]);
        activeSpeed.add(act[1]);
        activeSpeed.add(act[2]);
        p.put("ActiveSpeed", activeSpeed);
        count = service.getServiceCount(300);
        tps = service.getTPS(300);
        elapsed = service.getElapsedTime(300);
        errorRate = service.getErrorRate(300);
        int activeService = (int)this.activeCounter.getAvg(300);
        resp90pct = service.getElapsed90Pct(300);
        sqlTimeByService = service.getSqlTime(300);
        apiTimeByService = service.getApiTime(300);
        p = pw.getPack((byte)3);
        p.put("ElapsedTime", new DecimalValue(elapsed));
        p.put("ServiceCount", new DecimalValue(count));
        p.put("TPS", new FloatValue(tps));
        p.put("ErrorRate", new FloatValue(errorRate));
        p.put("ActiveService", new DecimalValue(activeService));
        p.put("Elapsed90%", new DecimalValue(resp90pct));
        p.put("ApiTimeByService", new DecimalValue(apiTimeByService));
        p.put("SqlTimeByService", new DecimalValue(sqlTimeByService));
        p.put("QueuingTime", new DecimalValue(queuingTime));
    }

    @Counter(interval=500)
    public void summay(CounterBasket pw) {
        long time = System.currentTimeMillis();
        long now = DateUtil.getMinUnit(time) / 5L;
        if (this.conf.getBoolean("_dev_summary_test", false)) {
            now = time / 1000L / 15L;
        }
        if (now == this.last_sent) {
            return;
        }
        this.last_sent = now;
        time = (time - 10000L) / 300000L * 300000L;
        SummaryPack p = ServiceSummary.getInstance().getAndClear((byte)1);
        if (p != null) {
            p.time = time;
            DataProxy.send(p);
        }
        if ((p = ServiceSummary.getInstance().getAndClear((byte)2)) != null) {
            p.time = time;
            DataProxy.send(p);
        }
        if ((p = ServiceSummary.getInstance().getAndClear((byte)5)) != null) {
            p.time = time;
            DataProxy.send(p);
        }
        if ((p = ServiceSummary.getInstance().getAndClearX((byte)4)) != null) {
            p.time = time;
            DataProxy.send(p);
        }
        if ((p = ServiceSummary.getInstance().getAndClearX((byte)8)) != null) {
            p.time = time;
            DataProxy.send(p);
        }
        if ((p = ServiceSummary.getInstance().getAndClearError((byte)9)) != null) {
            p.time = time;
            DataProxy.send(p);
        }
    }

    @Counter(interval=500)
    public void enduser(CounterBasket pw) {
        long time = System.currentTimeMillis();
        long now = DateUtil.getMinUnit(time) / 5L;
        if (now == this.last_sent) {
            return;
        }
        this.last_sent = now;
        time = (time - 10000L) / 300000L * 300000L;
        SummaryPack p = EndUserSummary.getInstance().getAndClearNavTable();
        if (p != null) {
            p.time = time;
            DataProxy.send(p);
        }
        if ((p = EndUserSummary.getInstance().getAndClearAjaxTable()) != null) {
            p.time = time;
            DataProxy.send(p);
        }
        if ((p = EndUserSummary.getInstance().getAndClearErrorTable()) != null) {
            p.time = time;
            DataProxy.send(p);
        }
    }
}

