/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.netio.request.handle;

import java.io.IOException;
import java.util.Enumeration;
import scouter.agent.AgentCommonConstant;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.counter.task.MakeStack;
import scouter.agent.netio.request.anotation.RequestHandler;
import scouter.agent.netio.request.worker.DumpOnCpuExceedanceWorker;
import scouter.agent.proxy.ToolsMainFactory;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.TraceContextManager;
import scouter.agent.util.DumpUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.NullValue;
import scouter.lang.value.TextValue;
import scouter.util.CastUtil;
import scouter.util.Hexa32;
import scouter.util.SysJMX;
import scouter.util.ThreadUtil;

public class AgentThread {
    Configure conf = Configure.getInstance();

    @RequestHandler(value="OBJECT_THREAD_DETAIL")
    public Pack threadDetail(Pack param) {
        MapPack p;
        MapPack paramPack = (MapPack)param;
        long thread = paramPack.getLong("id");
        long txid = paramPack.getLong("txid");
        if (thread != 0L) {
            p = ThreadUtil.getThreadDetail(thread);
            TraceContext ctx = TraceContextManager.getContext(thread);
        } else {
            p = new MapPack();
            TraceContext ctx = TraceContextManager.getDeferredContext(txid);
            p.put("Thread Id", new DecimalValue(0L));
            if (ctx != null) {
                p.put("Thread Name", new TextValue("[No Thread] wait on deferred queue"));
                p.put("State", new TextValue("n/a"));
                p.put("Service Txid", new TextValue(Hexa32.toString32(ctx.txid)));
                p.put("Service Name", new TextValue(AgentCommonConstant.removeSpringRequestMappingPostfixFlag(ctx.serviceName)));
                long etime = System.currentTimeMillis() - ctx.startTime;
                p.put("Service Elapsed", new DecimalValue(etime));
            } else {
                p.put("Thread Name", new TextValue("[No Thread] End"));
                p.put("State", new TextValue("end"));
            }
        }
        return p;
    }

    @RequestHandler(value="OBJECT_THREAD_CONTROL")
    public Pack threadKill(Pack param) {
        long thread = ((MapPack)param).getLong("id");
        String action = ((MapPack)param).getText("action");
        TraceContext ctx = TraceContextManager.getContext(thread);
        try {
            if (ctx != null) {
                if ("interrupt".equalsIgnoreCase(action)) {
                    ctx.thread.interrupt();
                } else if ("stop".equalsIgnoreCase(action)) {
                    ctx.thread.stop();
                } else if ("resume".equalsIgnoreCase(action)) {
                    ctx.thread.resume();
                } else if ("suspend".equalsIgnoreCase(action)) {
                    ctx.thread.suspend();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MapPack p = ThreadUtil.getThreadDetail(thread);
        if (ctx != null) {
            String subcall;
            p.put("Service Txid", new TextValue(Hexa32.toString32(ctx.txid)));
            p.put("Service Name", new TextValue(AgentCommonConstant.removeSpringRequestMappingPostfixFlag(ctx.serviceName)));
            long etime = System.currentTimeMillis() - ctx.startTime;
            p.put("Service Elapsed", new DecimalValue(etime));
            String sql = ctx.sqltext;
            if (sql != null) {
                p.put("SQL", sql);
            }
            if ((subcall = ctx.apicall_name) != null) {
                p.put("Subcall", subcall);
            }
        }
        return p;
    }

    @RequestHandler(value="OBJECT_THREAD_LIST")
    public Pack threadList(Pack param) {
        MapPack mpack = ThreadUtil.getThreadList();
        ListValue ids = mpack.getList("id");
        ListValue txid = mpack.newList("txid");
        ListValue elapsed = mpack.newList("elapsed");
        ListValue service = mpack.newList("service");
        for (int i = 0; i < ids.size(); ++i) {
            long tid = CastUtil.clong(ids.get(i));
            TraceContext ctx = TraceContextManager.getContext(tid);
            if (ctx != null) {
                txid.add(new TextValue(Hexa32.toString32(ctx.txid)));
                service.add(new TextValue(AgentCommonConstant.removeSpringRequestMappingPostfixFlag(ctx.serviceName)));
                long etime = System.currentTimeMillis() - ctx.startTime;
                elapsed.add(new DecimalValue(etime));
                continue;
            }
            txid.add(new NullValue());
            elapsed.add(new NullValue());
            service.add(new NullValue());
        }
        return mpack;
    }

    @RequestHandler(value="OBJECT_ACTIVE_SERVICE_LIST")
    public Pack activeThreadList(Pack param) {
        MapPack rPack = new MapPack();
        ListValue id = rPack.newList("id");
        ListValue elapsed = rPack.newList("elapsed");
        ListValue service = rPack.newList("service");
        ListValue stat = rPack.newList("stat");
        ListValue name = rPack.newList("name");
        ListValue cpu = rPack.newList("cpu");
        ListValue txid = rPack.newList("txid");
        ListValue ip = rPack.newList("ip");
        ListValue sql = rPack.newList("sql");
        ListValue subcall = rPack.newList("subcall");
        ListValue login = rPack.newList("login");
        ListValue desc = rPack.newList("desc");
        Enumeration<TraceContext> en = TraceContextManager.getContextEnumeration();
        while (en.hasMoreElements()) {
            TraceContext ctx = en.nextElement();
            if (ctx == null) continue;
            id.add(ctx.thread.getId());
            name.add(ctx.thread.getName());
            stat.add(ctx.thread.getState().name());
            txid.add(new TextValue(Hexa32.toString32(ctx.txid)));
            service.add(new TextValue(AgentCommonConstant.removeSpringRequestMappingPostfixFlag(ctx.serviceName)));
            ip.add(ctx.remoteIp);
            long etime = System.currentTimeMillis() - ctx.startTime;
            elapsed.add(new DecimalValue(etime));
            sql.add(ctx.sqltext);
            subcall.add(ctx.apicall_name);
            try {
                cpu.add(SysJMX.getThreadCpuTime(ctx.thread));
            }
            catch (Throwable th) {
                Logger.println("A128", th);
                cpu.add(0L);
            }
            login.add(ctx.login);
            desc.add(ctx.desc);
        }
        Enumeration<TraceContext> enDeferred = TraceContextManager.getDeferredContextEnumeration();
        while (enDeferred.hasMoreElements()) {
            TraceContext ctx = enDeferred.nextElement();
            if (ctx == null) continue;
            id.add(0L);
            name.add("[No Thread] wait on deferred queue");
            stat.add("n/a");
            txid.add(new TextValue(Hexa32.toString32(ctx.txid)));
            service.add(new TextValue(AgentCommonConstant.removeSpringRequestMappingPostfixFlag(ctx.serviceName)));
            ip.add(ctx.remoteIp);
            long etime = System.currentTimeMillis() - ctx.startTime;
            elapsed.add(new DecimalValue(etime));
            sql.add(ctx.sqltext);
            subcall.add("");
            cpu.add(0L);
            login.add(ctx.login);
            desc.add(ctx.desc);
        }
        rPack.put("complete", new BooleanValue(true));
        return rPack;
    }

    @RequestHandler(value="OBJECT_THREAD_DUMP")
    public Pack threadDump(Pack param) {
        try {
            return ToolsMainFactory.threadDump(param);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestHandler(value="TRIGGER_ACTIVE_SERVICE_LIST")
    public Pack triggerActiveServiceList(Pack param) {
        return DumpUtil.triggerActiveService();
    }

    @RequestHandler(value="TRIGGER_THREAD_LIST")
    public Pack triggerThreadList(Pack param) {
        return DumpUtil.triggerThreadList();
    }

    @RequestHandler(value="TRIGGER_THREAD_DUMP")
    public Pack triggerThreadDump(Pack param) {
        return DumpUtil.triggerThreadDump();
    }

    @RequestHandler(value="TRIGGER_THREAD_DUMPS_FROM_CONDITIONS")
    public Pack triggerThreadDumpsFromConditions(Pack param) {
        MapPack mpack = (MapPack)param;
        DumpOnCpuExceedanceWorker.getInstance().add(mpack.getText("TRIGGER_DUMP_REASON"));
        return null;
    }

    @RequestHandler(value="PSTACK_ON")
    public Pack turnOn(Pack param) {
        MapPack p = (MapPack)param;
        long time = p.getLong("time");
        MakeStack.pstack_requested = time <= 0L ? 0L : System.currentTimeMillis() + time;
        return param;
    }

    public static void main(String[] args) throws IOException {
    }
}

