/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.plugin;

import scouter.agent.netio.data.DataProxy;
import scouter.agent.trace.TraceContext;
import scouter.lang.enumeration.ParameterizedMessageLevel;
import scouter.lang.step.HashedMessageStep;
import scouter.lang.step.MessageStep;
import scouter.lang.step.ParameterizedMessageStep;
import scouter.util.HashUtil;
import scouter.util.SysJMX;

public class WrContext {
    private TraceContext ctx;

    public WrContext(TraceContext ctx) {
        this.ctx = ctx;
    }

    public String service() {
        return this.ctx.serviceName;
    }

    public void service(String name) {
        if (name == null) {
            return;
        }
        this.ctx.serviceHash = HashUtil.hash(name);
        this.ctx.serviceName = name;
    }

    public int serviceHash() {
        return this.ctx.serviceHash;
    }

    public void remoteIp(String ip) {
        this.ctx.remoteIp = ip;
    }

    public String remoteIp() {
        return this.ctx.remoteIp == null ? "0.0.0.0" : this.ctx.remoteIp;
    }

    public void error(String err) {
        if (this.ctx.error == 0) {
            this.ctx.error = DataProxy.sendError(err);
        }
    }

    public boolean isError() {
        return this.ctx.error != 0;
    }

    public void group(String group) {
        this.ctx.group = group;
    }

    public String group() {
        return this.ctx.group;
    }

    public void login(String id) {
        this.ctx.login = id;
    }

    public String login() {
        return this.ctx.login;
    }

    public void desc(String desc) {
        this.ctx.desc = desc;
    }

    public String desc() {
        return this.ctx.desc;
    }

    public void text1(String text) {
        this.ctx.text1 = text;
    }

    public String text1() {
        return this.ctx.text1;
    }

    public void text2(String text) {
        this.ctx.text2 = text;
    }

    public String text2() {
        return this.ctx.text2;
    }

    public String httpMethod() {
        return this.ctx.http_method;
    }

    public String httpQuery() {
        return this.ctx.http_query;
    }

    public String httpContentType() {
        return this.ctx.http_content_type;
    }

    public String userAgent() {
        return this.ctx.userAgentString;
    }

    public void profile(String msg) {
        MessageStep p = new MessageStep();
        p.message = msg;
        p.start_time = (int)(System.currentTimeMillis() - this.ctx.startTime);
        if (this.ctx.profile_thread_cputime) {
            p.start_cpu = (int)(SysJMX.getCurrentThreadCPU() - this.ctx.startCpu);
        }
        this.ctx.profile.add(p);
    }

    public void hashProfile(String msg, int value, int elapsed) {
        HashedMessageStep step = new HashedMessageStep();
        step.hash = DataProxy.sendHashedMessage(msg);
        step.value = value;
        step.time = elapsed;
        step.start_time = (int)(System.currentTimeMillis() - this.ctx.startTime);
        if (this.ctx.profile_thread_cputime) {
            step.start_cpu = (int)(SysJMX.getCurrentThreadCPU() - this.ctx.startCpu);
        }
        this.ctx.profile.add(step);
    }

    public void parameterizedProfile(int level, String msg, int elapsed, String ... params) {
        ParameterizedMessageStep step = new ParameterizedMessageStep();
        step.setMessage(DataProxy.sendHashedMessage(msg), params);
        step.setElapsed(elapsed);
        step.setLevel(ParameterizedMessageLevel.of(level));
        step.start_time = (int)(System.currentTimeMillis() - this.ctx.startTime);
        if (this.ctx.profile_thread_cputime) {
            step.start_cpu = (int)(SysJMX.getCurrentThreadCPU() - this.ctx.startCpu);
        }
        this.ctx.profile.add(step);
    }

    public void parameterizedProfile(String msg, String ... params) {
        this.parameterizedProfile(0, msg, -1, params);
    }

    public void parameterizedProfile(int level, String msg, String ... params) {
        this.parameterizedProfile(level, msg, -1, params);
    }

    public long txid() {
        return this.ctx.txid;
    }

    public long gxid() {
        return this.ctx.gxid;
    }

    public TraceContext inner() {
        return this.ctx;
    }
}

