/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.conf;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import scouter.lang.conf.ConfigDesc;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.DoubleValue;
import scouter.lang.value.FloatValue;
import scouter.lang.value.NullValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouter.util.ArrayUtil;
import scouter.util.ParamText;
import scouter.util.StringKeyLinkedMap;
import scouter.util.StringUtil;

public class ConfigValueUtil {
    public static Properties replaceSysProp(Properties temp) {
        Properties p = new Properties();
        HashMap<Object, Object> args = new HashMap<Object, Object>();
        args.putAll(System.getenv());
        args.putAll(System.getProperties());
        p.putAll((Map<?, ?>)args);
        for (String string : temp.keySet()) {
            String value = (String)temp.get(string);
            p.put(string, new ParamText(StringUtil.trim(value)).getText(args));
        }
        return p;
    }

    public static StringKeyLinkedMap<Object> getConfigDefault(Object o) {
        StringKeyLinkedMap<Object> map = new StringKeyLinkedMap<Object>();
        Field[] fields = o.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            try {
                String name = fields[i].getName();
                Object value = fields[i].get(o);
                map.put(name, value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public static StringKeyLinkedMap<String> getConfigDescMap(Object o) {
        StringKeyLinkedMap<String> descMap = new StringKeyLinkedMap<String>();
        Field[] fields = o.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            try {
                ConfigDesc desc = fields[i].getAnnotation(ConfigDesc.class);
                if (desc == null || !StringUtil.isNotEmpty(desc.value())) continue;
                String name = fields[i].getName();
                descMap.put(name, desc.value());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return descMap;
    }

    public static Value toValue(Object o) {
        if (o == null) {
            return new NullValue();
        }
        if (o instanceof Float) {
            return new FloatValue(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new DoubleValue((Double)o);
        }
        if (o instanceof Number) {
            return new DecimalValue(((Number)o).longValue());
        }
        if (o instanceof Boolean) {
            return new BooleanValue((Boolean)o);
        }
        if (o.getClass().isArray()) {
            String s = ArrayUtil.toString(o);
            return new TextValue(s.substring(1, s.length() - 1));
        }
        return new TextValue(o.toString());
    }
}

