/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent;

import scouter.agent.Logger;
import scouter.util.StringEnumer;
import scouter.util.StringKeyLinkedMap;
import scouter.util.ThreadUtil;

public class BackJobs
extends Thread {
    private static BackJobs instance = null;
    private StringKeyLinkedMap<JobW> jobs = new StringKeyLinkedMap();
    private boolean running = true;

    public static final synchronized BackJobs getInstance() {
        if (instance == null) {
            instance = new BackJobs();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    protected BackJobs() {
    }

    public void put(String id, int interval, Runnable job) {
        this.jobs.put(id, new JobW(job, interval));
    }

    public void remove(String id) {
        this.jobs.remove(id);
    }

    public void shutdown() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running) {
            ThreadUtil.sleep(1000L);
            try {
                this.process();
            }
            catch (Throwable t) {
                Logger.println("A109", t);
            }
        }
    }

    private void process() {
        StringEnumer en = this.jobs.keys();
        while (en.hasMoreElements()) {
            long now;
            String id = en.nextString();
            JobW jobw = this.jobs.get(id);
            if (jobw == null || (now = System.currentTimeMillis()) < jobw.lastExTime + (long)jobw.interval) continue;
            jobw.lastExTime = now;
            try {
                jobw.job.run();
            }
            catch (Exception e) {
                Logger.println("A110", id + ":" + e);
            }
        }
    }

    public class JobW {
        Runnable job;
        long lastExTime;
        int interval;

        public JobW(Runnable job, int interval) {
            this.job = job;
            this.interval = interval;
        }
    }
}

