/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang;

import scouter.util.StringKeyLinkedMap;

public class Counter
implements Comparable<Counter> {
    public static final int MIN_NORMALIZE_SEC = 4;
    public static final int MAX_NORMALIZE_SEC = 60;
    private String name;
    private String displayName;
    private String unit;
    private String icon;
    private boolean all = true;
    private boolean total = true;
    private StringKeyLinkedMap<String> attrMap = new StringKeyLinkedMap();

    public Counter() {
    }

    public Counter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public boolean isTotal() {
        return this.total;
    }

    public void setTotal(boolean total) {
        this.total = total;
    }

    public String setAttribute(String key, String value) {
        return this.attrMap.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attrMap.get(key);
    }

    public boolean isTrueAttribute(String key) {
        String value = this.attrMap.get(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Counter other = (Counter)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean someContentsEquals(Counter other) {
        if (other == null) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return this.total == other.total;
    }

    @Override
    public int compareTo(Counter o) {
        return this.name.compareTo(o.getName());
    }

    public Counter clone() {
        Counter clone = new Counter();
        clone.name = this.name;
        clone.displayName = this.displayName;
        clone.unit = this.unit;
        clone.icon = this.icon;
        clone.all = this.all;
        clone.total = this.total;
        clone.attrMap = this.attrMap;
        return clone;
    }
}

