/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.InteractionCounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.agent.counter.anotation.InteractionCounter;
import scouter.agent.netio.data.DataProxy;
import scouter.lang.pack.Pack;
import scouter.util.ThreadUtil;
import scouter.util.scan.Scanner;

public class CounterExecutingManager
extends Thread {
    Configure conf = Configure.getInstance();
    private static CounterExecutingManager instance;
    private List<CountStat> countStatList = new ArrayList<CountStat>();
    private List<CountStat> interactionCountStatList = new ArrayList<CountStat>();

    private CounterExecutingManager() {
    }

    public static final synchronized CounterExecutingManager getInstance() {
        if (instance == null) {
            instance = new CounterExecutingManager();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    @Override
    public void run() {
        while (true) {
            ThreadUtil.sleep(1000L);
            if (!this.conf.counter_enabled) continue;
            long now = System.currentTimeMillis();
            this.gatherAndSendCounter(now);
            this.gatherAndSendInteractionCounter(now);
        }
    }

    private void gatherAndSendCounter(long now) {
        CounterBasket basket = new CounterBasket();
        for (int i = 0; i < this.countStatList.size(); ++i) {
            CountStat stat = this.countStatList.get(i);
            try {
                if (stat.counter.interval() > now - stat.xtime) continue;
                stat.xtime = now;
                stat.counter.process(basket);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Pack[] packs = basket.getList();
        DataProxy.sendCounter(packs);
    }

    private void gatherAndSendInteractionCounter(long now) {
        InteractionCounterBasket basket = new InteractionCounterBasket();
        for (int i = 0; i < this.interactionCountStatList.size(); ++i) {
            CountStat stat = this.interactionCountStatList.get(i);
            try {
                if (stat.counter.interval() > now - stat.xtime) continue;
                stat.xtime = now;
                stat.counter.process(basket);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Pack[] packs = basket.geAllAsArray();
        if (packs != null && packs.length > 0) {
            DataProxy.sendCounter(packs);
        }
    }

    public void putCounter(Invocation counter) {
        this.countStatList.add(new CountStat(counter));
    }

    public void putInteractionCounter(Invocation counter) {
        this.interactionCountStatList.add(new CountStat(counter));
    }

    public static void load() {
        Set<String> defaultTasks = new Scanner("scouter.agent.counter.task").process();
        Set<String> customTasks = new Scanner(System.getProperty("scouter.task")).process();
        defaultTasks.addAll(customTasks);
        int counterCount = 0;
        int interactionCounterCount = 0;
        Iterator<String> itr = defaultTasks.iterator();
        while (itr.hasNext()) {
            try {
                Class<?> c = Class.forName(itr.next());
                if (!Modifier.isPublic(c.getModifiers())) continue;
                Method[] m = c.getDeclaredMethods();
                for (int i = 0; i < m.length; ++i) {
                    InteractionCounter icntAnot;
                    Counter cntAn = m[i].getAnnotation(Counter.class);
                    if (cntAn != null) {
                        int interval = cntAn.interval();
                        CounterExecutingManager.getInstance().putCounter(new Invocation(c.newInstance(), m[i], interval));
                        ++counterCount;
                    }
                    if ((icntAnot = m[i].getAnnotation(InteractionCounter.class)) == null) continue;
                    int interval = icntAnot.interval();
                    CounterExecutingManager.getInstance().putInteractionCounter(new Invocation(c.newInstance(), m[i], interval));
                    ++interactionCounterCount;
                }
            }
            catch (Throwable t) {
                Logger.println("A112", ThreadUtil.getStackTrace(t));
            }
        }
        Logger.println("A113", "Counter Collector Started (#" + counterCount + ")");
        Logger.println("A113", "InteractionCounter Collector Started (#" + counterCount + ")");
    }

    static class CountStat {
        Invocation counter;
        long xtime;

        CountStat(Invocation counter) {
            this.counter = counter;
        }
    }

    protected static class Invocation {
        Object object;
        Method method;
        long time;

        public Invocation(Object object, Method method, long interval) {
            this.object = object;
            this.method = method;
            this.time = interval;
        }

        public void process(CounterBasket pw) throws Throwable {
            try {
                this.method.invoke(this.object, pw);
            }
            catch (Exception e) {
                Logger.println("A111", this.object.getClass() + " " + this.method + " " + e.getMessage(), e);
                e.printStackTrace();
            }
        }

        public void process(InteractionCounterBasket pw) throws Throwable {
            try {
                this.method.invoke(this.object, pw);
            }
            catch (Exception e) {
                Logger.println("A111-1", this.object.getClass() + " " + this.method + " " + e);
            }
        }

        public long interval() {
            return this.time;
        }
    }
}

