/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scouter.util.CastUtil;

public class ShellArg {
    private Map<String, String> parameter = new HashMap<String, String>();
    private Map<String, String> parameter2 = new HashMap<String, String>();

    public ShellArg(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            if (this.hasNextValue(i, args)) {
                String key = args[i];
                this.parameter.put(key, args[i + 1]);
                if (!this.hasNextValue(++i, args)) continue;
                this.parameter2.put(key, args[i + 1]);
                ++i;
                continue;
            }
            this.parameter.put(args[i], "");
        }
    }

    private boolean hasNextValue(int i, String[] args) {
        return i + 1 < args.length && !args[i + 1].startsWith("-");
    }

    public boolean hasKey(String key) {
        return this.parameter.containsKey(key);
    }

    public Set<String> keys() {
        return this.parameter.keySet();
    }

    public String get(String key) {
        return this.parameter.get(key);
    }

    public String get(String key, String defaultValue) {
        String s = this.parameter.get(key);
        return s == null ? defaultValue : s;
    }

    public int getInt(String key, int defaultValue) {
        String s = this.parameter.get(key);
        return s == null ? defaultValue : CastUtil.cint(s);
    }

    public String get2(String key) {
        return this.parameter2.get(key);
    }

    public void put(String key, String value) {
        this.parameter.put(key, value);
    }

    public String[] toStringArray() {
        ArrayList<String> arr = new ArrayList<String>();
        for (String key : this.parameter.keySet()) {
            String value1 = this.parameter.get(key);
            String value2 = this.parameter2.get(key);
            arr.add(key);
            this.add(arr, value1);
            this.add(arr, value2);
        }
        return arr.toArray(new String[arr.size()]);
    }

    private void add(List<String> arr, String value) {
        if (value != null) {
            if (value.length() == 0 || value.indexOf(32) >= 0) {
                arr.add("\"" + value + "\"");
            } else {
                arr.add(value);
            }
        }
    }
}

