/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.netio.request.handle;

import java.io.File;
import java.io.FileFilter;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import javax.management.MBeanServer;
import scouter.agent.netio.request.anotation.RequestHandler;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.SystemUtil;

public class AgentHeapDump {
    private String folderName = "heapdump";
    private String fileExt = ".hprof";
    private long lastCallTime = 0L;

    @RequestHandler(value="OBJECT_CALL_HEAP_DUMP")
    public Pack callHeapDump(Pack param) {
        File hprofFile;
        long curTime = System.currentTimeMillis();
        if (curTime - this.lastCallTime < 10000L) {
            MapPack p = new MapPack();
            p.put("success", new BooleanValue(false));
            p.put("msg", "please wait 10 sec. from last request...");
            return p;
        }
        this.lastCallTime = curTime;
        long time = ((MapPack)param).getLong("time");
        String yyyymmdd = DateUtil.yyyymmdd(time);
        String hhmmss = FormatUtil.print(new Date(time), "HHmmss");
        String fName = yyyymmdd + "-" + hhmmss + ((MapPack)param).getText("fName").replaceAll("/", "_") + this.fileExt;
        File hprofDir = new File(this.folderName);
        if (!hprofDir.exists()) {
            hprofDir.mkdirs();
        }
        if ((hprofFile = new File(hprofDir, fName)).exists()) {
            hprofFile.delete();
        }
        if (SystemUtil.IS_JAVA_1_5) {
            MapPack p = new MapPack();
            p.put("success", new BooleanValue(false));
            p.put("msg", "dumpHeap only works on a Sun Java 1.6+ VM");
            return p;
        }
        String error = this.dumpHeap(this.folderName + "/" + fName);
        if (error == null) {
            MapPack p = new MapPack();
            p.put("success", new BooleanValue(true));
            p.put("msg", "Successfully request heap dump...");
            return p;
        }
        MapPack p = new MapPack();
        p.put("success", new BooleanValue(false));
        p.put("msg", error);
        return p;
    }

    public String dumpHeap(String fileName) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
        }
        catch (ClassNotFoundException e) {
            return "ERROR: dumpHeap only works on a Sun Java 1.6+ VM containing the class com.sun.management.HotSpotDiagnosticMXBean";
        }
        Object hotspotMBean = null;
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
        }
        catch (Throwable e) {
            return "ERROR: dumpHeap was unable to obtain the HotSpotDiagnosticMXBean: " + e.getMessage();
        }
        try {
            Method method = hotspotMBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
            method.invoke(hotspotMBean, fileName, true);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause() != null ? e.getCause() : e;
            return "ERROR: dumpHeap threw a InvocationTargetException: " + t;
        }
        catch (Throwable e) {
            return "ERROR: dumpHeap threw a Throwable: " + e;
        }
        return null;
    }

    @RequestHandler(value="OBJECT_DELETE_HEAP_DUMP")
    public Pack deleteHeapDump(Pack param) {
        File delFile = new File(this.folderName + "/" + ((MapPack)param).getText("delfileName"));
        if (!delFile.exists()) {
            MapPack p = new MapPack();
            p.put("success", new BooleanValue(false));
            p.put("msg", "file '" + delFile.getName() + "' is not exist...");
            return p;
        }
        delFile.delete();
        MapPack p = new MapPack();
        p.put("success", new BooleanValue(true));
        p.put("msg", "Successfully deleted...");
        return p;
    }

    @RequestHandler(value="OBJECT_LIST_HEAP_DUMP")
    public Pack listHeapDump(Pack param) {
        MapPack p = new MapPack();
        ListValue nameLv = p.newList("name");
        ListValue sizeLv = p.newList("size");
        File hprofDir = new File(this.folderName);
        if (!hprofDir.exists()) {
            return null;
        }
        File[] fileList = hprofDir.listFiles(new ContentFilter());
        if (fileList != null && fileList.length > 0) {
            for (int i = 0; i < fileList.length; ++i) {
                File f = fileList[i];
                if (!f.getName().endsWith(this.fileExt)) continue;
                nameLv.add(f.getName());
                sizeLv.add(f.length());
            }
            return p;
        }
        return p;
    }

    @RequestHandler(value="OBJECT_DOWNLOAD_HEAP_DUMP")
    public Pack downloadHeapDump(Pack param, DataInputX in, DataOutputX out) {
        int buff = 0x200000;
        File downloadFile = new File(this.folderName + "/" + ((MapPack)param).getText("fileName"));
        try {
            RandomAccessFile raf = new RandomAccessFile(downloadFile, "r");
            byte[] buffer = new byte[buff];
            int read = 0;
            long offset = downloadFile.length();
            while ((long)read < offset) {
                int unitsize = (int)(offset - (long)read >= (long)buff ? (long)buff : offset - (long)read);
                raf.read(buffer, 0, unitsize);
                out.writeByte(3);
                out.writeBlob(buffer, 0, unitsize);
                read += unitsize;
            }
            raf.close();
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public class ContentFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return file.isFile() || !file.getName().startsWith(".");
        }
    }
}

