/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.FloatEnumer;
import scouter.util.LongEnumer;

public class LongFloatLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LongFloatLinkedEntry[] table;
    private LongFloatLinkedEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;
    private int max;

    public LongFloatLinkedMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public LongFloatLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LongFloatLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new LongFloatLinkedEntry(0L, 0.0f, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LongFloatLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public long[] keyArray() {
        long[] _keys = new long[this.size()];
        LongEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextLong();
        }
        return _keys;
    }

    public synchronized LongEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized FloatEnumer values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<LongFloatLinkedEntry> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(float value) {
        LongFloatLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            LongFloatLinkedEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(Float.valueOf(e.value), Float.valueOf(value))) {
                    return true;
                }
                e = e.hash_next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(long key) {
        LongFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.hash_next;
        }
        return false;
    }

    public synchronized float get(long key) {
        LongFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized long getFirstKey() {
        return this.header.link_next.key;
    }

    public synchronized long getLastKey() {
        return this.header.link_prev.key;
    }

    public synchronized float getFirstValue() {
        return this.header.link_next.value;
    }

    public synchronized float getLastValue() {
        return this.header.link_prev.value;
    }

    private int hash(long key) {
        return (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LongFloatLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LongFloatLinkedEntry[] newMap = new LongFloatLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LongFloatLinkedEntry old = oldMap[i];
            while (old != null) {
                LongFloatLinkedEntry e = old;
                old = old.hash_next;
                long key = e.key;
                int index = this.hash(key) % newCapacity;
                e.hash_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public LongFloatLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public float put(long key, float value) {
        return this._put(key, value, MODE.LAST);
    }

    public float putLast(long key, float value) {
        return this._put(key, value, MODE.FORCE_LAST);
    }

    public float putFirst(long key, float value) {
        return this._put(key, value, MODE.FORCE_FIRST);
    }

    private synchronized float _put(long key, float value, MODE m) {
        LongFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                float old = e.value;
                e.value = value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    while (this.count >= this.max) {
                        long k = this.header.link_prev.key;
                        float v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    while (this.count >= this.max) {
                        long k = this.header.link_next.key;
                        float v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new LongFloatLinkedEntry(key, value, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    protected void overflowed(long key, float value) {
    }

    public synchronized float remove(long key) {
        LongFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongFloatLinkedEntry e = tab[index];
        LongFloatLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.hash_next = e.hash_next;
                } else {
                    tab[index] = e.hash_next;
                }
                --this.count;
                float oldValue = e.value;
                e.value = this.NONE;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized float removeFirst() {
        if (this.isEmpty()) {
            return 0.0f;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized float removeLast() {
        if (this.isEmpty()) {
            return 0.0f;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        LongFloatLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header;
        this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongFloatLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            LongFloatLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongFloatLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            LongFloatLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(LongFloatLinkedEntry link_prev, LongFloatLinkedEntry link_next, LongFloatLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(LongFloatLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    public static class LongFloatLinkedEntry {
        long key;
        float value;
        LongFloatLinkedEntry hash_next;
        LongFloatLinkedEntry link_next;
        LongFloatLinkedEntry link_prev;

        protected LongFloatLinkedEntry(long key, float value, LongFloatLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.hash_next = next;
        }

        protected Object clone() {
            return new LongFloatLinkedEntry(this.key, this.value, this.hash_next == null ? null : (LongFloatLinkedEntry)this.hash_next.clone());
        }

        public long getKey() {
            return this.key;
        }

        public float getValue() {
            return this.value;
        }

        public float setValue(float value) {
            float oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LongFloatLinkedEntry)) {
                return false;
            }
            LongFloatLinkedEntry e = (LongFloatLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(Float.valueOf(e.value), Float.valueOf(this.value));
        }

        public int hashCode() {
            int x = Float.floatToIntBits(this.value);
            return x;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class Enumer<V>
    implements Enumeration,
    FloatEnumer,
    LongEnumer {
        TYPE type;
        LongFloatLinkedEntry entry;

        Enumer(TYPE type) {
            this.entry = ((LongFloatLinkedMap)LongFloatLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entry != null && LongFloatLinkedMap.this.header != this.entry;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                LongFloatLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return Float.valueOf(e.value);
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public float nextFloat() {
            if (this.hasMoreElements()) {
                LongFloatLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case VALUES: {
                        return e.value;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public long nextLong() {
            if (this.hasMoreElements()) {
                LongFloatLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

