/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import scouter.agent.Configure;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.trace.IProfileCollector;
import scouter.agent.trace.TraceContext;
import scouter.lang.step.DumpStep;
import scouter.lang.step.Step;
import scouter.lang.step.StepSingle;

public class ProfileCollector
implements IProfileCollector {
    private Configure conf = Configure.getInstance();
    private TraceContext context;
    protected Step[] steps;
    protected int pos;
    private boolean doingDumpStepJob;
    public int currentLevel;
    public int parentLevel;

    public ProfileCollector(TraceContext context) {
        this.steps = new Step[this.conf.profile_step_max_count];
        this.pos = 0;
        this.doingDumpStepJob = false;
        this.currentLevel = 0;
        this.parentLevel = -1;
        this.context = context;
    }

    @Override
    public void push(StepSingle stepSingle) {
        this.checkDumpStep();
        stepSingle.index = this.currentLevel;
        stepSingle.parent = this.parentLevel;
        this.parentLevel = this.currentLevel++;
    }

    protected void process(StepSingle stepSingle) {
        this.checkDumpStep();
        this.steps[this.pos++] = stepSingle;
        if (this.pos >= this.steps.length) {
            Step[] o = this.steps;
            this.steps = new Step[this.conf.profile_step_max_count];
            this.pos = 0;
            DataProxy.sendProfile(o, this.context);
        }
    }

    @Override
    public void add(StepSingle stepSingle) {
        this.checkDumpStep();
        stepSingle.index = this.currentLevel++;
        stepSingle.parent = this.parentLevel;
        this.process(stepSingle);
    }

    @Override
    public void pop(StepSingle stepSingle) {
        this.checkDumpStep();
        this.parentLevel = stepSingle.parent;
        this.process(stepSingle);
    }

    @Override
    public void close(boolean ok) {
        this.checkDumpStep();
        if (ok && this.pos > 0) {
            Step[] newSteps = new StepSingle[this.pos];
            System.arraycopy(this.steps, 0, newSteps, 0, this.pos);
            DataProxy.sendProfile(newSteps, this.context);
        }
    }

    private void checkDumpStep() {
        DumpStep dumpStep;
        if (this.doingDumpStepJob) {
            return;
        }
        this.doingDumpStepJob = true;
        while ((dumpStep = this.context.temporaryDumpSteps.poll()) != null) {
            this.add(dumpStep);
        }
        this.doingDumpStepJob = false;
    }
}

