/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import scouter.Version;
import scouter.agent.Logger;
import scouter.agent.ObjTypeDetector;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.util.JarUtil;
import scouter.lang.conf.ConfObserver;
import scouter.lang.conf.ConfigDesc;
import scouter.lang.conf.ConfigValueType;
import scouter.lang.conf.ConfigValueUtil;
import scouter.lang.conf.ValueType;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.HashUtil;
import scouter.util.StringEnumer;
import scouter.util.StringKeyLinkedMap;
import scouter.util.StringSet;
import scouter.util.StringUtil;
import scouter.util.SysJMX;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

public class Configure
extends Thread {
    public static boolean JDBC_REDEFINED = false;
    private static final Configure instance;
    private long last_load_time = -1L;
    public Properties property = new Properties();
    private boolean running = true;
    private File propertyFile;
    long last_check = 0L;
    public static String agent_dir_path;
    @ConfigDesc(value="UDP local IP")
    public String net_local_udp_ip = null;
    @ConfigDesc(value="UDP local Port")
    public int net_local_udp_port;
    @ConfigDesc(value="Collector IP")
    public String net_collector_ip = "127.0.0.1";
    @ConfigDesc(value="Collector UDP Port")
    public int net_collector_udp_port = 6100;
    @ConfigDesc(value="Collector TCP Port")
    public int net_collector_tcp_port = 6100;
    @ConfigDesc(value="Collector TCP Session Count")
    public int net_collector_tcp_session_count = 1;
    @ConfigDesc(value="Collector TCP Socket Timeout(ms)")
    public int net_collector_tcp_so_timeout_ms = 60000;
    @ConfigDesc(value="Collector TCP Connection Timeout(ms)")
    public int net_collector_tcp_connection_timeout_ms = 3000;
    @ConfigDesc(value="UDP Buffer Size")
    public int net_udp_packet_max_bytes = 60000;
    @ConfigDesc(value="UDP Collection Interval(ms)")
    public long net_udp_collection_interval_ms = 100L;
    @ConfigDesc(value="Deprecated. It's just an alias of monitoring_group_type which overrides this value.")
    public String obj_type = "";
    @ConfigDesc(value="monitoring group type, commonly named as system name and a monitoring type.\neg) ORDER-JVM, WAREHOUSE-LINUX ...")
    public String monitoring_group_type = "";
    @ConfigDesc(value="Object Name")
    public String obj_name = "";
    @ConfigDesc(value="Host Type")
    public String obj_host_type = "";
    @ConfigDesc(value="Host Name")
    public String obj_host_name = "";
    @ConfigDesc(value="Activating for using object name as PID")
    public boolean obj_name_auto_pid_enabled = false;
    @ConfigDesc(value="Redefining DS, RP type according to main object")
    public boolean obj_type_inherit_to_child_enabled = false;
    @ConfigDesc(value="Activating collect sub counters using JMX")
    public boolean jmx_counter_enabled = true;
    @ConfigDesc(value="Http Query String profile")
    public boolean profile_http_querystring_enabled;
    @ConfigDesc(value="Http Header profile")
    public boolean profile_http_header_enabled;
    @ConfigDesc(value="Service URL prefix for Http header profile")
    public String profile_http_header_url_prefix = "/";
    @ConfigDesc(value="http header names for profiling with comma separator")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String profile_http_header_keys = "";
    @ConfigDesc(value="Http Parameter profile")
    public boolean profile_http_parameter_enabled;
    @ConfigDesc(value="Service URL prefix for Http parameter profile")
    public String profile_http_parameter_url_prefix = "/";
    @ConfigDesc(value="spring controller method parameter profile")
    public boolean profile_spring_controller_method_parameter_enabled = true;
    @ConfigDesc(value="Profiling the memory usage of each method")
    public boolean profile_thread_cputime_enabled = false;
    @ConfigDesc(value="Profiling the memory usage of each service")
    public boolean profile_thread_memory_usage_enabled = true;
    @ConfigDesc(value="ThreadStack profile for open socket")
    public boolean profile_socket_open_fullstack_enabled = false;
    @ConfigDesc(value="ThreadStack profile for a certain port of open socket")
    public int profile_socket_open_fullstack_port = 0;
    @ConfigDesc(value="SQL Map profile")
    public boolean profile_sqlmap_name_enabled = true;
    @ConfigDesc(value="DBConnection profile")
    public boolean profile_connection_open_enabled = true;
    @ConfigDesc(value="Activating stack information profile in opening DB connection")
    public boolean profile_connection_open_fullstack_enabled = false;
    @ConfigDesc(value="AutoCommit profile")
    public boolean profile_connection_autocommit_status_enabled = false;
    @ConfigDesc(value="Method profile")
    public boolean profile_method_enabled = true;
    @ConfigDesc(value="Profile Buffer Size")
    public int profile_step_max_count = 1024;
    @ConfigDesc(value="Stack profile in occurrence of service error")
    public boolean profile_fullstack_service_error_enabled = false;
    @ConfigDesc(value="Stack profile in occurrence of apicall error")
    public boolean profile_fullstack_apicall_error_enabled = false;
    @ConfigDesc(value="Stack profile in occurrence of sql error")
    public boolean profile_fullstack_sql_error_enabled = false;
    @ConfigDesc(value="Stack profile in occurrence of commit error")
    public boolean profile_fullstack_sql_commit_enabled = false;
    @ConfigDesc(value="Stack profile in occurrence of sql error")
    public boolean profile_fullstack_hooked_exception_enabled = false;
    @ConfigDesc(value="Stack profile in occurrence of redis error")
    public boolean profile_fullstack_redis_error_enabled = false;
    @ConfigDesc(value="make unknown redis key stringify by force. (using new String(byte[])")
    public boolean profile_redis_key_forcibly_stringify_enabled = false;
    @ConfigDesc(value="Number of stack profile lines in occurrence of error")
    public int profile_fullstack_max_lines = 0;
    @ConfigDesc(value="Escaping literal parameters for normalizing the query")
    public boolean profile_sql_escape_enabled = true;
    @ConfigDesc(value="")
    public boolean _profile_fullstack_sql_connection_enabled = false;
    @ConfigDesc(value="")
    public boolean _profile_fullstack_sql_execute_debug_enabled = false;
    @ConfigDesc(value="")
    public boolean profile_fullstack_rs_leak_enabled = false;
    @ConfigDesc(value="")
    public boolean profile_fullstack_stmt_leak_enabled = false;
    @ConfigDesc(value="User ID based(0 : Remote Address, 1 : Cookie, 2 : Scouter Cookie, 2 : Header) \n - able to set value for 1.Cookie and 3.Header \n - refer to 'trace_user_session_key'")
    public int trace_user_mode = 2;
    @ConfigDesc(value="Setting a cookie path for SCOUTER cookie when trace_user_mode is 2")
    public String trace_user_cookie_path = "/";
    @ConfigDesc(value="Tracing background thread socket")
    public boolean trace_background_socket_enabled = true;
    @ConfigDesc(value="Adding assigned header value to the service name")
    public String trace_service_name_header_key;
    @ConfigDesc(value="Adding assigned get parameter to the service name")
    public String trace_service_name_get_key;
    @ConfigDesc(value="Adding assigned post parameter to the service name")
    public String trace_service_name_post_key;
    @ConfigDesc(value="Active Thread Warning Time(ms)")
    public long trace_activeserivce_yellow_time = 3000L;
    @ConfigDesc(value="Active Thread Fatal Time(ms)")
    public long trace_activeservice_red_time = 8000L;
    @ConfigDesc(value="Identifying header key of Remote IP")
    public String trace_http_client_ip_header_key = "";
    @ConfigDesc(value="Activating gxid connection in HttpTransfer")
    public boolean trace_interservice_enabled = true;
    @ConfigDesc(value="")
    public String _trace_interservice_gxid_header_key = "X-Scouter-Gxid";
    @ConfigDesc(value="")
    public boolean trace_response_gxid_enabled = false;
    @ConfigDesc(value="")
    public String _trace_interservice_callee_header_key = "X-Scouter-Callee";
    @ConfigDesc(value="")
    public String _trace_interservice_caller_header_key = "X-Scouter-Caller";
    @ConfigDesc(value="")
    public String _trace_interservice_caller_obj_header_key = "X-Scouter-Caller-Obj";
    @ConfigDesc(value="")
    public String _trace_interservice_callee_obj_header_key = "X-Scouter-Callee-Obj";
    @ConfigDesc(value="JSession key for user ID")
    public String trace_user_session_key = "JSESSIONID";
    @ConfigDesc(value="")
    public boolean _trace_auto_service_enabled = false;
    @ConfigDesc(value="")
    public boolean _trace_auto_service_backstack_enabled = true;
    @ConfigDesc(value="Activating trace DB2")
    public boolean trace_db2_enabled = true;
    @Deprecated
    @ConfigDesc(value="Deprecated!")
    public boolean trace_webserver_enabled = false;
    @Deprecated
    @ConfigDesc(value="Deprecated!")
    public String trace_webserver_name_header_key = "X-Forwarded-Host";
    @Deprecated
    @ConfigDesc(value="Deprecated!")
    public String trace_webserver_time_header_key = "X-Forwarded-Time";
    @ConfigDesc(value="measure queuing time from load balancer, reverse proxy, web server...\n if set, you can open Queuing Time view.")
    public boolean trace_request_queuing_enabled = false;
    @ConfigDesc(value="the name of server that set request start time")
    public String trace_request_queuing_start_host_header = "X-Request-Start-Host";
    @ConfigDesc(value="set request start time.\n - time format : t=microsecond (or) ts=second.milli")
    public String trace_request_queuing_start_time_header = "X-Request-Start-Time";
    @ConfigDesc(value="the name of server that set the trace_request_queuing_start_2nd_time_header")
    public String trace_request_queuing_start_2nd_host_header = "X-Request-Start-2nd-Host";
    @ConfigDesc(value="set request passing time measured by 2nd layered server.\n - time format : t=microsecond (or) ts=second.milli")
    public String trace_request_queuing_start_2nd_time_header = "X-Request-Start-2nd-Time";
    @ConfigDesc(value="")
    public int _trace_fullstack_socket_open_port = 0;
    @ConfigDesc(value="")
    public int _trace_sql_parameter_max_count = 128;
    @ConfigDesc(value="max length of bound sql parameter on profile view(< 500)")
    public int trace_sql_parameter_max_length = 20;
    @ConfigDesc(value="")
    public String trace_delayed_service_mgr_filename = "setting_delayed_service.properties";
    @ConfigDesc(value="")
    public boolean trace_rs_leak_enabled = false;
    @ConfigDesc(value="")
    public boolean trace_stmt_leak_enabled = false;
    @ConfigDesc(value="Plugin directory")
    public File plugin_dir = new File(agent_dir_path + "/plugin");
    @ConfigDesc(value="Dump directory")
    public File dump_dir = new File(agent_dir_path + "/dump");
    @ConfigDesc(value="")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String mgr_static_content_extensions = "js, htm, html, gif, png, jpg, css";
    @ConfigDesc(value="")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String mgr_log_ignore_ids = "";
    @ConfigDesc(value="Activating auto dump - append dumps onto the dump file in dump directory.")
    public boolean autodump_enabled = false;
    @ConfigDesc(value="Auto dump trigger point (dump when exceeding this active service count)")
    public int autodump_trigger_active_service_cnt = 10000;
    @ConfigDesc(value="Minimum interval(ms) for operating auto dump function - hard min : 5000")
    public long autodump_interval_ms = 30000L;
    @ConfigDesc(value="Auto dump level (1 : ThreadDump, 2 : active service, 3 : thread list)")
    public int autodump_level = 1;
    @ConfigDesc(value="Dump when a thread are running over this time - 0 is disabled")
    public int autodump_stuck_thread_ms = 0;
    @ConfigDesc(value="")
    public int autodump_stuck_check_interval_ms = 10000;
    @ConfigDesc(value="Enable the function to generate dump file when this process cpu is over than the set threshold")
    public boolean autodump_cpu_exceeded_enabled = false;
    @ConfigDesc(value="Threshold of cpu to generate dump file")
    public int autodump_cpu_exceeded_threshold_pct = 90;
    @ConfigDesc(value="Threshold of over-cpu-threshold duration")
    public int autodump_cpu_exceeded_duration_ms = 30000;
    @ConfigDesc(value="Dump file generation interval")
    public int autodump_cpu_exceeded_dump_interval_ms = 3000;
    @ConfigDesc(value="value of how many dump is generated.")
    public int autodump_cpu_exceeded_dump_cnt = 3;
    @Deprecated
    @ConfigDesc(value="(deprecated) XLog Ignore Time\n - for backward compatibility. Use xlog_sampling_xxx options instead")
    public int xlog_lower_bound_time_ms = 0;
    @ConfigDesc(value="Leave an error message at XLog in case of over fetching. (fetch count)")
    public int xlog_error_jdbc_fetch_max = 10000;
    @ConfigDesc(value="Leave an error message at XLog in case of over timing query. (ms)")
    public int xlog_error_sql_time_max_ms = 30000;
    @ConfigDesc(value="Leave an error message at XLog when UserTransaction's begin/end unpaired")
    public boolean xlog_error_check_user_transaction_enabled = true;
    @ConfigDesc(value="mark as error on xlog flag if SqlException is occured.")
    public boolean xlog_error_on_sqlexception_enabled = true;
    @ConfigDesc(value="mark as error on xlog flag if Api call errors are occured.")
    public boolean xlog_error_on_apicall_exception_enabled = true;
    @ConfigDesc(value="mark as error on xlog flag if redis error is occured.")
    public boolean xlog_error_on_redis_exception_enabled = true;
    @ConfigDesc(value="XLog hard sampling mode enabled\n - for the best performance but it affects all statistics data")
    public boolean _xlog_hard_sampling_enabled = false;
    @ConfigDesc(value="XLog hard sampling rate(%) - discard data over the percentage")
    public int _xlog_hard_sampling_rate_pct = 10;
    @ConfigDesc(value="XLog sampling mode enabled")
    public boolean xlog_sampling_enabled = false;
    @ConfigDesc(value="XLog sampling but discard profile only not XLog.")
    public boolean xlog_sampling_only_profile = false;
    @ConfigDesc(value="XLog sampling bound millisecond - step1(lowest : range - from 0 to here)")
    public int xlog_sampling_step1_ms = 100;
    @ConfigDesc(value="XLog sampling step1 percentage(%)")
    public int xlog_sampling_step1_rate_pct = 3;
    @ConfigDesc(value="XLog sampling bound millisecond - step2(range - from step1 to here)")
    public int xlog_sampling_step2_ms = 1000;
    @ConfigDesc(value="XLog sampling step2 percentage(%)")
    public int xlog_sampling_step2_rate_pct = 10;
    @ConfigDesc(value="XLog sampling bound millisecond - step3(highest : range - from step2 to here)")
    public int xlog_sampling_step3_ms = 3000;
    @ConfigDesc(value="XLog sampling step3 percentage(%)")
    public int xlog_sampling_step3_rate_pct = 30;
    @ConfigDesc(value="XLog sampling over step3 percentage(%)")
    public int xlog_sampling_over_rate_pct = 100;
    @ConfigDesc(value="XLog patterned sampling mode enabled")
    public boolean xlog_patterned_sampling_enabled = false;
    @ConfigDesc(value="XLog patterned sampling service patterns\neg) /user/{userId}<GET>,/device/*")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String xlog_patterned_sampling_service_patterns = "";
    @ConfigDesc(value="XLog patterned sampling but discard profile only not XLog.")
    public boolean xlog_patterned_sampling_only_profile = false;
    @ConfigDesc(value="XLog patterned sampling bound millisecond - step1(lowest : range - from 0 to here)")
    public int xlog_patterned_sampling_step1_ms = 100;
    @ConfigDesc(value="XLog patterned sampling step1 percentage(%)")
    public int xlog_patterned_sampling_step1_rate_pct = 3;
    @ConfigDesc(value="XLog patterned sampling bound millisecond - step2(range - from step1 to here)")
    public int xlog_patterned_sampling_step2_ms = 1000;
    @ConfigDesc(value="XLog patterned sampling step2 percentage(%)")
    public int xlog_patterned_sampling_step2_rate_pct = 10;
    @ConfigDesc(value="XLog patterned sampling bound millisecond - step3(highest : range - from step2 to here)")
    public int xlog_patterned_sampling_step3_ms = 3000;
    @ConfigDesc(value="XLog patterned sampling step3 percentage(%)")
    public int xlog_patterned_sampling_step3_rate_pct = 30;
    @ConfigDesc(value="XLog patterned sampling over step3 percentage(%)")
    public int xlog_patterned_sampling_over_rate_pct = 100;
    @ConfigDesc(value="XLog discard service patterns\nNo XLog data, but apply to TPS and summary.\neg) /user/{userId}<GET>,/device/*")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String xlog_discard_service_patterns = "";
    @ConfigDesc(value="Do not discard error even if it's discard pattern.")
    public boolean xlog_discard_service_show_error = true;
    @ConfigDesc(value="XLog fully discard service patterns\nNo XLog data, No apply to TPS and summary.\neg) /user/{userId}<GET>,/device/*")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String xlog_fully_discard_service_patterns = "";
    @ConfigDesc(value="Limited length of alert message")
    public int alert_message_length = 3000;
    @ConfigDesc(value="Minimum interval(ms) in fetching the same alert")
    public long alert_send_interval_ms = 10000L;
    @ConfigDesc(value="PermGen usage for send alert")
    public int alert_perm_warning_pct = 90;
    @ConfigDesc(value="")
    public boolean _log_asm_enabled;
    @ConfigDesc(value="")
    public boolean _log_udp_xlog_enabled;
    @ConfigDesc(value="")
    public boolean _log_udp_object_enabled;
    @ConfigDesc(value="")
    public boolean _log_udp_counter_enabled;
    @ConfigDesc(value="")
    public boolean _log_datasource_lookup_enabled = true;
    @ConfigDesc(value="")
    public boolean _log_background_sql = false;
    @ConfigDesc(value="Log directory")
    public String log_dir = "";
    @ConfigDesc(value="Retaining log according to date")
    public boolean log_rotation_enabled = true;
    @ConfigDesc(value="Keeping period of log")
    public int log_keep_days = 7;
    @ConfigDesc(value="")
    public boolean _trace = false;
    @ConfigDesc(value="")
    public boolean _trace_use_logger = false;
    @ConfigDesc(value="Method set for argument hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_args_patterns = "";
    @ConfigDesc(value="Method set for return hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_return_patterns = "";
    @ConfigDesc(value="Method set for constructor hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_constructor_patterns = "";
    @ConfigDesc(value="Method set for dbconnection hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_connection_open_patterns = "";
    @ConfigDesc(value="Method set for getconnection hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_get_connection_patterns = "";
    @ConfigDesc(value="IntialContext Class Set")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_context_classes = "javax/naming/InitialContext";
    @ConfigDesc(value="Method set for method hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_method_patterns = "";
    @ConfigDesc(value="Prefix without Method hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_method_ignore_prefixes = "get,set";
    @ConfigDesc(value="Class set without Method hookingt")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_method_ignore_classes = "";
    @ConfigDesc(value="")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_method_exclude_patterns = "";
    @ConfigDesc(value="Activating public Method hooking")
    public boolean hook_method_access_public_enabled = true;
    @ConfigDesc(value="Activating private Method hooking")
    public boolean hook_method_access_private_enabled = false;
    @ConfigDesc(value="Activating protected Method hooking")
    public boolean hook_method_access_protected_enabled = false;
    @ConfigDesc(value="Activating none Method hooking")
    public boolean hook_method_access_none_enabled = false;
    @ConfigDesc(value="Activating lambda Method hooking")
    public boolean hook_method_lambda_enable = true;
    @ConfigDesc(value="Method set for service hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_service_patterns = "";
    @ConfigDesc(value="hooking service name use a 1st string parameter or class & method name")
    public boolean hook_service_name_use_1st_string_enabled = true;
    @ConfigDesc(value="Method set for apicall hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_apicall_patterns = "";
    @ConfigDesc(value="Method set for apicallinfo hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_apicall_info_patterns = "";
    @ConfigDesc(value="Method set for jsp hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_jsp_patterns = "";
    @ConfigDesc(value="Method set for preparestatement hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_jdbc_pstmt_classes = "";
    @ConfigDesc(value="Method set for statement hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_jdbc_stmt_classes = "";
    @ConfigDesc(value="Method set for resultset hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_jdbc_rs_classes = "";
    @ConfigDesc(value="Method set for dbconnection wrapping")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_jdbc_wrapping_driver_patterns = "";
    @ConfigDesc(value="Exception class patterns - These will seem as error on xlog view.\n (ex) my.app.BizException,my.app.exception.*Exception")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_exception_class_patterns = "";
    @ConfigDesc(value="Exception class exclude patterns")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_exception_exclude_class_patterns = "";
    @ConfigDesc(value="Exception handler patterns\n - exceptions passed to these methods are treated as error on xlog view.\n   (ex) my.app.myHandler.handleException")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_exception_handler_method_patterns = "";
    @ConfigDesc(value="Exception handler exclude class name patterns(can not include star-* in patterns)\n - (ex) my.app.MyManagedException,MyBizException")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_exception_handler_exclude_class_patterns = "";
    @ConfigDesc(value="Hook for supporting async servlet")
    public boolean hook_async_servlet_enabled = true;
    @ConfigDesc(value="startAsync impl. method patterns")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_async_servlet_start_patterns = "";
    @ConfigDesc(value="asyncContext dispatch impl. method patterns")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_async_context_dispatch_patterns = "";
    @ConfigDesc(value="spring async execution submit patterns")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_spring_async_submit_patterns = "";
    @ConfigDesc(value="spring async execution hook enabled")
    public boolean hook_spring_async_enabled = true;
    @Deprecated
    @ConfigDesc(value="Deprecated. use hook_async_callrunnable_enabled")
    public boolean hook_async_callrunnable_enable = true;
    @ConfigDesc(value="Hook callable and runnable for tracing async processing.\n It hook only 'hook_async_callrunnable_scan_prefixes' option contains pacakage or classes")
    public boolean hook_async_callrunnable_enabled = true;
    @ConfigDesc(value="scanning range prefixes for hooking callable, runnable implementations and lambda expressions.\n usually your application package.\n 2 or more packages can be separated by commas.")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_async_callrunnable_scan_package_prefixes = "";
    @ConfigDesc(value="redis key setting patterns.\n refer to org.springframework.data.redis.core.AbstractOperations#rawKey")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String _hook_redis_set_key_patterns = "";
    @ConfigDesc(value="hook threadpool executor for tracing async processing.")
    public boolean hook_async_thread_pool_executor_enabled = true;
    @ConfigDesc(value="Experimental! test it on staging environment of your system before enable this option.\n enable lambda expressioned class hook for detecting asyncronous processing. \nOnly classes under the package configured by 'hook_async_callrunnable_scan_package_prefixes' is hooked.")
    public boolean hook_lambda_instrumentation_strategy_enabled = false;
    @ConfigDesc(value="hystrix execution hook enabled")
    public boolean hook_hystrix_enabled = false;
    @ConfigDesc(value="")
    public String hook_add_fields = "";
    @ConfigDesc(value="")
    public boolean _hook_serivce_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_dbsql_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_dbconn_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_cap_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_methods_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_apicall_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_socket_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_jsp_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_async_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_usertx_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_spring_rest_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_redis_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_kafka_enabled = true;
    @ConfigDesc(value="")
    public boolean _hook_rabbit_enabled = true;
    @ConfigDesc(value="")
    public String _hook_direct_patch_classes = "";
    @ConfigDesc(value="")
    public String _hook_boot_prefix = null;
    @ConfigDesc(value="for warning a big Map type object that have a lot of entities.\n It may increase system load. be careful to enable this option.")
    public boolean _hook_map_impl_enabled = false;
    @ConfigDesc(value="")
    public int _hook_map_impl_warning_size = 50000;
    @ConfigDesc(value="Activating Reject service")
    public boolean control_reject_service_enabled = false;
    @ConfigDesc(value="Minimum count of rejecting active service")
    public int control_reject_service_max_count = 10000;
    @ConfigDesc(value="Activating Reject URL")
    public boolean control_reject_redirect_url_enabled = false;
    @ConfigDesc(value="Reject Text")
    public String control_reject_text = "too many request!!";
    @ConfigDesc(value="Reject URL")
    public String control_reject_redirect_url = "/error.html";
    @ConfigDesc(value="Activating collect counter")
    public boolean counter_enabled = true;
    @ConfigDesc(value="think time (ms) of recent user")
    public long counter_recentuser_valid_ms = 300000L;
    @ConfigDesc(value="Path to file creation directory of process ID file")
    public String counter_object_registry_path = "/tmp/scouter";
    @ConfigDesc(value="Activating custom jmx")
    public boolean counter_custom_jmx_enabled = false;
    @ConfigDesc(value="Activating interaction counter")
    public boolean counter_interaction_enabled = false;
    @ConfigDesc(value="Activating period threaddump function")
    public boolean sfa_dump_enabled = false;
    @ConfigDesc(value="SFA thread dump Interval(ms)")
    public int sfa_dump_interval_ms = 10000;
    @ConfigDesc(value="Activating periodical stacktrace step (write fixed interval thread dump on a profile)")
    public boolean _psts_enabled = false;
    @ConfigDesc(value="PSTS(periodical stacktrace step) thread dump Interval(ms) - hard min limit 2000")
    public int _psts_dump_interval_ms = 10000;
    @ConfigDesc(value="Activating summary function")
    public boolean summary_enabled = true;
    @ConfigDesc(value="")
    public boolean _summary_connection_leak_fullstack_enabled = false;
    @ConfigDesc(value="")
    public int _summary_service_max_count = 5000;
    @ConfigDesc(value="")
    public int _summary_sql_max_count = 5000;
    @ConfigDesc(value="")
    public int _summary_api_max_count = 5000;
    @ConfigDesc(value="")
    public int _summary_ip_max_count = 5000;
    @ConfigDesc(value="")
    public int _summary_useragent_max_count = 5000;
    @ConfigDesc(value="")
    public int _summary_error_max_count = 500;
    @ConfigDesc(value="")
    public int _summary_enduser_nav_max_count = 5000;
    @ConfigDesc(value="")
    public int _summary_enduser_ajax_max_count = 5000;
    @ConfigDesc(value="")
    public int _summary_enduser_error_max_count = 5000;
    @ConfigDesc(value="Path to jsp to collect enduser data")
    public String enduser_trace_endpoint_url = "/_scouter_browser.jsp";
    public boolean __experimental = false;
    public boolean __control_connection_leak_autoclose_enabled = false;
    public boolean __ip_dummy_test = false;
    public Set<String> _profile_http_header_keys = null;
    private String objExtType = "";
    private String objDetectedType = "";
    private int objHash;
    private String objName;
    private int objHostHash;
    private String objHostName;
    private Set<String> static_contents = new HashSet<String>();
    private StringSet log_ignore_set = new StringSet();
    private String[] _hook_method_ignore_prefix = null;
    private int _hook_method_ignore_prefix_len = 0;
    private int hook_signature;
    private StringSet _hook_method_ignore_classes = new StringSet();
    private int enduser_perf_endpoint_hash = HashUtil.hash(this.enduser_trace_endpoint_url);
    private StringSet custom_jmx_set = new StringSet();
    private static HashSet<String> ignoreSet;

    public static final Configure getInstance() {
        return instance;
    }

    private Configure() {
        Properties p = new Properties();
        HashMap<Object, Object> args = new HashMap<Object, Object>();
        args.putAll(System.getenv());
        args.putAll(System.getProperties());
        p.putAll((Map<?, ?>)args);
        this.property = p;
        this.reload(false);
    }

    private Configure(boolean b) {
    }

    @Override
    public void run() {
        Logger.println("Version " + Version.getAgentFullVersion());
        long dateUnit = DateUtil.getDateUnit();
        while (this.running) {
            this.reload(false);
            long nowUnit = DateUtil.getDateUnit();
            if (dateUnit != nowUnit) {
                dateUnit = nowUnit;
                DataProxy.reset();
            }
            ThreadUtil.sleep(3000L);
        }
    }

    public File getPropertyFile() {
        if (this.propertyFile != null) {
            return this.propertyFile;
        }
        String s = System.getProperty("scouter.config", agent_dir_path + "/conf/scouter.conf");
        this.propertyFile = new File(s.trim());
        return this.propertyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean reload(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now < this.last_check + 3000L) {
            return false;
        }
        this.last_check = now;
        File file = this.getPropertyFile();
        if (file.lastModified() == this.last_load_time) {
            return false;
        }
        this.last_load_time = file.lastModified();
        Properties temp = new Properties();
        if (file.canRead()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                temp.load(in);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.close(in);
                    throw throwable;
                }
                FileUtil.close(in);
            }
            FileUtil.close(in);
        }
        this.property = ConfigValueUtil.replaceSysProp(temp);
        this.apply();
        ConfObserver.run();
        return true;
    }

    private void apply() {
        this.profile_http_querystring_enabled = this.getBoolean("profile_http_querystring_enabled", false);
        this.profile_http_header_enabled = this.getBoolean("profile_http_header_enabled", false);
        this.profile_http_parameter_enabled = this.getBoolean("profile_http_parameter_enabled", false);
        this.profile_spring_controller_method_parameter_enabled = this.getBoolean("profile_spring_controller_method_parameter_enabled", true);
        this.profile_http_parameter_url_prefix = this.getValue("profile_http_parameter_url_prefix", "/");
        this.profile_http_header_url_prefix = this.getValue("profile_http_header_url_prefix", "/");
        this.profile_http_header_keys = this.getValue("profile_http_header_keys", "");
        this._profile_http_header_keys = StringUtil.splitAndTrimToSet(this.profile_http_header_keys, ',', true);
        this.xlog_lower_bound_time_ms = this.getInt("xlog_lower_bound_time_ms", 0);
        this.trace_service_name_header_key = this.getValue("trace_service_name_header_key", null);
        this.trace_service_name_get_key = this.getValue("trace_service_name_get_key");
        this.trace_service_name_post_key = this.getValue("trace_service_name_post_key");
        this.dump_dir = new File(this.getValue("dump_dir", agent_dir_path + "/dump"));
        try {
            this.dump_dir.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.plugin_dir = new File(this.getValue("plugin_dir", agent_dir_path + "/plugin"));
        this.autodump_enabled = this.getBoolean("autodump_enabled", false);
        this.autodump_trigger_active_service_cnt = this.getInt("autodump_trigger_active_service_cnt", 10000);
        if (this.autodump_trigger_active_service_cnt < 1) {
            this.autodump_trigger_active_service_cnt = 1;
        }
        this.autodump_level = this.getInt("autodump_level", 1);
        this.autodump_interval_ms = this.getInt("autodump_interval_ms", 30000);
        if (this.autodump_interval_ms < 5000L) {
            this.autodump_interval_ms = 5000L;
        }
        this.autodump_stuck_thread_ms = this.getInt("autodump_stuck_thread_ms", 0);
        this.autodump_stuck_check_interval_ms = this.getInt("autodump_stuck_check_interval_ms", 10000);
        this.autodump_cpu_exceeded_enabled = this.getBoolean("autodump_cpu_exceeded_enabled", false);
        this.autodump_cpu_exceeded_threshold_pct = this.getInt("autodump_cpu_exceeded_threshold_pct", 90);
        this.autodump_cpu_exceeded_duration_ms = this.getInt("autodump_cpu_exceeded_duration_ms", 30000);
        this.autodump_cpu_exceeded_dump_interval_ms = this.getInt("autodump_cpu_exceeded_dump_interval_ms", 3000);
        this.autodump_cpu_exceeded_dump_cnt = this.getInt("autodump_cpu_exceeded_dump_cnt", 3);
        this.mgr_static_content_extensions = this.getValue("mgr_static_content_extensions", "js, htm, html, gif, png, jpg, css");
        this.profile_thread_cputime_enabled = this.getBoolean("profile_thread_cputime_enabled", false);
        this.profile_thread_memory_usage_enabled = this.getBoolean("profile_thread_memory_usage_enabled", true);
        this.profile_socket_open_fullstack_enabled = this.getBoolean("profile_socket_open_fullstack_enabled", false);
        this.trace_background_socket_enabled = this.getBoolean("trace_background_socket_enabled", true);
        this.profile_socket_open_fullstack_port = this.getInt("profile_socket_open_fullstack_port", 0);
        this.profile_sql_escape_enabled = this.getBoolean("profile_sql_escape_enabled", true);
        this.profile_sqlmap_name_enabled = this.getBoolean("profile_sqlmap_name_enabled", true);
        this.net_udp_packet_max_bytes = this.getInt("net_udp_packet_max_bytes", 60000);
        this.trace_activeserivce_yellow_time = this.getLong("trace_activeserivce_yellow_time", 3000L);
        this.trace_activeservice_red_time = this.getLong("trace_activeservice_red_time", 8000L);
        this.mgr_log_ignore_ids = this.getValue("mgr_log_ignore_ids", "");
        this.log_ignore_set = this.getStringSet("mgr_log_ignore_ids", ",");
        this._log_udp_xlog_enabled = this.getBoolean("_log_udp_xlog_enabled", false);
        this._log_udp_counter_enabled = this.getBoolean("_log_udp_counter_enabled", false);
        this._log_udp_object_enabled = this.getBoolean("_log_udp_object_enabled", false);
        this.net_local_udp_ip = this.getValue("net_local_udp_ip");
        this.net_local_udp_port = this.getInt("net_local_udp_port", 0);
        this.net_collector_ip = this.getValue("net_collector_ip", "127.0.0.1");
        this.net_collector_udp_port = this.getInt("net_collector_udp_port", 6100);
        this.net_collector_tcp_port = this.getInt("net_collector_tcp_port", 6100);
        this.net_collector_tcp_session_count = this.getInt("net_collector_tcp_session_count", 1, 1);
        this.net_collector_tcp_connection_timeout_ms = this.getInt("net_collector_tcp_connection_timeout_ms", 3000);
        this.net_collector_tcp_so_timeout_ms = this.getInt("net_collector_tcp_so_timeout_ms", 60000);
        this.hook_signature = 0;
        this.hook_args_patterns = this.getValue("hook_args_patterns", "");
        this.hook_return_patterns = this.getValue("hook_return_patterns", "");
        this.hook_constructor_patterns = this.getValue("hook_constructor_patterns", "");
        this.hook_connection_open_patterns = this.getValue("hook_connection_open_patterns", "");
        this.hook_get_connection_patterns = this.getValue("hook_get_connection_patterns", "");
        this._log_datasource_lookup_enabled = this.getBoolean("_log_datasource_lookup_enabled", true);
        this.profile_connection_open_enabled = this.getBoolean("profile_connection_open_enabled", true);
        this._summary_connection_leak_fullstack_enabled = this.getBoolean("_summary_connection_leak_fullstack_enabled", false);
        this.hook_method_patterns = this.getValue("hook_method_patterns", "");
        this.hook_method_exclude_patterns = this.getValue("hook_method_exclude_patterns", "");
        this.hook_method_access_public_enabled = this.getBoolean("hook_method_access_public_enabled", true);
        this.hook_method_access_protected_enabled = this.getBoolean("hook_method_access_protected_enabled", false);
        this.hook_method_access_private_enabled = this.getBoolean("hook_method_access_private_enabled", false);
        this.hook_method_access_none_enabled = this.getBoolean("hook_method_access_none_enabled", false);
        this.hook_method_lambda_enable = this.getBoolean("hook_method_lambda_enable", true);
        this.hook_method_ignore_prefixes = StringUtil.removeWhitespace(this.getValue("hook_method_ignore_prefixes", "get,set"));
        this._hook_method_ignore_prefix = StringUtil.split(this.hook_method_ignore_prefixes, ",");
        this._hook_method_ignore_prefix_len = this._hook_method_ignore_prefix == null ? 0 : this._hook_method_ignore_prefix.length;
        this.hook_method_ignore_classes = StringUtil.trimEmpty(StringUtil.removeWhitespace(this.getValue("hook_method_ignore_classes", "")));
        this._hook_method_ignore_classes = new StringSet(StringUtil.tokenizer(this.hook_method_ignore_classes.replace('.', '/'), ","));
        this.profile_method_enabled = this.getBoolean("profile_method_enabled", true);
        this.hook_service_patterns = this.getValue("hook_service_patterns", "");
        this.hook_service_name_use_1st_string_enabled = this.getBoolean("hook_service_name_use_1st_string_enabled", true);
        this.hook_apicall_patterns = this.getValue("hook_apicall_patterns", "");
        this.hook_apicall_info_patterns = this.getValue("hook_apicall_info_patterns", "");
        this.hook_jsp_patterns = this.getValue("hook_jsp_patterns", "");
        this.hook_jdbc_pstmt_classes = this.getValue("hook_jdbc_pstmt_classes", "");
        this.hook_jdbc_stmt_classes = this.getValue("hook_jdbc_stmt_classes", "");
        this.hook_jdbc_rs_classes = this.getValue("hook_jdbc_rs_classes", "");
        this.hook_jdbc_wrapping_driver_patterns = this.getValue("hook_jdbc_wrapping_driver_patterns", "");
        this.hook_exception_class_patterns = this.getValue("hook_exception_class_patterns", "");
        this.hook_exception_exclude_class_patterns = this.getValue("hook_exception_exclude_class_patterns", "");
        if (StringUtil.isEmpty(this.hook_exception_exclude_class_patterns)) {
            this.hook_exception_exclude_class_patterns = this.getValue("hook_exception_exlude_class_patterns", "");
        }
        this.hook_exception_handler_method_patterns = this.getValue("hook_exception_handler_method_patterns", "");
        this.hook_exception_handler_exclude_class_patterns = this.getValue("hook_exception_handler_exclude_class_patterns", "");
        if (StringUtil.isEmpty(this.hook_exception_handler_exclude_class_patterns)) {
            this.hook_exception_handler_exclude_class_patterns = this.getValue("hook_exception_hanlder_exclude_class_patterns", "");
        }
        this.hook_async_servlet_enabled = this.getBoolean("_hook_async_servlet_enabled", true);
        this.hook_async_context_dispatch_patterns = this.getValue("hook_async_context_dispatch_patterns", "");
        this.hook_async_servlet_start_patterns = this.getValue("hook_async_servlet_start_patterns", "");
        this.hook_spring_async_submit_patterns = this.getValue("hook_spring_async_submit_patterns", "");
        this.hook_spring_async_enabled = this.getBoolean("hook_spring_async_enabled", true);
        this.hook_async_callrunnable_enable = this.getBoolean("hook_async_callrunnable_enable", true);
        this.hook_async_callrunnable_enabled = StringUtil.isEmpty(this.getValue("hook_async_callrunnable_enabled", "")) ? this.hook_async_callrunnable_enable : this.getBoolean("hook_async_callrunnable_enabled", true);
        this.hook_async_callrunnable_scan_package_prefixes = this.getValue("hook_async_callrunnable_scan_package_prefixes", "");
        this._hook_redis_set_key_patterns = this.getValue("_hook_redis_set_key_patterns", "");
        this.hook_async_thread_pool_executor_enabled = this.getBoolean("hook_async_thread_pool_executor_enabled", true);
        this.hook_lambda_instrumentation_strategy_enabled = this.getBoolean("hook_lambda_instrumentation_strategy_enabled", false);
        this.hook_hystrix_enabled = this.getBoolean("hook_hystrix_enabled", true);
        this.hook_add_fields = this.getValue("hook_add_fields", "");
        this.hook_context_classes = this.getValue("hook_context_classes", "javax/naming/InitialContext");
        this.hook_signature ^= this.hook_args_patterns.hashCode();
        this.hook_signature ^= this.hook_return_patterns.hashCode();
        this.hook_signature ^= this.hook_constructor_patterns.hashCode();
        this.hook_signature ^= this.hook_connection_open_patterns.hashCode();
        this.hook_signature ^= this.hook_method_patterns.hashCode();
        this.hook_signature ^= this.hook_service_patterns.hashCode();
        this.hook_signature ^= this.hook_apicall_patterns.hashCode();
        this.hook_signature ^= this.hook_jsp_patterns.hashCode();
        this.hook_signature ^= this.hook_jdbc_wrapping_driver_patterns.hashCode();
        this.control_reject_service_enabled = this.getBoolean("control_reject_service_enabled", false);
        this.control_reject_service_max_count = this.getInt("control_reject_service_max_count", 10000);
        this.control_reject_redirect_url_enabled = this.getBoolean("control_reject_redirect_url_enabled", false);
        this.control_reject_text = this.getValue("control_reject_text", "too many request!!");
        this.control_reject_redirect_url = this.getValue("control_reject_redirect_url", "/error.html");
        this.profile_step_max_count = this.getInt("profile_step_max_count", 1024);
        if (this.profile_step_max_count < 100) {
            this.profile_step_max_count = 100;
        }
        this._log_background_sql = this.getBoolean("_log_background_sql", false);
        this.profile_fullstack_service_error_enabled = this.getBoolean("profile_fullstack_service_error_enabled", false);
        this.profile_fullstack_apicall_error_enabled = this.getBoolean("profile_fullstack_apicall_error_enabled", false);
        this.profile_fullstack_sql_error_enabled = this.getBoolean("profile_fullstack_sql_error_enabled", false);
        this.profile_fullstack_sql_commit_enabled = this.getBoolean("profile_fullstack_sql_commit_enabled", false);
        this.profile_fullstack_hooked_exception_enabled = this.getBoolean("profile_fullstack_hooked_exception_enabled", false);
        this.profile_fullstack_redis_error_enabled = this.getBoolean("profile_fullstack_redis_error_enabled", false);
        this.profile_redis_key_forcibly_stringify_enabled = this.getBoolean("profile_redis_key_forcibly_stringify_enabled", false);
        this.profile_fullstack_max_lines = this.getInt("profile_fullstack_max_lines", 0);
        this.profile_fullstack_rs_leak_enabled = this.getBoolean("profile_fullstack_rs_leak_enabled", false);
        this.profile_fullstack_stmt_leak_enabled = this.getBoolean("profile_fullstack_stmt_leak_enabled", false);
        this.net_udp_collection_interval_ms = this.getInt("net_udp_collection_interval_ms", 100);
        this.trace_http_client_ip_header_key = this.getValue("trace_http_client_ip_header_key", "");
        this.trace_interservice_enabled = this.getBoolean("trace_interservice_enabled", true);
        this.trace_response_gxid_enabled = this.getBoolean("trace_response_gxid_enabled", false);
        this._trace_interservice_gxid_header_key = this.getValue("_trace_interservice_gxid_header_key", "X-Scouter-Gxid");
        this._trace_interservice_callee_header_key = this.getValue("_trace_interservice_callee_header_key", "X-Scouter-Callee");
        this._trace_interservice_caller_header_key = this.getValue("_trace_interservice_caller_header_key", "X-Scouter-Caller");
        this._trace_interservice_caller_obj_header_key = this.getValue("_trace_interservice_caller_obj_header_key", "X-Scouter-Caller-Obj");
        this._trace_interservice_callee_obj_header_key = this.getValue("_trace_interservice_callee_obj_header_key", "X-Scouter-Callee-Obj");
        this.profile_connection_open_fullstack_enabled = this.getBoolean("profile_connection_open_fullstack_enabled", false);
        this.profile_connection_autocommit_status_enabled = this.getBoolean("profile_connection_autocommit_status_enabled", false);
        this.trace_user_mode = this.getInt("trace_user_mode", 2);
        this.trace_user_cookie_path = this.getValue("trace_user_cookie_path", "/");
        this.trace_user_session_key = this.getValue("trace_user_session_key", "JSESSIONID");
        this._trace_auto_service_enabled = this.getBoolean("_trace_auto_service_enabled", false);
        this._trace_auto_service_backstack_enabled = this.getBoolean("_trace_auto_service_backstack_enabled", true);
        this.counter_enabled = this.getBoolean("counter_enabled", true);
        this._hook_serivce_enabled = this.getBoolean("_hook_serivce_enabled", true);
        this._hook_dbsql_enabled = this.getBoolean("_hook_dbsql_enabled", true);
        this._hook_dbconn_enabled = this.getBoolean("_hook_dbconn_enabled", true);
        this._hook_cap_enabled = this.getBoolean("_hook_cap_enabled", true);
        this._hook_methods_enabled = this.getBoolean("_hook_methods_enabled", true);
        this._hook_apicall_enabled = this.getBoolean("_hook_apicall_enabled", true);
        this._hook_socket_enabled = this.getBoolean("_hook_socket_enabled", true);
        this._hook_jsp_enabled = this.getBoolean("_hook_jsp_enabled", true);
        this._hook_async_enabled = this.getBoolean("_hook_async_enabled", true);
        this.trace_db2_enabled = this.getBoolean("trace_db2_enabled", true);
        this._hook_usertx_enabled = this.getBoolean("_hook_usertx_enabled", true);
        this._hook_spring_rest_enabled = this.getBoolean("_hook_spring_rest_enabled", true);
        this._hook_redis_enabled = this.getBoolean("_hook_redis_enabled", true);
        this._hook_kafka_enabled = this.getBoolean("_hook_kafka_enabled", true);
        this._hook_rabbit_enabled = this.getBoolean("_hook_rabbit_enabled", true);
        this._hook_direct_patch_classes = this.getValue("_hook_direct_patch_classes", "");
        this._hook_boot_prefix = this.getValue("_hook_boot_prefix");
        this._hook_map_impl_enabled = this.getBoolean("_hook_map_impl_enabled", false);
        this._hook_map_impl_warning_size = this.getInt("_hook_map_impl_warning_size", 50000);
        this.counter_recentuser_valid_ms = this.getLong("counter_recentuser_valid_ms", 300000L);
        this.counter_object_registry_path = this.getValue("counter_object_registry_path", "/tmp/scouter");
        this.counter_custom_jmx_enabled = this.getBoolean("counter_custom_jmx_enabled", false);
        this.counter_interaction_enabled = this.getBoolean("counter_interaction_enabled", false);
        this.custom_jmx_set = this.getStringSet("custom_jmx_set", "||");
        this.sfa_dump_enabled = this.getBoolean("sfa_dump_enabled", false);
        this.sfa_dump_interval_ms = this.getInt("sfa_dump_interval_ms", 10000);
        this._psts_enabled = this.getBoolean("_psts_enabled", false);
        this._psts_dump_interval_ms = this.getInt("_psts_dump_interval_ms", 10000);
        this.trace_webserver_enabled = this.getBoolean("trace_webserver_enabled", false);
        this.trace_webserver_name_header_key = this.getValue("trace_webserver_name_header_key", "X-Forwarded-Host");
        this.trace_webserver_time_header_key = this.getValue("trace_webserver_time_header_key", "X-Forwarded-Time");
        this.trace_request_queuing_enabled = this.getBoolean("trace_request_queuing_enabled", false);
        this.trace_request_queuing_start_host_header = this.getValue("trace_request_queuing_start_host_header", "X-Request-Start-Host");
        this.trace_request_queuing_start_time_header = this.getValue("trace_request_queuing_start_time_header", "X-Request-Start-Time");
        this.trace_request_queuing_start_2nd_host_header = this.getValue("trace_request_queuing_start_2nd_host_header", "X-Request-Start-2nd-Host");
        this.trace_request_queuing_start_2nd_time_header = this.getValue("trace_request_queuing_start_2nd_time_header", "X-Request-Start-2nd-Time");
        this.trace_rs_leak_enabled = this.getBoolean("trace_rs_leak_enabled", false);
        this.trace_stmt_leak_enabled = this.getBoolean("trace_stmt_leak_enabled", false);
        this.trace_delayed_service_mgr_filename = this.getValue("trace_delayed_service_mgr_filename", "setting_delayed_service.properties");
        this.summary_enabled = this.getBoolean("summary_enabled", true);
        this._summary_sql_max_count = this.getInt("_summary_sql_max_count", 5000);
        this._summary_api_max_count = this.getInt("_summary_api_max_count", 5000);
        this._summary_service_max_count = this.getInt("_summary_service_max_count", 5000);
        this._summary_ip_max_count = this.getInt("_summary_ip_max_count", 5000);
        this._summary_useragent_max_count = this.getInt("_summary_useragent_max_count", 5000);
        this._summary_error_max_count = this.getInt("_summary_error_max_count", 500);
        this._summary_enduser_nav_max_count = this.getInt("_summary_enduser_nav_max_count", 5000);
        this._summary_enduser_ajax_max_count = this.getInt("_summary_enduser_ajax_max_count", 5000);
        this._summary_enduser_error_max_count = this.getInt("_summary_enduser_error_max_count", 5000);
        this.__experimental = this.getBoolean("__experimental", false);
        this.__control_connection_leak_autoclose_enabled = this.getBoolean("__control_connection_leak_autoclose_enabled", false);
        this.__ip_dummy_test = this.getBoolean("__ip_dummy_test", false);
        this.alert_perm_warning_pct = this.getInt("alert_perm_warning_pct", 90);
        this.alert_message_length = this.getInt("alert_message_length", 3000);
        this.alert_send_interval_ms = this.getInt("alert_send_interval_ms", 10000);
        this.xlog_error_jdbc_fetch_max = this.getInt("xlog_error_jdbc_fetch_max", 10000);
        this.xlog_error_sql_time_max_ms = this.getInt("xlog_error_sql_time_max_ms", 30000);
        this.xlog_error_on_sqlexception_enabled = this.getBoolean("xlog_error_on_sqlexception_enabled", true);
        this.xlog_error_on_apicall_exception_enabled = this.getBoolean("xlog_error_on_apicall_exception_enabled", true);
        this.xlog_error_on_redis_exception_enabled = this.getBoolean("xlog_error_on_redis_exception_enabled", true);
        this._log_asm_enabled = this.getBoolean("_log_asm_enabled", false);
        this.obj_type_inherit_to_child_enabled = this.getBoolean("obj_type_inherit_to_child_enabled", false);
        this.jmx_counter_enabled = this.getBoolean("jmx_counter_enabled", true);
        this._profile_fullstack_sql_connection_enabled = this.getBoolean("_profile_fullstack_sql_connection_enabled", false);
        this._profile_fullstack_sql_execute_debug_enabled = this.getBoolean("_profile_fullstack_sql_execute_debug_enabled", false);
        this._trace_fullstack_socket_open_port = this.getInt("_trace_fullstack_socket_open_port", 0);
        this._trace_sql_parameter_max_count = this.getInt("_trace_sql_parameter_max_count", 128);
        this.trace_sql_parameter_max_length = Math.min(this.getInt("trace_sql_parameter_max_length", 20), 500);
        this.log_dir = this.getValue("log_dir", "");
        this.log_rotation_enabled = this.getBoolean("log_rotation_enabled", true);
        this.log_keep_days = this.getInt("log_keep_days", 7);
        this._trace = this.getBoolean("_trace", false);
        this._trace_use_logger = this.getBoolean("_trace_use_logger", false);
        this.enduser_trace_endpoint_url = this.getValue("enduser_trace_endpoint_url", "_scouter_browser.jsp");
        this.enduser_perf_endpoint_hash = HashUtil.hash(this.enduser_trace_endpoint_url);
        this.xlog_error_check_user_transaction_enabled = this.getBoolean("xlog_error_check_user_transaction_enabled", true);
        this._xlog_hard_sampling_enabled = this.getBoolean("_xlog_hard_sampling_enabled", false);
        this._xlog_hard_sampling_rate_pct = this.getInt("_xlog_hard_sampling_rate_pct", 10);
        this.xlog_sampling_enabled = this.getBoolean("xlog_sampling_enabled", false);
        this.xlog_sampling_only_profile = this.getBoolean("xlog_sampling_only_profile", false);
        this.xlog_sampling_step1_ms = this.getInt("xlog_sampling_step1_ms", 100);
        this.xlog_sampling_step1_rate_pct = this.getInt("xlog_sampling_step1_rate_pct", 3);
        this.xlog_sampling_step2_ms = this.getInt("xlog_sampling_step2_ms", 1000);
        this.xlog_sampling_step2_rate_pct = this.getInt("xlog_sampling_step2_rate_pct", 10);
        this.xlog_sampling_step3_ms = this.getInt("xlog_sampling_step3_ms", 3000);
        this.xlog_sampling_step3_rate_pct = this.getInt("xlog_sampling_step3_rate_pct", 30);
        this.xlog_sampling_over_rate_pct = this.getInt("xlog_sampling_over_rate_pct", 100);
        this.xlog_patterned_sampling_enabled = this.getBoolean("xlog_patterned_sampling_enabled", false);
        this.xlog_patterned_sampling_service_patterns = this.getValue("xlog_patterned_sampling_service_patterns", "");
        this.xlog_patterned_sampling_only_profile = this.getBoolean("xlog_patterned_sampling_only_profile", false);
        this.xlog_patterned_sampling_step1_ms = this.getInt("xlog_patterned_sampling_step1_ms", 100);
        this.xlog_patterned_sampling_step1_rate_pct = this.getInt("xlog_patterned_sampling_step1_rate_pct", 3);
        this.xlog_patterned_sampling_step2_ms = this.getInt("xlog_patterned_sampling_step2_ms", 1000);
        this.xlog_patterned_sampling_step2_rate_pct = this.getInt("xlog_patterned_sampling_step2_rate_pct", 10);
        this.xlog_patterned_sampling_step3_ms = this.getInt("xlog_patterned_sampling_step3_ms", 3000);
        this.xlog_patterned_sampling_step3_rate_pct = this.getInt("xlog_patterned_sampling_step3_rate_pct", 30);
        this.xlog_patterned_sampling_over_rate_pct = this.getInt("xlog_patterned_sampling_over_rate_pct", 100);
        this.xlog_discard_service_patterns = this.getValue("xlog_discard_service_patterns", "");
        this.xlog_discard_service_show_error = this.getBoolean("xlog_discard_service_show_error", true);
        this.xlog_fully_discard_service_patterns = this.getValue("xlog_fully_discard_service_patterns", "");
        this.resetObjInfo();
        this.setStaticContents();
    }

    public String getObjExtType() {
        return this.objExtType;
    }

    public void setObjExtType(String objExtType) {
        this.objExtType = objExtType;
    }

    public String getObjDetectedType() {
        return this.objDetectedType;
    }

    public void setObjDetectedType(String objDetectedType) {
        this.objDetectedType = objDetectedType;
    }

    public int getObjHash() {
        return this.objHash;
    }

    public String getObjName() {
        return this.objName;
    }

    public int getObjHostHash() {
        return this.objHostHash;
    }

    public String getObjHostName() {
        return this.objHostName;
    }

    public int getEndUserPerfEndpointHash() {
        return this.enduser_perf_endpoint_hash;
    }

    public boolean isIgnoreLog(String id) {
        return this.log_ignore_set.hasKey(id);
    }

    private StringSet getStringSet(String key, String deli) {
        StringSet set = new StringSet();
        String v = this.getValue(key);
        if (v != null) {
            String[] vv;
            for (String x : vv = StringUtil.split(v, deli)) {
                if ((x = StringUtil.trimToEmpty(x)).length() <= 0) continue;
                set.put(x);
            }
        }
        return set;
    }

    private void setStaticContents() {
        HashSet<String> tmp = new HashSet<String>();
        String[] s = StringUtil.split(this.mgr_static_content_extensions, ',');
        for (int i = 0; i < s.length; ++i) {
            String ss = s[i].trim();
            if (ss.length() <= 0) continue;
            tmp.add(ss);
        }
        this.static_contents = tmp;
    }

    public boolean isStaticContents(String content) {
        return this.static_contents.contains(content);
    }

    public boolean isIgnoreMethodPrefix(String name) {
        for (int i = 0; i < this._hook_method_ignore_prefix_len; ++i) {
            if (!name.startsWith(this._hook_method_ignore_prefix[i])) continue;
            return true;
        }
        return false;
    }

    public StringSet getCustomJmxSet() {
        return this.custom_jmx_set;
    }

    public boolean isIgnoreMethodClass(String classname) {
        return this._hook_method_ignore_classes.hasKey(classname);
    }

    public synchronized void resetObjInfo() {
        String detected;
        this.objDetectedType = detected = ObjTypeDetector.drivedType != null ? ObjTypeDetector.drivedType : (ObjTypeDetector.objType != null ? ObjTypeDetector.objType : "java");
        this.monitoring_group_type = this.getValue("monitoring_group_type");
        this.obj_type = StringUtil.isEmpty(this.monitoring_group_type) ? this.getValue("obj_type", detected) : this.monitoring_group_type;
        this.objExtType = ObjTypeDetector.objExtType;
        detected = "host";
        if (SystemUtil.IS_LINUX) {
            detected = "linux";
        } else if (SystemUtil.IS_WINDOWS) {
            detected = "windows";
        } else if (SystemUtil.IS_MAC_OSX) {
            detected = "osx";
        } else if (SystemUtil.IS_AIX) {
            detected = "aix";
        } else if (SystemUtil.IS_HP_UX) {
            detected = "hpux";
        }
        this.obj_host_type = this.getValue("obj_host_type", detected);
        this.obj_host_name = this.getValue("obj_host_name", SysJMX.getHostName());
        this.objHostName = "/" + this.obj_host_name;
        this.objHostHash = HashUtil.hash(this.objHostName);
        this.obj_name_auto_pid_enabled = this.getBoolean("obj_name_auto_pid_enabled", false);
        String defaultName = this.obj_name_auto_pid_enabled ? "" + SysJMX.getProcessPID() : this.obj_type + "1";
        this.obj_name = this.getValue("obj_name", System.getProperty("jvmRoute", defaultName));
        this.objName = this.objHostName + "/" + this.obj_name;
        this.objHash = HashUtil.hash(this.objName);
        System.setProperty("scouter.objname", this.objName);
        System.setProperty("scouter.objtype", this.obj_type);
        System.setProperty("scouter.dir", agent_dir_path);
    }

    public String getValue(String key) {
        return StringUtil.trim(this.property.getProperty(key));
    }

    public String getValue(String key, String def) {
        return StringUtil.trim(this.property.getProperty(key, def));
    }

    public int getInt(String key, int def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Integer.parseInt(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public int getInt(String key, int def, int min) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Math.max(Integer.parseInt(v), min);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.max(def, min);
    }

    public long getLong(String key, long def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Long.parseLong(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Boolean.parseBoolean(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadText() {
        String string;
        File file = this.getPropertyFile();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            byte[] buff = FileUtil.readAll(fin);
            string = new String(buff);
        }
        catch (Exception exception) {
            FileUtil.close(fin);
            return null;
        }
        catch (Throwable throwable) {
            FileUtil.close(fin);
            throw throwable;
        }
        FileUtil.close(fin);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public boolean saveText(String text) {
        boolean bl;
        File file = this.getPropertyFile();
        FileOutputStream out = null;
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            ((OutputStream)out).write(text.getBytes());
            bl = true;
        }
        catch (Exception exception) {
            FileUtil.close(out);
            catch (Throwable throwable) {
                FileUtil.close(out);
                throw throwable;
            }
        }
        FileUtil.close(out);
        return bl;
        return false;
    }

    public void printConfig() {
        Logger.info("Configure -Dscouter.config=" + this.propertyFile);
    }

    public MapValue getKeyValueInfo() {
        StringKeyLinkedMap<Object> defMap = ConfigValueUtil.getConfigDefault(new Configure(true));
        StringKeyLinkedMap<Object> curMap = ConfigValueUtil.getConfigDefault(this);
        MapValue m = new MapValue();
        ListValue nameList = m.newList("key");
        ListValue valueList = m.newList("value");
        ListValue defList = m.newList("default");
        StringEnumer enu = defMap.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextString();
            if (ignoreSet.contains(key)) continue;
            nameList.add(key);
            valueList.add(ConfigValueUtil.toValue(curMap.get(key)));
            defList.add(ConfigValueUtil.toValue(defMap.get(key)));
        }
        return m;
    }

    public StringKeyLinkedMap<String> getConfigureDesc() {
        return ConfigValueUtil.getConfigDescMap(this);
    }

    public StringKeyLinkedMap<ValueType> getConfigureValueType() {
        return ConfigValueUtil.getConfigValueTypeMap(this);
    }

    public int getHookSignature() {
        return this.hook_signature;
    }

    public static void main(String[] args) {
        Configure o = new Configure(true);
        StringKeyLinkedMap<Object> defMap = ConfigValueUtil.getConfigDefault(o);
        StringKeyLinkedMap<String> descMap = ConfigValueUtil.getConfigDescMap(o);
        StringEnumer enu = defMap.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextString();
            if (ignoreSet.contains(key)) continue;
            System.out.println(key + " : " + ConfigValueUtil.toValue(defMap.get(key)) + (descMap.containsKey(key) ? " (" + descMap.get(key) + ")" : ""));
        }
    }

    static {
        File jarFile = JarUtil.getThisJarFile();
        agent_dir_path = jarFile == null ? new File("./").getAbsolutePath() : jarFile.getParent();
        instance = new Configure();
        instance.setDaemon(true);
        instance.setName(ThreadUtil.getName(instance));
        instance.start();
        ignoreSet = new HashSet();
        ignoreSet.add("property");
        ignoreSet.add("__experimental");
        ignoreSet.add("_profile_http_header_keys");
    }
}

