/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import scouter.lang.pack.AlertPack;
import scouter.lang.pack.BatchPack;
import scouter.lang.pack.InteractionPerfCounterPack;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.pack.SpanContainerPack;
import scouter.lang.pack.SpanPack;
import scouter.lang.pack.StackPack;
import scouter.lang.pack.StatusPack;
import scouter.lang.pack.SummaryPack;
import scouter.lang.pack.TextPack;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogProfilePack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.DoubleValue;
import scouter.lang.value.FloatValue;
import scouter.lang.value.NullValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;

public abstract class PackEnum {
    private static PackEnum extPackEnum;
    public static final byte MAP = 10;
    public static final byte XLOG = 21;
    public static final byte XLOG_PROFILE = 26;
    public static final byte SPAN = 31;
    public static final byte SPAN_CONTAINER = 32;
    public static final byte TEXT = 50;
    public static final byte PERF_COUNTER = 60;
    public static final byte PERF_STATUS = 61;
    public static final byte STACK = 62;
    public static final byte SUMMARY = 63;
    public static final byte BATCH = 64;
    public static final byte PERF_INTERACTION_COUNTER = 65;
    public static final byte ALERT = 70;
    public static final byte OBJECT = 80;

    public static Pack create(byte packType) {
        Pack pack = PackEnum.createNonExt(packType);
        if (pack == null) {
            if (extPackEnum != null) {
                pack = extPackEnum.createExt(packType);
            }
            if (pack == null) {
                throw new RuntimeException("Unknown pack type= " + packType);
            }
        }
        return pack;
    }

    public static Pack createNonExt(byte packType) {
        switch (packType) {
            case 10: {
                return new MapPack();
            }
            case 60: {
                return new PerfCounterPack();
            }
            case 61: {
                return new StatusPack();
            }
            case 26: {
                return new XLogProfilePack();
            }
            case 21: {
                return new XLogPack();
            }
            case 50: {
                return new TextPack();
            }
            case 70: {
                return new AlertPack();
            }
            case 80: {
                return new ObjectPack();
            }
            case 62: {
                return new StackPack();
            }
            case 63: {
                return new SummaryPack();
            }
            case 64: {
                return new BatchPack();
            }
            case 65: {
                return new InteractionPerfCounterPack();
            }
            case 31: {
                return new SpanPack();
            }
            case 32: {
                return new SpanContainerPack();
            }
        }
        return null;
    }

    public abstract Pack createExt(byte var1);

    public static synchronized void registPackEnum(PackEnum packEnum) {
        extPackEnum = packEnum;
    }

    public static Value toValue(Object value) throws Exception {
        if (value == null) {
            return new NullValue();
        }
        if (value instanceof String) {
            return new TextValue((String)value);
        }
        if (value instanceof Number) {
            if (value instanceof Float) {
                return new FloatValue(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return new DoubleValue((Double)value);
            }
            return new DecimalValue(((Number)value).longValue());
        }
        return new TextValue(value.toString());
    }
}

