/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.step;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.step.StepEnum;
import scouter.lang.step.ThreadCallPossibleStep;

public abstract class Step
implements Comparable<Step> {
    @Override
    public int compareTo(Step o) {
        return this.getOrder() - o.getOrder();
    }

    public abstract int getOrder();

    public abstract byte getStepType();

    public String getStepTypeName() {
        return StepEnum.Type.of(this.getStepType()).name();
    }

    public abstract void write(DataOutputX var1) throws IOException;

    public abstract Step read(DataInputX var1) throws IOException;

    public static byte[] toBytes(Step[] p) {
        if (p == null) {
            return null;
        }
        try {
            DataOutputX dout = new DataOutputX(p.length * 30);
            for (int i = 0; i < p.length; ++i) {
                if (p[i] instanceof ThreadCallPossibleStep) {
                    ThreadCallPossibleStep tstep = (ThreadCallPossibleStep)p[i];
                    if (tstep.threaded != 1 && tstep.isIgnoreIfNoThreaded) continue;
                    dout.writeStep(p[i]);
                    continue;
                }
                dout.writeStep(p[i]);
            }
            return dout.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] toBytes(List<Step> p) {
        if (p == null) {
            return null;
        }
        try {
            int size = p.size();
            DataOutputX dout = new DataOutputX(size * 30);
            for (int i = 0; i < size; ++i) {
                dout.writeStep(p.get(i));
            }
            return dout.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Step[] toObjects(byte[] buff) throws IOException {
        if (buff == null) {
            return null;
        }
        ArrayList<Step> arr = new ArrayList<Step>();
        DataInputX din = new DataInputX(buff);
        while (din.available() > 0) {
            arr.add(din.readStep());
        }
        return arr.toArray(new Step[arr.size()]);
    }

    public static List<Step> toObjectList(byte[] buff) {
        if (buff == null) {
            return null;
        }
        ArrayList<Step> arr = new ArrayList<Step>();
        DataInputX din = new DataInputX(buff);
        try {
            while (din.available() > 0) {
                arr.add(din.readStep());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return arr;
    }

    public static List<Step> toDecodedObjectList(byte[] buff) {
        if (buff == null) {
            return null;
        }
        ArrayList<Step> arr = new ArrayList<Step>();
        DataInputX din = new DataInputX(buff);
        try {
            while (din.available() > 0) {
                arr.add(din.readStep());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return arr;
    }
}

