/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.asyncsupport.executor;

import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.asm.IASM;
import scouter.agent.asm.asyncsupport.executor.AbstractExecutorServiceCV;
import scouter.agent.asm.asyncsupport.executor.ThreadPoolExecutorCV;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class ExecutorServiceASM
implements IASM,
Opcodes {
    private static final String THREAD_POOL_EXECUTOR_CLASS_NAME = "java/util/concurrent/ThreadPoolExecutor";
    private static final String ABSTRACT_EXECUTOR_SERVICE_CLASS_NAME = "java/util/concurrent/AbstractExecutorService";
    private Configure conf = Configure.getInstance();

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf.hook_async_thread_pool_executor_enabled) {
            return cv;
        }
        Logger.trace("[SCTRACE]className IN ExecutorServiceASM : " + className);
        if (THREAD_POOL_EXECUTOR_CLASS_NAME.equals(className)) {
            Logger.trace("[SCTRACE]transform ThreadPoolExecutor");
            return new ThreadPoolExecutorCV(cv, className);
        }
        if (ABSTRACT_EXECUTOR_SERVICE_CLASS_NAME.equals(className)) {
            Logger.trace("[SCTRACE]transform AbstractExecutorService");
            return new AbstractExecutorServiceCV(cv, className);
        }
        return cv;
    }
}

